/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.HillClimbingClusterer;
import cc.mallet.cluster.neighbor_evaluator.AgglomerativeNeighbor;
import cc.mallet.cluster.neighbor_evaluator.NeighborEvaluator;
import cc.mallet.cluster.util.ClusterUtils;
import cc.mallet.cluster.util.PairwiseMatrix;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletProgressMessageLogger;
import java.util.logging.Logger;

public class GreedyAgglomerative
extends HillClimbingClusterer {
    private static final long serialVersionUID = 1L;
    private static Logger progressLogger = MalletProgressMessageLogger.getLogger(GreedyAgglomerative.class.getName() + "-pl");
    protected double stoppingThreshold;
    protected boolean converged;
    protected PairwiseMatrix scoreCache;

    public GreedyAgglomerative(Pipe instancePipe, NeighborEvaluator evaluator, double stoppingThreshold) {
        super(instancePipe, evaluator);
        this.stoppingThreshold = stoppingThreshold;
        this.converged = false;
    }

    @Override
    public Clustering initializeClustering(InstanceList instances) {
        this.reset();
        return ClusterUtils.createSingletonClustering(instances);
    }

    @Override
    public boolean converged(Clustering clustering) {
        return this.converged;
    }

    @Override
    public void reset() {
        this.converged = false;
        this.scoreCache = null;
        this.evaluator.reset();
    }

    @Override
    public Clustering improveClustering(Clustering clustering) {
        double bestScore = Double.NEGATIVE_INFINITY;
        int[] toMerge = new int[]{-1, -1};
        for (int i = 0; i < clustering.getNumClusters(); ++i) {
            for (int j = i + 1; j < clustering.getNumClusters(); ++j) {
                double score = this.getScore(clustering, i, j);
                if (!(score > bestScore)) continue;
                bestScore = score;
                toMerge[0] = i;
                toMerge[1] = j;
            }
        }
        boolean bl = this.converged = bestScore < this.stoppingThreshold;
        if (!this.converged) {
            progressLogger.info("Merging " + toMerge[0] + "(" + clustering.size(toMerge[0]) + " nodes) and " + toMerge[1] + "(" + clustering.size(toMerge[1]) + " nodes) [" + bestScore + "] numClusters=" + clustering.getNumClusters());
            this.updateScoreMatrix(clustering, toMerge[0], toMerge[1]);
            clustering = ClusterUtils.mergeClusters(clustering, toMerge[0], toMerge[1]);
        } else {
            progressLogger.info("Converged with score " + bestScore);
        }
        return clustering;
    }

    protected double getScore(Clustering clustering, int i, int j) {
        int[] cj;
        int[] ci;
        if (this.scoreCache == null) {
            this.scoreCache = new PairwiseMatrix(clustering.getNumInstances());
        }
        if (this.scoreCache.get((ci = clustering.getIndicesWithLabel(i))[0], (cj = clustering.getIndicesWithLabel(j))[0]) == 0.0) {
            double val = this.evaluator.evaluate(new AgglomerativeNeighbor(clustering, ClusterUtils.copyAndMergeClusters(clustering, i, j), ci, cj));
            for (int ni = 0; ni < ci.length; ++ni) {
                for (int nj = 0; nj < cj.length; ++nj) {
                    this.scoreCache.set(ci[ni], cj[nj], val);
                }
            }
        }
        return this.scoreCache.get(ci[0], cj[0]);
    }

    protected void updateScoreMatrix(Clustering clustering, int i, int j) {
        int size = clustering.getNumInstances();
        int[] ci = clustering.getIndicesWithLabel(i);
        for (int ni = 0; ni < ci.length; ++ni) {
            for (int nj = 0; nj < size; ++nj) {
                if (ci[ni] == nj) continue;
                this.scoreCache.set(ci[ni], nj, 0.0);
            }
        }
        int[] cj = clustering.getIndicesWithLabel(j);
        for (int ni = 0; ni < cj.length; ++ni) {
            for (int nj = 0; nj < size; ++nj) {
                if (cj[ni] == nj) continue;
                this.scoreCache.set(cj[ni], nj, 0.0);
            }
        }
    }

    public String toString() {
        return "class=" + this.getClass().getName() + "\nstoppingThreshold=" + this.stoppingThreshold + "\nneighborhoodEvaluator=[" + this.evaluator + "]";
    }
}

