% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_files.R
\name{summary.filesearch}
\alias{summary.filesearch}
\title{Summarize File Searches}
\usage{
\method{summary}{filesearch}(object, ..., type = c("file", "what", "matches"))
}
\arguments{
\item{object}{An object returned by \code{\link{search_files}}.}

\item{...}{Needed for compatibility.}

\item{type}{Type of summary.}
}
\value{
A summarized object.
}
\description{
A custom summary function for objects returned by \code{\link{search_files}}.
}
\examples{
write.csv(mtcars, file.path(tempdir(), "mtcars.csv"))
 for (i in 0:9) {
     write.csv(iris, file.path(tempdir(), paste0("iris", i, ".csv")))
 }
search_files(what = "Mazda", path = tempdir(), pattern = "^.*\\\\.csv$")
search_files(what = "[Ss]etosa", path = tempdir(), pattern = "^.*\\\\.csv$")
x <- search_files(path = tempdir(),
                  pattern = "^.*\\\\.csv$",
                  exclude = "[2-9]\\\\.csv$",
                  what = "[Ss]etosa")
summary(x)
summary(x, type = "what")
summary(x, type = "matches")
try(search_files(what = "ABC", path = tempdir(), pattern = "^.*\\\\.csv$"))
}
\seealso{
Other searching functions: 
\code{\link{compare_vectors}()},
\code{\link{file_modified_last}()},
\code{\link{find_files}()},
\code{\link{fromto}()},
\code{\link{missing_docs}},
\code{\link{search_files}()},
\code{\link{search_rows}()}
}
\concept{searching functions}
