/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import moa.gui.ClassOptionWithNamesSelectionPanel;
import moa.gui.OptionEditComponent;
import moa.options.ClassOptionWithNames;
import moa.options.Option;

public class ClassOptionWithNamesEditComponent
extends JPanel
implements OptionEditComponent {
    private static final long serialVersionUID = 1L;
    protected ClassOptionWithNames editedOption;
    protected JTextField textField = new JTextField();
    protected JButton editButton = new JButton("Edit");
    protected HashSet<ChangeListener> changeListeners = new HashSet();

    public ClassOptionWithNamesEditComponent(ClassOptionWithNames option) {
        this.editedOption = option;
        this.textField.setEditable(false);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                ClassOptionWithNamesEditComponent.this.notifyChangeListeners();
            }

            public void insertUpdate(DocumentEvent e) {
                ClassOptionWithNamesEditComponent.this.notifyChangeListeners();
            }

            public void changedUpdate(DocumentEvent e) {
                ClassOptionWithNamesEditComponent.this.notifyChangeListeners();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.editButton, "East");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ClassOptionWithNamesEditComponent.this.editObject();
            }
        });
        this.setEditState(this.editedOption.getValueAsCLIString());
    }

    public void applyState() {
        this.editedOption.setValueViaCLIString(this.textField.getText());
    }

    public Option getEditedOption() {
        return this.editedOption;
    }

    public void setEditState(String cliString) {
        this.textField.setText(cliString);
    }

    public void editObject() {
        this.setEditState(ClassOptionWithNamesSelectionPanel.showSelectClassDialog(this, "Editing option: " + this.editedOption.getName(), this.editedOption.getRequiredType(), this.textField.getText(), this.editedOption.getNullString(), this.editedOption.getClassNames()));
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }
}

