/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.SVM.SMO.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import keel.Algorithms.SVM.SMO.core.FastVector;
import keel.Algorithms.SVM.SMO.core.Instance;
import keel.Algorithms.SVM.SMO.core.UnassignedClassException;
import keel.Algorithms.SVM.SMO.core.Utils;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import org.core.Randomize;

public class Instances
implements Serializable {
    static final long serialVersionUID = -19412345060742748L;
    public static final String FILE_EXTENSION = ".arff";
    public static final String SERIALIZED_OBJ_FILE_EXTENSION = ".bsi";
    public static final String ARFF_RELATION = "@relation";
    public static final String ARFF_DATA = "@data";
    protected String m_RelationName;
    protected FastVector m_Attributes;
    protected FastVector m_Instances;
    protected int m_ClassIndex;
    protected int m_Lines = 0;

    public Instances(Instances dataset) {
        this(dataset, dataset.numInstances());
        dataset.copyInstances(0, this, dataset.numInstances());
    }

    public Instances(Instances dataset, int capacity) {
        this.initialize(dataset, capacity);
    }

    protected void initialize(Instances dataset, int capacity) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.m_ClassIndex = dataset.m_ClassIndex;
        this.m_RelationName = dataset.m_RelationName;
        this.m_Attributes = dataset.m_Attributes;
        this.m_Instances = new FastVector(capacity);
    }

    public Instances(Instances source, int first, int toCopy) {
        this(source, toCopy);
        if (first < 0 || first + toCopy > source.numInstances()) {
            throw new IllegalArgumentException("Parameters first and/or toCopy out of range");
        }
        source.copyInstances(first, this, toCopy);
    }

    public Instances(String name, FastVector attInfo, int capacity) {
        this.m_RelationName = name;
        this.m_ClassIndex = -1;
        this.m_Attributes = attInfo;
        this.m_Instances = new FastVector(capacity);
    }

    public void add(Instance instance) {
        Instance newInstance = (Instance)instance.copy();
        newInstance.setDataset(this);
        this.m_Instances.addElement(newInstance);
    }

    public Attribute attribute(int index) {
        return (Attribute)this.m_Attributes.elementAt(index);
    }

    public Attribute attribute(String name) {
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (!this.attribute(i).getName().equals(name)) continue;
            return this.attribute(i);
        }
        return null;
    }

    public boolean checkForAttributeType(int attType) {
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (this.attribute(i++).getType() != attType) continue;
            return true;
        }
        return false;
    }

    public boolean checkForStringAttributes() {
        return this.checkForAttributeType(0);
    }

    public boolean checkInstance(Instance instance) {
        if (instance.numAttributes() != this.numAttributes()) {
            return false;
        }
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (instance.isMissing(i) || this.attribute(i).getType() != 0) continue;
            if (!Utils.eq(instance.value(i), (int)instance.value(i))) {
                return false;
            }
            if (!Utils.sm(instance.value(i), 0.0) && !Utils.gr(instance.value(i), this.attribute(i).getNumNominalValues())) continue;
            return false;
        }
        return true;
    }

    public Attribute classAttribute() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        return this.attribute(this.m_ClassIndex);
    }

    public int classIndex() {
        return this.m_ClassIndex;
    }

    public void compactify() {
        this.m_Instances.trimToSize();
    }

    public void delete() {
        this.m_Instances = new FastVector();
    }

    public void delete(int index) {
        this.m_Instances.removeElementAt(index);
    }

    public void deleteAttributeAt(int position) {
        int i;
        if (position < 0 || position >= this.m_Attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        if (position == this.m_ClassIndex) {
            throw new IllegalArgumentException("Can't delete class attribute");
        }
        this.freshAttributeInfo();
        if (this.m_ClassIndex > position) {
            --this.m_ClassIndex;
        }
        this.m_Attributes.removeElementAt(position);
        for (i = position; i < this.m_Attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.m_Attributes.elementAt(i);
        }
        for (i = 0; i < this.numInstances(); ++i) {
            this.instance(i).forceDeleteAttributeAt(position);
        }
    }

    public void deleteAttributeType(int attType) {
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (this.attribute(i).getType() == attType) {
                this.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
    }

    public void deleteStringAttributes() {
        this.deleteAttributeType(0);
    }

    public void deleteWithMissing(int attIndex) {
        FastVector newInstances = new FastVector(this.numInstances());
        for (int i = 0; i < this.numInstances(); ++i) {
            if (this.instance(i).isMissing(attIndex)) continue;
            newInstances.addElement(this.instance(i));
        }
        this.m_Instances = newInstances;
    }

    public void deleteWithMissing(Attribute att) {
        this.deleteWithMissing(this.indexOf(att));
    }

    public void deleteWithMissingClass() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        this.deleteWithMissing(this.m_ClassIndex);
    }

    public Enumeration enumerateAttributes() {
        return this.m_Attributes.elements(this.m_ClassIndex);
    }

    public Enumeration enumerateInstances() {
        return this.m_Instances.elements();
    }

    public boolean equalHeaders(Instances dataset) {
        if (this.m_ClassIndex != dataset.m_ClassIndex) {
            return false;
        }
        if (this.m_Attributes.size() != dataset.m_Attributes.size()) {
            return false;
        }
        for (int i = 0; i < this.m_Attributes.size(); ++i) {
            if (this.attribute(i).equals(dataset.attribute(i))) continue;
            return false;
        }
        return true;
    }

    public Instance firstInstance() {
        return (Instance)this.m_Instances.firstElement();
    }

    public Random getRandomNumberGenerator(long seed) {
        Random r = new Random(seed);
        r.setSeed((long)this.instance(r.nextInt(this.numInstances())).toString().hashCode() + seed);
        return r;
    }

    public void insertAttributeAt(Attribute att, int position) {
        int i;
        if (position < 0 || position > this.m_Attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        this.freshAttributeInfo();
        this.m_Attributes.insertElementAt(att, position);
        for (i = position + 1; i < this.m_Attributes.size(); ++i) {
            Attribute current = (Attribute)this.m_Attributes.elementAt(i);
        }
        for (i = 0; i < this.numInstances(); ++i) {
            this.instance(i).forceInsertAttributeAt(position);
        }
        if (this.m_ClassIndex >= position) {
            ++this.m_ClassIndex;
        }
    }

    public Instance instance(int index) {
        return (Instance)this.m_Instances.elementAt(index);
    }

    public double kthSmallestValue(Attribute att, int k) {
        return this.kthSmallestValue(this.indexOf(att), k);
    }

    public double kthSmallestValue(int attIndex, int k) {
        if (this.attribute(attIndex).getType() == 0) {
            throw new IllegalArgumentException("Instances: attribute must be numeric to compute kth-smallest value.");
        }
        int j = this.numInstances() - 1;
        int i = 0;
        while (i <= j) {
            if (this.instance(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.instance(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        if (k < 0 || k > j) {
            throw new IllegalArgumentException("Instances: value for k for computing kth-smallest value too large.");
        }
        return this.instance(this.select(attIndex, 0, j, k)).value(attIndex);
    }

    public Instance lastInstance() {
        return (Instance)this.m_Instances.lastElement();
    }

    public double meanOrMode(int attIndex) {
        if (this.attribute(attIndex).getType() != 0) {
            double found = 0.0;
            double result = 0.0;
            for (int j = 0; j < this.numInstances(); ++j) {
                if (this.instance(j).isMissing(attIndex)) continue;
                found += this.instance(j).weight();
                result += this.instance(j).weight() * this.instance(j).value(attIndex);
            }
            if (found <= 0.0) {
                return 0.0;
            }
            return result / found;
        }
        if (this.attribute(attIndex).getType() == 0) {
            int[] counts = new int[this.attribute(attIndex).getNumNominalValues()];
            for (int j = 0; j < this.numInstances(); ++j) {
                if (this.instance(j).isMissing(attIndex)) continue;
                int n = (int)this.instance(j).value(attIndex);
                counts[n] = (int)((double)counts[n] + this.instance(j).weight());
            }
            return Utils.maxIndex(counts);
        }
        return 0.0;
    }

    public double meanOrMode(Attribute att) {
        return this.meanOrMode(this.indexOf(att));
    }

    public int numAttributes() {
        return this.m_Attributes.size();
    }

    public int numClasses() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (this.classAttribute().getType() != 0) {
            return 1;
        }
        return this.classAttribute().getNumNominalValues();
    }

    public int numDistinctValues(int attIndex) {
        if (this.attribute(attIndex).getType() != 0) {
            Instance current;
            double[] attVals = this.attributeToDoubleArray(attIndex);
            int[] sorted = Utils.sort(attVals);
            double prev = 0.0;
            int counter = 0;
            for (int i = 0; i < sorted.length && !(current = this.instance(sorted[i])).isMissing(attIndex); ++i) {
                if (i != 0 && !(current.value(attIndex) > prev)) continue;
                prev = current.value(attIndex);
                ++counter;
            }
            return counter;
        }
        return this.attribute(attIndex).getNumNominalValues();
    }

    public int numDistinctValues(Attribute att) {
        return this.numDistinctValues(this.indexOf(att));
    }

    public int numInstances() {
        return this.m_Instances.size();
    }

    public void randomize(Random random) {
        for (int j = this.numInstances() - 1; j > 0; --j) {
            this.swap(j, random.nextInt(j + 1));
        }
    }

    public void randomize() {
        for (int j = this.numInstances() - 1; j > 0; --j) {
            this.swap(j, Randomize.Randint(0, j + 1));
        }
    }

    public String relationName() {
        return this.m_RelationName;
    }

    public Instances resample(Random random) {
        Instances newData = new Instances(this, this.numInstances());
        while (newData.numInstances() < this.numInstances()) {
            newData.add(this.instance(random.nextInt(this.numInstances())));
        }
        return newData;
    }

    public Instances resampleWithWeights(Random random) {
        double[] weights = new double[this.numInstances()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = this.instance(i).weight();
        }
        return this.resampleWithWeights(random, weights);
    }

    public Instances resampleWithWeights(Random random, double[] weights) {
        if (weights.length != this.numInstances()) {
            throw new IllegalArgumentException("weights.length != numInstances.");
        }
        Instances newData = new Instances(this, this.numInstances());
        if (this.numInstances() == 0) {
            return newData;
        }
        double[] probabilities = new double[this.numInstances()];
        double sumProbs = 0.0;
        double sumOfWeights = Utils.sum(weights);
        for (int i = 0; i < this.numInstances(); ++i) {
            probabilities[i] = sumProbs += random.nextDouble();
        }
        Utils.normalize(probabilities, sumProbs / sumOfWeights);
        probabilities[this.numInstances() - 1] = sumOfWeights;
        int k = 0;
        sumProbs = 0.0;
        for (int l = 0; k < this.numInstances() && l < this.numInstances(); ++l) {
            if (weights[l] < 0.0) {
                throw new IllegalArgumentException("Weights have to be positive.");
            }
            sumProbs += weights[l];
            while (k < this.numInstances() && probabilities[k] <= sumProbs) {
                newData.add(this.instance(l));
                newData.instance(k).setWeight(1.0);
                ++k;
            }
        }
        return newData;
    }

    public void setClass(Attribute att) {
        this.m_ClassIndex = this.indexOf(att);
    }

    public void setClassIndex(int classIndex) {
        if (classIndex >= this.numAttributes()) {
            throw new IllegalArgumentException("Invalid class index: " + classIndex);
        }
        this.m_ClassIndex = classIndex;
    }

    public void setRelationName(String newName) {
        this.m_RelationName = newName;
    }

    public void sort(int attIndex) {
        int j = this.numInstances() - 1;
        int i = 0;
        while (i <= j) {
            if (this.instance(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.instance(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        this.quickSort(attIndex, 0, j);
    }

    public void sort(Attribute att) {
        this.sort(this.indexOf(att));
    }

    public void stratify(int numFolds) {
        if (numFolds <= 0) {
            throw new IllegalArgumentException("Number of folds must be greater than 1");
        }
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (this.classAttribute().getType() == 0) {
            for (int index = 1; index < this.numInstances(); ++index) {
                Instance instance1 = this.instance(index - 1);
                for (int j = index; j < this.numInstances(); ++j) {
                    Instance instance2 = this.instance(j);
                    if (instance1.classValue() != instance2.classValue() && (!instance1.classIsMissing() || !instance2.classIsMissing())) continue;
                    this.swap(index, j);
                    ++index;
                }
            }
            this.stratStep(numFolds);
        }
    }

    public double sumOfWeights() {
        double sum = 0.0;
        for (int i = 0; i < this.numInstances(); ++i) {
            sum += this.instance(i).weight();
        }
        return sum;
    }

    public Instances testCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances test = new Instances(this, numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(first, test, numInstForFold);
        return test;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_RELATION).append(" ").append(Utils.quote(this.m_RelationName)).append("\n\n");
        for (int i = 0; i < this.numAttributes(); ++i) {
            text.append(this.attribute(i)).append("\n");
        }
        text.append("\n").append(ARFF_DATA).append("\n");
        text.append(this.stringWithoutHeader());
        return text.toString();
    }

    protected String stringWithoutHeader() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            text.append(this.instance(i));
            if (i >= this.numInstances() - 1) continue;
            text.append('\n');
        }
        return text.toString();
    }

    public Instances trainCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances train = new Instances(this, this.numInstances() - numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(0, train, first);
        this.copyInstances(first + numInstForFold, train, this.numInstances() - first - numInstForFold);
        return train;
    }

    public Instances trainCV(int numFolds, int numFold, Random random) {
        Instances train = this.trainCV(numFolds, numFold);
        train.randomize(random);
        return train;
    }

    public double variance(int attIndex) {
        double sum = 0.0;
        double sumSquared = 0.0;
        double sumOfWeights = 0.0;
        if (this.attribute(attIndex).getType() == 0) {
            throw new IllegalArgumentException("Can't compute variance because attribute is not numeric!");
        }
        for (int i = 0; i < this.numInstances(); ++i) {
            if (this.instance(i).isMissing(attIndex)) continue;
            sum += this.instance(i).weight() * this.instance(i).value(attIndex);
            sumSquared += this.instance(i).weight() * this.instance(i).value(attIndex) * this.instance(i).value(attIndex);
            sumOfWeights += this.instance(i).weight();
        }
        if (sumOfWeights <= 1.0) {
            return 0.0;
        }
        double result = (sumSquared - sum * sum / sumOfWeights) / (sumOfWeights - 1.0);
        if (result < 0.0) {
            return 0.0;
        }
        return result;
    }

    public double variance(Attribute att) {
        return this.variance(this.indexOf(att));
    }

    public double[] attributeToDoubleArray(int index) {
        double[] result = new double[this.numInstances()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.instance(i).value(index);
        }
        return result;
    }

    protected void copyInstances(int from, Instances dest, int num) {
        for (int i = 0; i < num; ++i) {
            dest.add(this.instance(from + i));
        }
    }

    protected void freshAttributeInfo() {
        this.m_Attributes = (FastVector)this.m_Attributes.copyElements();
    }

    protected String instancesAndWeights() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            text.append(this.instance(i) + " " + this.instance(i).weight());
            if (i >= this.numInstances() - 1) continue;
            text.append("\n");
        }
        return text.toString();
    }

    protected int partition(int attIndex, int l, int r) {
        double pivot = this.instance((l + r) / 2).value(attIndex);
        while (l < r) {
            while (this.instance(l).value(attIndex) < pivot && l < r) {
                ++l;
            }
            while (this.instance(r).value(attIndex) > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            this.swap(l, r);
            ++l;
            --r;
        }
        if (l == r && this.instance(r).value(attIndex) > pivot) {
            --r;
        }
        return r;
    }

    protected void quickSort(int attIndex, int left, int right) {
        if (left < right) {
            int middle = this.partition(attIndex, left, right);
            this.quickSort(attIndex, left, middle);
            this.quickSort(attIndex, middle + 1, right);
        }
    }

    protected int select(int attIndex, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = this.partition(attIndex, left, right);
        if (middle - left + 1 >= k) {
            return this.select(attIndex, left, middle, k);
        }
        return this.select(attIndex, middle + 1, right, k - (middle - left + 1));
    }

    protected void stratStep(int numFolds) {
        FastVector newVec = new FastVector(this.m_Instances.capacity());
        int start = 0;
        while (newVec.size() < this.numInstances()) {
            for (int j = start; j < this.numInstances(); j += numFolds) {
                newVec.addElement(this.instance(j));
            }
            ++start;
        }
        this.m_Instances = newVec;
    }

    public void swap(int i, int j) {
        this.m_Instances.swap(i, j);
    }

    public static Instances mergeInstances(Instances first, Instances second) {
        int i;
        if (first.numInstances() != second.numInstances()) {
            throw new IllegalArgumentException("Instance sets must be of the same size");
        }
        FastVector newAttributes = new FastVector();
        for (i = 0; i < first.numAttributes(); ++i) {
            newAttributes.addElement(first.attribute(i));
        }
        for (i = 0; i < second.numAttributes(); ++i) {
            newAttributes.addElement(second.attribute(i));
        }
        Instances merged = new Instances(first.relationName() + '_' + second.relationName(), newAttributes, first.numInstances());
        for (int i2 = 0; i2 < first.numInstances(); ++i2) {
            merged.add(first.instance(i2).mergeInstance(second.instance(i2)));
        }
        return merged;
    }

    protected int indexOf(Attribute att) {
        int index = -1;
        for (int i = 0; i < Attributes.getNumAttributes() && index == -1; ++i) {
            if (Attributes.getAttribute(i) != att) continue;
            index = i;
        }
        return index;
    }

    protected int indexOfValue(Attribute att, String value) {
        Vector vals = att.getNominalValuesList();
        int index = -1;
        for (int i = 0; i < vals.size() && index == -1; ++i) {
            String s = (String)vals.get(i);
            if (value.compareTo(s) != 0) continue;
            index = i;
        }
        return index;
    }
}

