/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms.GeneticAlgorithm;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividual;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidFitness;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import keel.Algorithms.Shared.Exceptions.invalidOptim;
import org.core.Randomize;

public class AlgorithmGAPGen
extends GeneticAlgorithm {
    GeneticIndividual[][] population;
    GeneticIndividual[][] intermediatePopulation;
    GeneticIndividual[] elite;
    double[][] fitnessCache;
    double[][] fitnessMark;
    double CROSSOVERPROB;
    double MUTATIONPROB;
    double MUTATIONAMPL;
    double MIGRATIONPROB;
    double GACROSSOVERPROB;
    double GAMUTATIONPROB;
    double LOCALOPTPROB;
    int LOCALOPTITER;
    double[] fitnessMean;
    double[] bestFitness;
    static Randomize rand;
    int GACROSSOVERID;
    int GPCROSSOVERID;
    int GAMUTATIONID;
    int GPMUTATIONID;
    int LOID;

    public AlgorithmGAPGen(GeneticIndividual initialIndividual, int pPopSize, int pGenerations, double PM, double AMP, double PMIG, double pGACrossoverProb, double pGAMutationProb, double pLOptProb, int NOL, int IOL, Randomize r, int pGACrossoverID, int pGPCrossoverID, int pGAMutationID, int pGPMutationID) {
        rand = r;
        this.population = new GeneticIndividual[pGenerations][pPopSize];
        this.intermediatePopulation = new GeneticIndividual[pGenerations][pPopSize];
        this.fitnessCache = new double[pGenerations][pPopSize];
        this.fitnessMark = new double[pGenerations][pPopSize];
        this.fitnessMean = new double[pGenerations];
        this.bestFitness = new double[pGenerations];
        this.elite = new GeneticIndividual[pGenerations];
        this.MUTATIONPROB = PM;
        this.MUTATIONAMPL = AMP;
        this.MIGRATIONPROB = PMIG;
        this.GACROSSOVERID = pGACrossoverID;
        this.GPCROSSOVERID = pGPCrossoverID;
        this.GAMUTATIONID = pGAMutationID;
        this.GPMUTATIONID = pGPMutationID;
        this.GACROSSOVERPROB = pGACrossoverProb;
        this.GAMUTATIONPROB = pGAMutationProb;
        this.LOCALOPTPROB = pLOptProb;
        this.LOCALOPTITER = NOL;
        this.LOID = IOL;
        try {
            for (int p = 0; p < pGenerations; ++p) {
                this.elite[p] = initialIndividual.clone();
                for (int i = 0; i < pPopSize; ++i) {
                    System.out.println("Initialiting the population[" + i + "]");
                    this.population[p][i] = initialIndividual.clone();
                    this.intermediatePopulation[p][i] = initialIndividual.clone();
                    this.population[p][i].Random();
                    this.fitnessCache[p][i] = this.population[p][i].fitness();
                    int n = p;
                    this.fitnessMean[n] = this.fitnessMean[n] + this.fitnessCache[p][i];
                    if (!(this.fitnessCache[p][i] < this.bestFitness[p]) && i != 0) continue;
                    this.bestFitness[p] = this.fitnessCache[p][i];
                }
            }
        }
        catch (invalidFitness f) {
            System.out.println("Unsupported fitness");
        }
    }

    @Override
    public GeneticIndividual evolve(int MAXITER) throws invalidCrossover, invalidMutation, invalidOptim {
        int p;
        System.out.println("Doing " + MAXITER + " generations");
        int pGenerations = this.population.length;
        int pPopSize = this.population[0].length;
        int[] thisIsTheBestIndividual = new int[pGenerations];
        double[] fitnesselite = new double[pGenerations];
        double[] bestFitness = new double[pGenerations];
        double[] thisIsTheWorstFitness = new double[pGenerations];
        try {
            for (int i = 0; i < MAXITER; ++i) {
                System.out.println("Generation=" + i);
                for (p = 0; p < pGenerations; ++p) {
                    int j;
                    bestFitness[p] = this.fitnessCache[p][0];
                    thisIsTheWorstFitness[p] = this.fitnessCache[p][0];
                    for (j = 1; j < pPopSize; ++j) {
                        if (this.fitnessCache[p][j] < bestFitness[p]) {
                            bestFitness[p] = this.fitnessCache[p][j];
                        }
                        if (!(this.fitnessCache[p][j] > thisIsTheWorstFitness[p])) continue;
                        thisIsTheWorstFitness[p] = this.fitnessCache[p][j];
                    }
                    for (j = 0; j < pPopSize; ++j) {
                        this.fitnessMark[p][j] = 1.0 - (this.fitnessCache[p][j] - bestFitness[p]) / (thisIsTheWorstFitness[p] - bestFitness[p]);
                    }
                    for (j = 1; j < pPopSize; ++j) {
                        double[] dArray = this.fitnessMark[p];
                        int n = j;
                        dArray[n] = dArray[n] + this.fitnessMark[p][j - 1];
                    }
                }
                for (p = 0; p < pGenerations; ++p) {
                    int j;
                    for (j = 0; j < pPopSize; ++j) {
                        int origen = p;
                        if (rand.Rand() < this.MIGRATIONPROB) {
                            origen = (int)(rand.Rand() * (double)this.population.length);
                        }
                        double fit = rand.Rand() * this.fitnessMark[origen][pPopSize - 1];
                        int k = 0;
                        while (this.fitnessMark[origen][k] < fit) {
                            ++k;
                        }
                        this.intermediatePopulation[p][j] = this.population[origen][k].clone();
                    }
                    for (j = 0; j < pPopSize; j += 2) {
                        int tc = rand.Rand() < this.GACROSSOVERPROB ? this.GACROSSOVERID : this.GPCROSSOVERID;
                        int tm = rand.Rand() < this.GAMUTATIONPROB ? this.GAMUTATIONID : this.GPMUTATIONID;
                        this.intermediatePopulation[p][j].crossover(this.intermediatePopulation[p][j + 1], this.population[p][j], this.population[p][j + 1], tc);
                        if (rand.Rand() < this.MUTATIONPROB) {
                            this.population[p][j].mutation(this.MUTATIONAMPL, tm);
                        }
                        if (rand.Rand() < this.MUTATIONPROB) {
                            this.population[p][j + 1].mutation(this.MUTATIONAMPL, tm);
                        }
                        if (rand.Rand() < this.LOCALOPTPROB) {
                            this.population[p][j].localOptimization(this.LOCALOPTITER, this.LOID);
                        }
                        if (!(rand.Rand() < this.LOCALOPTPROB)) continue;
                        this.population[p][j + 1].localOptimization(this.LOCALOPTITER, this.LOID);
                    }
                    this.fitnessMean[p] = 0.0;
                    bestFitness[p] = 0.0;
                    thisIsTheBestIndividual[p] = 0;
                    for (j = 0; j < pPopSize; ++j) {
                        this.fitnessCache[p][j] = this.population[p][j].fitness();
                        int n = p;
                        this.fitnessMean[n] = this.fitnessMean[n] + this.fitnessCache[p][j];
                        if (!(this.fitnessCache[p][j] < bestFitness[p]) && j != 0) continue;
                        bestFitness[p] = this.fitnessCache[p][j];
                        thisIsTheBestIndividual[p] = j;
                    }
                    int n = p;
                    this.fitnessMean[n] = this.fitnessMean[n] / (double)pPopSize;
                    if (i == 0 || bestFitness[p] < fitnesselite[p]) {
                        this.elite[p] = this.population[p][thisIsTheBestIndividual[p]].clone();
                        fitnesselite[p] = bestFitness[p];
                    }
                    System.out.print("Elite=" + fitnesselite[p] + " best=" + bestFitness[p] + " media=" + this.fitnessMean[p] + " ");
                    int[] whichIsMyFamily = new int[this.population[p].length];
                    int numfamilias = 0;
                    for (int j2 = 0; j2 < this.population[p].length; ++j2) {
                        if (whichIsMyFamily[j2] > 0) continue;
                        whichIsMyFamily[j2] = ++numfamilias;
                        for (int k = j2; k < this.population[p].length; ++k) {
                            if (!this.population[p][j2].g.isRelated(this.population[p][k].g)) continue;
                            whichIsMyFamily[k] = numfamilias;
                        }
                    }
                    System.out.println("Fams=" + numfamilias);
                }
            }
        }
        catch (invalidFitness f) {
            System.out.println("Unsupported fitness");
        }
        int bestFromElite = 0;
        for (p = 1; p < pGenerations; ++p) {
            if (!(fitnesselite[p] < fitnesselite[bestFromElite])) continue;
            bestFromElite = p;
        }
        return this.elite[bestFromElite].clone();
    }
}

