/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.Evaluation;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.experiment.ClassifierSplitEvaluator;

public class CostSensitiveClassifierSplitEvaluator
extends ClassifierSplitEvaluator {
    static final long serialVersionUID = -8069566663019501276L;
    protected File m_OnDemandDirectory = new File(System.getProperty("user.dir"));
    private static final int RESULT_SIZE = 27;

    public String globalInfo() {
        return " SplitEvaluator that produces results for a classification scheme on a nominal class attribute, including weighted misclassification costs.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector(1);
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tName of a directory to search for cost files when loading\n\tcosts on demand (default current directory).", "D", 1, "-D <directory>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('D', stringArray);
        if (string.length() != 0) {
            this.setOnDemandDirectory(new File(string));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 3];
        int n = 0;
        stringArray2[n++] = "-D";
        stringArray2[n++] = "" + this.getOnDemandDirectory();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String onDemandDirectoryTipText() {
        return "The directory to look in for cost files. This directory will be searched for cost files when loading on demand.";
    }

    public File getOnDemandDirectory() {
        return this.m_OnDemandDirectory;
    }

    public void setOnDemandDirectory(File file) {
        this.m_OnDemandDirectory = file.isDirectory() ? file : new File(file.getParent());
    }

    public Object[] getResultTypes() {
        int n = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        Object[] objectArray = new Object[27 + n];
        Double d = new Double(0.0);
        int n2 = 0;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = "";
        for (int i = 0; i < n; ++i) {
            objectArray[n2++] = d;
        }
        if (n2 != 27 + n) {
            throw new Error("ResultTypes didn't fit RESULT_SIZE");
        }
        return objectArray;
    }

    public String[] getResultNames() {
        int n = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        String[] stringArray = new String[27 + n];
        int n2 = 0;
        stringArray[n2++] = "Number_of_instances";
        stringArray[n2++] = "Number_correct";
        stringArray[n2++] = "Number_incorrect";
        stringArray[n2++] = "Number_unclassified";
        stringArray[n2++] = "Percent_correct";
        stringArray[n2++] = "Percent_incorrect";
        stringArray[n2++] = "Percent_unclassified";
        stringArray[n2++] = "Total_cost";
        stringArray[n2++] = "Average_cost";
        stringArray[n2++] = "Mean_absolute_error";
        stringArray[n2++] = "Root_mean_squared_error";
        stringArray[n2++] = "Relative_absolute_error";
        stringArray[n2++] = "Root_relative_squared_error";
        stringArray[n2++] = "SF_prior_entropy";
        stringArray[n2++] = "SF_scheme_entropy";
        stringArray[n2++] = "SF_entropy_gain";
        stringArray[n2++] = "SF_mean_prior_entropy";
        stringArray[n2++] = "SF_mean_scheme_entropy";
        stringArray[n2++] = "SF_mean_entropy_gain";
        stringArray[n2++] = "KB_information";
        stringArray[n2++] = "KB_mean_information";
        stringArray[n2++] = "KB_relative_information";
        stringArray[n2++] = "Elapsed_Time_training";
        stringArray[n2++] = "Elapsed_Time_testing";
        stringArray[n2++] = "UserCPU_Time_training";
        stringArray[n2++] = "UserCPU_Time_testing";
        stringArray[n2++] = "Summary";
        for (int i = 0; i < n; ++i) {
            stringArray[n2++] = this.m_AdditionalMeasures[i];
        }
        if (n2 != 27 + n) {
            throw new Error("ResultNames didn't fit RESULT_SIZE");
        }
        return stringArray;
    }

    public Object[] getResult(Instances instances, Instances instances2) throws Exception {
        if (instances.classAttribute().type() != 1) {
            throw new Exception("Class attribute is not nominal!");
        }
        if (this.m_Template == null) {
            throw new Exception("No classifier has been specified");
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        boolean bl = threadMXBean.isThreadCpuTimeSupported();
        if (!threadMXBean.isThreadCpuTimeEnabled()) {
            threadMXBean.setThreadCpuTimeEnabled(true);
        }
        int n = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        Object[] objectArray = new Object[27 + n];
        long l = Thread.currentThread().getId();
        long l2 = -1L;
        long l3 = -1L;
        long l4 = -1L;
        String string = instances.relationName() + CostMatrix.FILE_EXTENSION;
        File file = new File(this.getOnDemandDirectory(), string);
        if (!file.exists()) {
            throw new Exception("On-demand cost file doesn't exist: " + file);
        }
        CostMatrix costMatrix = new CostMatrix(new BufferedReader(new FileReader(file)));
        Evaluation evaluation = new Evaluation(instances, costMatrix);
        this.m_Classifier = Classifier.makeCopy(this.m_Template);
        long l5 = System.currentTimeMillis();
        if (bl) {
            l2 = threadMXBean.getThreadUserTime(l);
        }
        this.m_Classifier.buildClassifier(instances);
        if (bl) {
            l3 = threadMXBean.getThreadUserTime(l) - l2;
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis();
        if (bl) {
            l2 = threadMXBean.getThreadUserTime(l);
        }
        evaluation.evaluateModel(this.m_Classifier, instances2);
        if (bl) {
            l4 = threadMXBean.getThreadUserTime(l) - l2;
        }
        long l8 = System.currentTimeMillis() - l7;
        threadMXBean = null;
        this.m_result = evaluation.toSummaryString();
        int n2 = 0;
        objectArray[n2++] = new Double(evaluation.numInstances());
        objectArray[n2++] = new Double(evaluation.correct());
        objectArray[n2++] = new Double(evaluation.incorrect());
        objectArray[n2++] = new Double(evaluation.unclassified());
        objectArray[n2++] = new Double(evaluation.pctCorrect());
        objectArray[n2++] = new Double(evaluation.pctIncorrect());
        objectArray[n2++] = new Double(evaluation.pctUnclassified());
        objectArray[n2++] = new Double(evaluation.totalCost());
        objectArray[n2++] = new Double(evaluation.avgCost());
        objectArray[n2++] = new Double(evaluation.meanAbsoluteError());
        objectArray[n2++] = new Double(evaluation.rootMeanSquaredError());
        objectArray[n2++] = new Double(evaluation.relativeAbsoluteError());
        objectArray[n2++] = new Double(evaluation.rootRelativeSquaredError());
        objectArray[n2++] = new Double(evaluation.SFPriorEntropy());
        objectArray[n2++] = new Double(evaluation.SFSchemeEntropy());
        objectArray[n2++] = new Double(evaluation.SFEntropyGain());
        objectArray[n2++] = new Double(evaluation.SFMeanPriorEntropy());
        objectArray[n2++] = new Double(evaluation.SFMeanSchemeEntropy());
        objectArray[n2++] = new Double(evaluation.SFMeanEntropyGain());
        objectArray[n2++] = new Double(evaluation.KBInformation());
        objectArray[n2++] = new Double(evaluation.KBMeanInformation());
        objectArray[n2++] = new Double(evaluation.KBRelativeInformation());
        objectArray[n2++] = new Double((double)l6 / 1000.0);
        objectArray[n2++] = new Double((double)l8 / 1000.0);
        if (bl) {
            objectArray[n2++] = new Double((double)l3 / 1000000.0 / 1000.0);
            objectArray[n2++] = new Double((double)l4 / 1000000.0 / 1000.0);
        } else {
            objectArray[n2++] = new Double(Instance.missingValue());
            objectArray[n2++] = new Double(Instance.missingValue());
        }
        objectArray[n2++] = this.m_Classifier instanceof Summarizable ? ((Summarizable)((Object)this.m_Classifier)).toSummaryString() : null;
        for (int i = 0; i < n; ++i) {
            if (this.m_doesProduce[i]) {
                try {
                    double d = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                    if (!Instance.isMissingValue(d)) {
                        Double d2 = new Double(d);
                        objectArray[n2++] = d2;
                        continue;
                    }
                    objectArray[n2++] = null;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
                continue;
            }
            objectArray[n2++] = null;
        }
        if (n2 != 27 + n) {
            throw new Error("Results didn't fit RESULT_SIZE");
        }
        return objectArray;
    }

    public String toString() {
        String string = "CostSensitiveClassifierSplitEvaluator: ";
        if (this.m_Template == null) {
            return string + "<null> classifier";
        }
        return string + this.m_Template.getClass().getName() + " " + this.m_ClassifierOptions + "(version " + this.m_ClassifierVersion + ")";
    }
}

