/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.event.ActionEvent;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualMappingManager;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.AbstractClusterONEAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeTask;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CytoscapeResultViewerPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.VisualStyleManager;

public class StartAction
extends AbstractClusterONEAction
implements ClusterONECytoscapeTask.ResultListener {
    public StartAction(ClusterONECytoscapeApp app) {
        super(app, "Start", "network");
        this.installInMenu();
        this.putValue("MnemonicKey", 83);
    }

    public void actionPerformed(ActionEvent event) {
        CyNetwork network = this.app.getCurrentNetwork();
        CyNetworkView networkView = this.app.getCurrentNetworkView();
        if (network == null || network.getNodeCount() == 0) {
            this.app.showErrorMessage("You must select a non-empty network before starting ClusterONE");
            return;
        }
        ControlPanel panel = this.app.getControlPanel();
        if (panel == null) {
            this.app.showErrorMessage("You must open the Control Panel before starting ClusterONE");
            return;
        }
        if (networkView != null) {
            this.app.runAlgorithm(networkView, panel.getParameters(), panel.getWeightAttributeName(), (ClusterONECytoscapeTask.ResultListener)this);
        } else {
            this.app.runAlgorithm(network, panel.getParameters(), panel.getWeightAttributeName(), (ClusterONECytoscapeTask.ResultListener)this);
        }
    }

    public void resultsCalculated(ClusterONECytoscapeTask task, ClusterONECytoscapeTask.Result result) {
        CytoscapeResultViewerPanel resultsPanel;
        if (result == null || result.clusters == null) {
            return;
        }
        result.setStatusAttributes();
        VisualStyleManager vsm = this.app.getVisualStyleManager();
        vsm.ensureVizMapperStylesRegistered();
        this.app.getService(VisualMappingManager.class).setCurrentVisualStyle(vsm.getColorNodesByStatusVisualStyle());
        if (task.getNetworkView() != null) {
            task.getNetworkView().updateView();
            resultsPanel = new CytoscapeResultViewerPanel(this.app, task.getNetworkView());
        } else {
            resultsPanel = new CytoscapeResultViewerPanel(this.app, task.getNetwork());
        }
        resultsPanel.setResult(result);
        resultsPanel.addToCytoscapeResultPanel();
    }

    protected void updateEnabledState() {
        this.setEnabled(this.app.getCurrentNetwork() != null && this.app.getControlPanel() != null);
    }
}

