/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.io.PrintWriter;
import java.util.Arrays;
import uk.ac.rhul.cs.cl1.TaskMonitor;
import uk.ac.rhul.cs.utils.StringUtils;

public class ConsoleTaskMonitor
implements TaskMonitor {
    protected int percent = 0;
    protected int spinnerState = 0;
    protected long lastUpdatedAt = -1L;
    protected int progressBarWidth = 20;
    protected String message = "";
    protected boolean dirty = false;
    private Integer consoleWidth = null;
    protected PrintWriter writer = new PrintWriter(System.err);

    public int getProgressBarWidth() {
        return this.progressBarWidth;
    }

    public void setEstimatedTimeRemaining(long time) {
        this.dirty = true;
    }

    public void setException(Throwable t, String userErrorMessage) {
        this.setException(t, userErrorMessage, null);
    }

    public void setException(Throwable t, String userErrorMessage, String recoveryTip) {
        if (userErrorMessage != null && !userErrorMessage.isEmpty()) {
            System.err.println("An unexpected error happened:");
            System.err.println(userErrorMessage);
            System.err.println();
            System.err.println("The corresponding stack trace is:");
        } else {
            System.err.println("An unexpected exception happened:");
        }
        t.printStackTrace();
        if (recoveryTip != null && !recoveryTip.isEmpty()) {
            System.err.println();
            System.err.println(recoveryTip);
        }
    }

    public void setPercentCompleted(int percent) throws IllegalArgumentException {
        if (percent < -1 || percent > 100) {
            throw new IllegalArgumentException("percentage must be between -1 and 100");
        }
        if (percent == -1) {
            this.percent = -1;
            if (System.currentTimeMillis() - this.lastUpdatedAt > 100L) {
                ++this.spinnerState;
                this.dirty = true;
                this.updateDisplay();
            }
        } else if (this.percent != percent) {
            this.percent = percent;
            this.dirty = true;
            this.updateDisplay();
        }
    }

    public void setProgressBarWidth(int width) {
        this.progressBarWidth = Math.max(1, this.progressBarWidth);
        this.dirty = true;
    }

    public void setStatus(String message) {
        if (!message.isEmpty() && !message.equals(this.message)) {
            this.message = message;
            this.dirty = true;
            this.updateDisplay();
        }
    }

    protected void updateDisplay() {
        if (!this.dirty) {
            return;
        }
        char[] progress = new char[this.progressBarWidth];
        Arrays.fill(progress, ' ');
        this.writer.append('[');
        if (this.percent >= 0) {
            int numChars = (int)Math.round((double)(this.progressBarWidth * this.percent) / 100.0);
            for (int i = 0; i < numChars; ++i) {
                progress[i] = 61;
            }
            if (numChars > 0 && this.percent < 100) {
                progress[numChars - 1] = 62;
            }
        } else {
            this.spinnerState %= this.progressBarWidth;
            progress[this.spinnerState] = 124;
        }
        this.writer.write(progress);
        this.writer.append(']');
        if (this.percent >= 0) {
            this.writer.format("%4d%% ", this.percent);
        } else {
            this.writer.write("      ");
        }
        this.writer.append(StringUtils.substring(this.message, 0, this.getConsoleWidth() - this.progressBarWidth - 8));
        if (this.percent == 100) {
            this.writer.write("\r\n");
        } else {
            this.writer.append('\r');
        }
        this.writer.flush();
        this.lastUpdatedAt = System.currentTimeMillis();
    }

    private int getConsoleWidth() {
        if (this.consoleWidth != null) {
            return this.consoleWidth;
        }
        this.consoleWidth = 80;
        try {
            if (System.getenv("COLUMNS") != null) {
                this.consoleWidth = Integer.parseInt(System.getenv("COLUMNS"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.consoleWidth;
    }
}

