/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.plots.DefaultElementView;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamCharacter;
import org.rosuda.deducer.widgets.param.ParamLogical;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.ParamVector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Coord
implements ElementModel {
    private String name;
    public Vector params = new Vector();

    public static Coord makeCartesian() {
        Coord coord = new Coord();
        coord.setName("coord_cartesian");
        ParamVector paramVector = new ParamVector();
        paramVector.setName("xlim");
        paramVector.setTitle("x axis range");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        coord.params.add(paramVector);
        paramVector = new ParamVector();
        paramVector.setName("ylim");
        paramVector.setTitle("y axis range");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        coord.params.add(paramVector);
        return coord;
    }

    public static Coord makeEqual() {
        Coord coord = new Coord();
        coord.setName("coord_equal");
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("ratio");
        paramNumeric.setTitle("x to y ratio");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(1.0));
        paramNumeric.setDefaultValue(new Double(1.0));
        coord.params.add(paramNumeric);
        return coord;
    }

    public static Coord makeFlip() {
        Coord coord = new Coord();
        coord.setName("coord_flip");
        ParamVector paramVector = new ParamVector();
        paramVector.setName("xlim");
        paramVector.setTitle("x axis range");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        coord.params.add(paramVector);
        paramVector = new ParamVector();
        paramVector.setName("ylim");
        paramVector.setTitle("y axis range");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        coord.params.add(paramVector);
        return coord;
    }

    public static Coord makeMap() {
        Coord coord = new Coord();
        coord.setName("coord_map");
        ParamCharacter paramCharacter = new ParamCharacter();
        paramCharacter.setName("projection");
        paramCharacter.setTitle("Projection");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setValue(null);
        paramCharacter.setDefaultValue(null);
        paramCharacter.setOptions(new String[]{"mercator", "sinusoidal", "cylequalarea", "cylindrical", "rectangular", "gall", "mollweide", "gilbert", "", "azequidistant", "azequalarea", "gnomonic", "perspective", "orthographic", "stereographic", "laue", "fisheye", "newyorker", "", "conic", "simpleconic", "lambert", "albers", "bonne", "", "polyconic", "aitoff", "lagrange", "bicentric", "elliptic", "globular", "vandergrinten", "eisenlohr", "", "guyou", "square", "tetra", "hex", "", "harrison", "trapezoidal", "lune", "", "mecca", "homing"});
        paramCharacter.setLabels(new String[]{"equally spaced straight meridians, conformal, straight compass courses", "equally spaced parallels, equal-area", "equally spaced straight meridians, equal-area, true scale on lat0", "central projection on tangent cylinder", "equally spaced parallels, equally spaced straight meridians, true scale on lat0", "parallels spaced stereographically on prime meridian, equally spaced straight meridians, true scale on lat0", "(homalographic) equal-area, hemisphere is a circle", "sphere conformally mapped on hemisphere and viewed orthographically", "", "equally spaced parallels, true distances from pole", "equal-area", "central projection on tangent plane, straight great circles", "viewed along earth's axis dist earth radii from center of earth", "viewed from infinity", "conformal, projected from opposite pole", "radius = tan(2 * colatitude) used in xray crystallography", "", "stereographic seen through medium with refractive index n", "radius = log(colatitude/r) map from viewing pedestal of radius r degrees", "central projection on cone tangent at lat0", "equally spaced parallels, true scale on lat0 and lat1", "conformal, true scale on lat0 and lat", "equal-area, true scale on lat0 and lat1", "equally spaced parallels, equal-area, parallel lat0 developed from tangent cone", "", "parallels developed from tangent cones, equally spaced along Prime Meridian", "equal-area projection of globe onto 2-to-1 ellipse, based on azequalarea", "conformal, maps whole sphere into a circle", "points plotted at true azimuth from two centers on the equator at longitudes +lon0 and -lon0", "points are plotted at true distance from two centers on the equator at longitudes +lon0 and -lon0", "hemisphere is circle, circular arc meridians equally spaced on equator, circular arc parallels equally spaced on 0- and 90-degree meridians", "sphere is circle, meridians as in globular, circular arc parallels resemble mercator", "conformal with no singularities, shaped like polyconic", "", "W and E hemispheres are square", "world is square with Poles at diagonally opposite corners", "map on tetrahedron with edge tangent to Prime Meridian at S Pole, unfolded into equilateral triangle", "world is hexagon centered on N Pole, N and S hemispheres are equilateral triangles", "", "oblique perspective from above the North Pole, dist earth radii from center of earth, looking along the Date Line angle degrees off vertical", "equally spaced parallels, straight meridians equally spaced along parallels, true scale at lat0 and lat1 on Prime Meridian", "conformal, polar cap above latitude lat maps to convex lune with given angle at 90E and 90W", "", "equally spaced vertical meridians", "distances to Mecca are true"});
        coord.params.add(paramCharacter);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("lat0");
        paramNumeric.setTitle("lat0");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        coord.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("lat1");
        paramNumeric.setTitle("lat2");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        coord.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("dist");
        paramNumeric.setTitle("dist");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        coord.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("n");
        paramNumeric.setTitle("n");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        coord.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("r");
        paramNumeric.setTitle("r");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        coord.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("angle");
        paramNumeric.setTitle("angle");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        coord.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("lat");
        paramNumeric.setTitle("lat");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        coord.params.add(paramNumeric);
        return coord;
    }

    public static Coord makePolar() {
        Coord coord = new Coord();
        coord.setName("coord_polar");
        ParamCharacter paramCharacter = new ParamCharacter();
        paramCharacter.setName("theta");
        paramCharacter.setTitle("Angle is");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setValue("x");
        paramCharacter.setDefaultValue("x");
        paramCharacter.setOptions(new String[]{"x", "y"});
        coord.params.add(paramCharacter);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("start");
        paramNumeric.setTitle("Offset from 12 o'clock in radians");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(0.0));
        paramNumeric.setDefaultValue(new Double(0.0));
        coord.params.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("direction");
        paramNumeric.setTitle("Direction");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramNumeric.setValue(new Double(1.0));
        paramNumeric.setDefaultValue(new Double(1.0));
        paramNumeric.setOptions(new String[]{"1", "-1"});
        paramNumeric.setLabels(new String[]{"clockwise", "counter clockwise"});
        coord.params.add(paramNumeric);
        ParamLogical paramLogical = new ParamLogical();
        paramLogical.setName("expand");
        paramLogical.setTitle("Expand axis");
        ((Param)paramLogical).setValue(new Boolean(false));
        ((Param)paramLogical).setDefaultValue(new Boolean(false));
        coord.params.add(paramLogical);
        return coord;
    }

    public static Coord makeTrans() {
        Coord coord = new Coord();
        coord.setName("coord_trans");
        ParamCharacter paramCharacter = new ParamCharacter();
        paramCharacter.setName("xtrans");
        paramCharacter.setTitle("x-axis transformation");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setValue("identity");
        paramCharacter.setDefaultValue("identity");
        paramCharacter.setOptions(new String[]{"asn", "exp", "identity", "log", "log10", "probit", "recip", "reverse", "sqrt"});
        coord.params.add(paramCharacter);
        paramCharacter = new ParamCharacter();
        paramCharacter.setName("ytrans");
        paramCharacter.setTitle("y-axis transformation");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setValue("identity");
        paramCharacter.setDefaultValue("identity");
        paramCharacter.setOptions(new String[]{"asn", "exp", "identity", "log", "log10", "probit", "recip", "reverse", "sqrt"});
        coord.params.add(paramCharacter);
        return coord;
    }

    public static Coord makeCoord(String string) {
        if (string.equals("cartesian")) {
            return Coord.makeCartesian();
        }
        if (string.equals("equal")) {
            return Coord.makeEqual();
        }
        if (string.equals("flip")) {
            return Coord.makeFlip();
        }
        if (string.equals("map")) {
            return Coord.makeMap();
        }
        if (string.equals("polar")) {
            return Coord.makePolar();
        }
        if (string.equals("trans")) {
            return Coord.makeTrans();
        }
        return null;
    }

    public Object clone() {
        Coord coord = new Coord();
        for (int i = 0; i < this.params.size(); ++i) {
            coord.params.add(((Param)this.params.get(i)).clone());
        }
        coord.setName(this.name);
        return coord;
    }

    public String checkValid() {
        return null;
    }

    public String getCall() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.params.size(); ++i) {
            Param param = (Param)this.params.get(i);
            String[] stringArray = param.getParamCalls();
            for (int j = 0; j < stringArray.length; ++j) {
                vector.add(stringArray[j]);
            }
        }
        String string = Deducer.makeRCollection(vector, this.getName(), false);
        return string;
    }

    public String getType() {
        return "scale";
    }

    public ElementView getView() {
        return new DefaultElementView(this);
    }

    public Vector getParams() {
        return this.params;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("ElementModel");
            element.setAttribute("className", "org.rosuda.deducer.plots.Coord");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            for (int i = 0; i < this.params.size(); ++i) {
                Element element2 = ((Param)this.params.get(i)).toXML();
                element2 = (Element)document.importNode(element2, true);
                element.appendChild(element2);
            }
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.Coord")) {
            System.out.println("Error Coord: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.params = new Vector();
        NodeList nodeList = element.getElementsByTagName("Param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            string = element2.getAttribute("className");
            Param param = Param.makeParam(string);
            param.setFromXML(element2);
            this.params.add(param);
        }
    }

    public String getData() {
        return null;
    }
}

