/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SwapOperator
extends SimpleMCMCOperator {
    private int size = 1;
    private Parameter parameter = null;
    private List<Integer> masterList = null;

    public SwapOperator(Parameter parameter, int n) {
        this.parameter = parameter;
        this.size = n;
        if (parameter.getDimension() < 2 * n) {
            throw new IllegalArgumentException();
        }
        int n2 = parameter.getDimension();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(i);
        }
        this.masterList = Collections.unmodifiableList(arrayList);
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public final double doOperation() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.masterList);
        for (int i = 0; i < this.size; ++i) {
            int n = (Integer)arrayList.remove(MathUtils.nextInt(arrayList.size()));
            int n2 = (Integer)arrayList.remove(MathUtils.nextInt(arrayList.size()));
            double d = this.parameter.getParameterValue(n);
            double d2 = this.parameter.getParameterValue(n2);
            this.parameter.setParameterValue(n, d2);
            this.parameter.setParameterValue(n2, d);
        }
        return 0.0;
    }

    @Override
    public String getOperatorName() {
        return "swapOperator(" + this.parameter.getParameterName() + ")";
    }

    public String getPerformanceSuggestion() {
        return "No suggestions";
    }
}

