/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetOperator
extends SimpleMCMCOperator {
    private Parameter parameter = null;
    private double[] values;

    public SetOperator(Parameter parameter, double[] dArray) {
        this.parameter = parameter;
        this.values = dArray;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public final double doOperation() {
        int n = MathUtils.nextInt(this.values.length);
        double d = this.values[n];
        if (d < this.parameter.getBounds().getLowerLimit(n) || d > this.parameter.getBounds().getUpperLimit(n)) {
            return Double.NEGATIVE_INFINITY;
        }
        this.parameter.setParameterValue(n, d);
        return 0.0;
    }

    public Element createOperatorElement(Document document) {
        throw new RuntimeException("Not implememented!");
    }

    @Override
    public String getOperatorName() {
        return "setOperator(" + this.parameter.getParameterName() + ")";
    }

    public String getPerformanceSuggestion() {
        return "No suggestions";
    }
}

