/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.util.Attributable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleTree
implements MutableTree {
    protected String id = null;
    private Attributable.AttributeHelper attributes = null;
    private final ArrayList<MutableTreeListener> mutableTreeListeners = new ArrayList();
    private final ArrayList<MutableTaxonListListener> mutableTaxonListListeners = new ArrayList();
    SimpleNode root;
    SimpleNode[] nodes = null;
    int nodeCount;
    int externalNodeCount;
    int internalNodeCount;
    private Units.Type units = Units.Type.SUBSTITUTIONS;
    boolean inEdit = false;

    public SimpleTree() {
        this.root = null;
    }

    public SimpleTree(Tree tree) {
        this.setUnits(tree.getUnits());
        this.root = new SimpleNode(tree, tree.getRoot());
        this.nodeCount = tree.getNodeCount();
        this.internalNodeCount = tree.getInternalNodeCount();
        this.externalNodeCount = tree.getExternalNodeCount();
        this.nodes = new SimpleNode[this.nodeCount];
        SimpleNode simpleNode = this.root;
        do {
            if ((simpleNode = (SimpleNode)TreeUtils.postorderSuccessor(this, simpleNode)).getNumber() >= this.externalNodeCount && simpleNode.isExternal() || simpleNode.getNumber() < this.externalNodeCount && !simpleNode.isExternal()) {
                throw new RuntimeException("Error cloning tree: node numbers are incompatible");
            }
            this.nodes[simpleNode.getNumber()] = simpleNode;
        } while (simpleNode != this.root);
    }

    public SimpleTree(SimpleNode simpleNode) {
        this.adoptNodes(simpleNode);
    }

    @Override
    public Tree getCopy() {
        return new SimpleTree(this);
    }

    protected void adoptNodes(SimpleNode simpleNode) {
        if (this.inEdit) {
            throw new RuntimeException("Mustn't be in an edit transaction to call this method!");
        }
        this.internalNodeCount = 0;
        this.externalNodeCount = 0;
        this.root = simpleNode;
        do {
            if ((simpleNode = (SimpleNode)TreeUtils.postorderSuccessor(this, simpleNode)).isExternal()) {
                ++this.externalNodeCount;
                continue;
            }
            ++this.internalNodeCount;
        } while (simpleNode != this.root);
        this.nodeCount = this.internalNodeCount + this.externalNodeCount;
        this.nodes = new SimpleNode[this.nodeCount];
        simpleNode = this.root;
        int n = 0;
        int n2 = this.externalNodeCount;
        do {
            if ((simpleNode = (SimpleNode)TreeUtils.postorderSuccessor(this, simpleNode)).isExternal()) {
                simpleNode.setNumber(n);
                this.nodes[n] = simpleNode;
                ++n;
                continue;
            }
            simpleNode.setNumber(n2);
            this.nodes[n2] = simpleNode;
            ++n2;
        } while (simpleNode != this.root);
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public boolean hasNodeHeights() {
        return true;
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return ((SimpleNode)nodeRef).getHeight();
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        return ((SimpleNode)nodeRef).getRate();
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return ((SimpleNode)nodeRef).getTaxon();
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        return ((SimpleNode)nodeRef).getChildCount();
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return ((SimpleNode)nodeRef).getChildCount() == 0;
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return nodeRef == this.root;
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return ((SimpleNode)nodeRef).getChild(n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        return ((SimpleNode)nodeRef).getParent();
    }

    @Override
    public boolean hasBranchLengths() {
        return true;
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.getParent(nodeRef);
        if (nodeRef2 == null) {
            return 0.0;
        }
        return this.getNodeHeight(nodeRef2) - this.getNodeHeight(nodeRef);
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("SimpleTree cannot have branch lengths set... use FlexibleTree");
    }

    @Override
    public final SimpleNode getExternalNode(int n) {
        return this.nodes[n];
    }

    @Override
    public final SimpleNode getInternalNode(int n) {
        return this.nodes[n + this.externalNodeCount];
    }

    @Override
    public final NodeRef getNode(int n) {
        return this.nodes[n];
    }

    @Override
    public final int getExternalNodeCount() {
        return this.externalNodeCount;
    }

    @Override
    public final int getInternalNodeCount() {
        return this.internalNodeCount;
    }

    @Override
    public final NodeRef getRoot() {
        return this.root;
    }

    @Override
    public final void setRoot(NodeRef nodeRef) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        if (!(nodeRef instanceof SimpleNode)) {
            throw new IllegalArgumentException();
        }
        this.root = (SimpleNode)nodeRef;
        this.root.setParent(null);
    }

    public final double getRootHeight() {
        return this.root.getHeight();
    }

    public final void setRootHeight(double d) {
        this.root.setHeight(d);
        this.fireTreeChanged();
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        SimpleNode simpleNode = (SimpleNode)nodeRef;
        SimpleNode simpleNode2 = (SimpleNode)nodeRef2;
        if (simpleNode.hasChild(simpleNode2)) {
            throw new IllegalArgumentException("Child already existists in parent");
        }
        simpleNode.addChild(simpleNode2);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        SimpleNode simpleNode = (SimpleNode)nodeRef;
        SimpleNode simpleNode2 = (SimpleNode)nodeRef2;
        simpleNode.removeChild(simpleNode2);
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        SimpleNode simpleNode = (SimpleNode)nodeRef;
        simpleNode.replaceChild((SimpleNode)nodeRef2, (SimpleNode)nodeRef3);
    }

    @Override
    public boolean beginTreeEdit() {
        boolean bl = this.inEdit;
        this.inEdit = true;
        return bl;
    }

    @Override
    public void endTreeEdit() {
        this.inEdit = false;
        this.fireTreeChanged();
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        SimpleNode simpleNode = (SimpleNode)nodeRef;
        simpleNode.setHeight(d);
        this.fireTreeChanged();
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        SimpleNode simpleNode = (SimpleNode)nodeRef;
        simpleNode.setRate(d);
        this.fireTreeChanged();
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        ((SimpleNode)nodeRef).setAttribute(string, object);
        this.fireTreeChanged();
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        return ((SimpleNode)nodeRef).getAttribute(string);
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        return ((SimpleNode)nodeRef).getAttributeNames();
    }

    @Override
    public int getTaxonCount() {
        return this.getExternalNodeCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.getExternalNode(n).getTaxon();
    }

    @Override
    public String getTaxonId(int n) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getId();
        }
        return this.getExternalNode(n).getId();
    }

    @Override
    public int getTaxonIndex(String string) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (this.getTaxon(i) != taxon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < SimpleTree.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return SimpleTree.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return this.getExternalNode(n).getAttribute(string);
    }

    @Override
    public int addTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a MutableTree");
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a MutableTree");
    }

    @Override
    public void setTaxonId(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            taxon.setId(string);
        } else {
            this.getExternalNode(n).setId(string);
        }
        this.fireTreeChanged();
        this.fireTaxaChanged();
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            taxon.setAttribute(string, object);
        } else {
            this.getExternalNode(n).setAttribute(string, object);
        }
        this.fireTreeChanged();
        this.fireTaxaChanged();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Attributable.AttributeHelper();
        }
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttributeNames();
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
        this.mutableTreeListeners.add(mutableTreeListener);
    }

    private void fireTreeChanged() {
        for (MutableTreeListener mutableTreeListener : this.mutableTreeListeners) {
            mutableTreeListener.treeChanged(this);
        }
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
        this.mutableTaxonListListeners.add(mutableTaxonListListener);
    }

    private void fireTaxaChanged() {
        for (MutableTaxonListListener mutableTaxonListListener : this.mutableTaxonListListeners) {
            mutableTaxonListListener.taxaChanged(this);
        }
    }

    public String toString() {
        return TreeUtils.newick(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tree)) {
            throw new IllegalArgumentException("SimpleTree.equals can only compare instances of Tree");
        }
        return TreeUtils.equal(this, (Tree)object);
    }
}

