/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.splitcriteria;

import moa.classifiers.core.splitcriteria.SDRSplitCriterion;
import moa.classifiers.rules.core.splitcriteria.AMRulesSplitCriterion;

public class SDRSplitCriterionAMRules
extends SDRSplitCriterion
implements AMRulesSplitCriterion {
    private static final long serialVersionUID = 1L;

    @Override
    public double getMeritOfSplit(double[] preSplitDist, double[][] postSplitDists) {
        double Ni;
        int i;
        double SDR = 0.0;
        double N = preSplitDist[0];
        int count = 0;
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            if (!(Ni >= 0.05 * preSplitDist[0])) continue;
            ++count;
        }
        if (count == postSplitDists.length) {
            SDR = SDRSplitCriterionAMRules.computeSD(preSplitDist);
            for (i = 0; i < postSplitDists.length; ++i) {
                Ni = postSplitDists[i][0];
                SDR -= Ni / N * SDRSplitCriterionAMRules.computeSD(postSplitDists[i]);
            }
        }
        return SDR;
    }

    @Override
    public double getRangeOfMerit(double[] preSplitDist) {
        return 1.0;
    }

    @Override
    public double[] computeBranchSplitMerits(double[][] postSplitDists) {
        double Ni;
        int i;
        double[] SDR = new double[postSplitDists.length];
        double N = 0.0;
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            N += Ni;
        }
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            SDR[i] = Ni / N * SDRSplitCriterionAMRules.computeSD(postSplitDists[i]);
        }
        return SDR;
    }
}

