/*
 * Decompiled with CFR 0.152.
 */
package main;

import vcf.Marker;
import vcf.Markers;

public interface GeneticMap {
    public int basePos(int var1, double var2);

    public double genPos(Marker var1);

    public double genPos(int var1, int var2);

    public String toString();

    default public double[] genPos(Markers markers) {
        double[] dArray = new double[markers.nMarkers()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.genPos(markers.marker(i));
        }
        return dArray;
    }

    default public float[] pRecomb(Markers markers, int n, float f) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (f < 1.0f) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        double d = 1.0E-7;
        int n2 = markers.marker(0).chromIndex();
        float[] fArray = new float[markers.nMarkers()];
        double d2 = -(0.04 * (double)f / (double)n);
        double d3 = this.genPos(n2, markers.marker(0).pos());
        fArray[0] = 0.0f;
        for (int i = 1; i < fArray.length; ++i) {
            double d4 = this.genPos(markers.marker(i));
            double d5 = Math.max(Math.abs(d4 - d3), d);
            fArray[i] = (float)(-Math.expm1(d2 * d5));
            d3 = d4;
        }
        return fArray;
    }
}

