/*
 * Decompiled with CFR 0.152.
 */
package partition;

import partition.Angle;
import partition.Distance;
import partition.Location;

public class LatLong
extends Location {
    private Angle _delta;
    private Angle _lambda;

    public LatLong(double longitude, double latitude) {
        this.setCoordinates(longitude, latitude);
    }

    @Override
    public final void setCoordinates(double longitude, double latitude) {
        Angle delta = new Angle(Math.toRadians(latitude));
        Angle lambda = new Angle(Math.toRadians(longitude));
        double sinDelta = delta.getSin();
        double cosDelta = delta.getCos();
        double sinLambda = lambda.getSin();
        double cosLambda = lambda.getCos();
        this._s1 = cosLambda * cosDelta;
        this._s2 = sinLambda * cosDelta;
        this._s3 = sinDelta;
        this._lambda = lambda;
        this._delta = delta;
    }

    public final Angle getLambda() {
        return this._lambda;
    }

    public final Angle getDelta() {
        return this._delta;
    }

    public final double getLatitude() {
        return Math.toDegrees(this.getDelta().getValue());
    }

    public final double getLongitude() {
        return Math.toDegrees(this.getLambda().getValue());
    }

    @Override
    public double getDistanceTo(Location location) {
        return Distance.greatCircle(this, (LatLong)location);
    }

    @Override
    public double getSquaredDistanceTo(Location location) {
        return Distance.squaredGreatCircle(this, (LatLong)location);
    }

    public String toString() {
        return this.getClass().getName() + "[latitude=" + this.getLatitude() + " degrees," + " longitude=" + this.getLongitude() + " degrees]";
    }
}

