/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.CompressedSerializedObject;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DefaultAttribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.util.VKMUtil;

public class NominalAttribute
extends DefaultAttribute
implements Iterable<Value> {
    protected List<Object> rawValues;
    protected Hashtable<Object, Integer> valueIndicesHash;
    public static final int STRING_COMPRESS_THRESHOLD = 128;
    protected List<Value> allValues;

    protected NominalAttribute(String id) {
        super(id);
    }

    public NominalAttribute(String id, List<String> attributeValues) {
        super(id);
        this.rawValues = new ArrayList<Object>(attributeValues.size());
        this.valueIndicesHash = new Hashtable(attributeValues.size());
        int i = 0;
        while (i < attributeValues.size()) {
            Object store = this.toStoredValue(attributeValues.get(i));
            if (this.valueIndicesHash.containsKey(store)) {
                throw new IllegalArgumentException("A nominal attribute (" + id + ") cannot" + " have duplicate labels (" + store + ").");
            }
            this.rawValues.add(store);
            this.valueIndicesHash.put(store, i);
            ++i;
        }
    }

    public final void addValue(String value) {
        Object store = this.toStoredValue(value);
        this.rawValues.add(store);
        this.valueIndicesHash.put(store, this.rawValues.size() - 1);
    }

    @Override
    public NominalAttribute copy() {
        ArrayList<String> values = new ArrayList<String>(this.getValuesCount());
        int i = 0;
        while (i < this.getRawValuesCount()) {
            values.add(this.getRawValue(i));
            ++i;
        }
        NominalAttribute copiedNominalAttribute = new NominalAttribute(this.getId(), values);
        return copiedNominalAttribute;
    }

    public int getIndexOfValue(String value) {
        Object store = this.toStoredValue(value);
        Integer val = this.valueIndicesHash.get(store);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public String getRawValue(int valIndex) {
        Object val = this.rawValues.get(valIndex);
        if (val instanceof CompressedSerializedObject) {
            val = ((CompressedSerializedObject)val).getObject();
        }
        return (String)val;
    }

    protected int getRawValuesCount() {
        return this.rawValues.size();
    }

    @Override
    public double getValue(DataRecord instance) {
        return instance.getValue(instance.getDataset().getIndex(this));
    }

    @Override
    public boolean isMissingValue(DataRecord record) {
        return Value.isMissingValue(record.getValue(this));
    }

    protected Object toStoredValue(String value) {
        Object store = value;
        if (value.length() > 128) {
            try {
                store = new CompressedSerializedObject(value);
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).warning("Couldn't compress attribute value - \n" + value + "\n" + " storing uncompressed.");
            }
        }
        return store;
    }

    @Override
    public Iterator<Value> usedValuesIterator(IDataRecordSet dataset) {
        boolean[] indices = new boolean[this.rawValues.size()];
        Arrays.fill(indices, false);
        for (DataRecord record : dataset) {
            indices[(int)record.getValue((Attribute)this)] = true;
        }
        LinkedList<Value> usedValues = new LinkedList<Value>();
        int i = 0;
        while (i < indices.length) {
            if (indices[i]) {
                usedValues.add(this.getNominalValue(i));
            }
            ++i;
        }
        return usedValues.iterator();
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("@attribute").append(" ").append(VKMUtil.quote(this.getId())).append(" ");
        text.append('{');
        Iterator<Value> iter = this.allValuesIterator();
        while (iter.hasNext()) {
            text.append(VKMUtil.quote(iter.next().toString()));
            if (!iter.hasNext()) continue;
            text.append(',');
        }
        text.append('}');
        return text.toString();
    }

    private void checkValuesInitialization() {
        if (this.allValues == null || this.allValues.isEmpty()) {
            throw new IllegalStateException("Nominal attribute " + this.getId() + " was not initialized correctly - no values set.");
        }
    }

    public Value getNominalValue(int value) {
        this.checkValuesInitialization();
        return this.allValues.get(value);
    }

    public Value getNominalValue(DataRecord instance) {
        this.checkValuesInitialization();
        double value = this.getValue(instance);
        if (Double.isNaN(value)) {
            return Value.missingValue(this);
        }
        return this.allValues.get((int)value);
    }

    public Value getNominalValueFromID(String valueID) {
        Iterator<Value> iter = this.allValuesIterator();
        while (iter.hasNext()) {
            Value val = iter.next();
            if (!val.getId().equals(valueID)) continue;
            return val;
        }
        NoSuchElementException ex = new NoSuchElementException("Value for " + valueID + " not found in Attribute'" + this.getDescription() + "'!");
        Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getNominalValue", ex);
        throw ex;
    }

    protected List<Value> getNominalValues() {
        this.checkValuesInitialization();
        return this.allValues;
    }

    public int getValuesCount() {
        this.checkValuesInitialization();
        return this.allValues.size();
    }

    @Override
    public boolean isNominal() {
        return true;
    }

    protected void setNominalValues(List<Value> nominalValues) {
        if (nominalValues == null || nominalValues.isEmpty()) {
            throw new IllegalStateException("Nominal attribute " + this.getId() + " is set to null or empty new values.");
        }
        this.allValues = nominalValues;
    }

    public Iterator<Value> allValuesIterator() {
        this.checkValuesInitialization();
        return this.allValues.iterator();
    }

    @Override
    public Iterator<Value> iterator() {
        return this.allValuesIterator();
    }
}

