/*
 * Decompiled with CFR 0.152.
 */
package dmLab.geneticFramework;

import dmLab.geneticFramework.Parameter;
import java.util.ArrayList;
import java.util.Random;

public class Instance
implements Cloneable {
    public static int EXPLORATION = 1;
    public static int EXPLOITATION = 2;
    private Parameter[] params;
    private ArrayList<Parameter> paramsList;
    private Random rand;

    public Instance() {
        this.paramsList = new ArrayList();
        this.rand = new Random(System.currentTimeMillis());
    }

    public final void mutate(int type) {
        int i = 0;
        while (i < this.params.length) {
            if (this.rand.nextInt(this.params.length) == 0) {
                this.params[i].mutate(this.rand, type);
            }
            ++i;
        }
    }

    public final int size() {
        if (this.params != null) {
            return this.params.length;
        }
        return 0;
    }

    public final void init() {
        if (this.paramsList != null) {
            Instance instance = this;
            Object[] objectArray = instance.paramsList.toArray();
            instance.params = new Parameter[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                instance.params[n] = (Parameter)objectArray[n];
                ++n;
            }
            instance.paramsList = null;
        }
        int i = 0;
        while (i < this.params.length) {
            this.params[i].init(this.rand);
            ++i;
        }
    }

    public Instance(Instance mother, Instance father) {
        this.rand = new Random(mother.rand.nextLong() + father.rand.nextLong());
        if (mother.size() != father.size()) {
            System.out.println("ERROR! Instances have different length of Params!");
        }
        this.params = new Parameter[mother.size()];
        double d = this.rand.nextGaussian() * 0.15 + 0.5;
        int cut = (int)(d * (double)mother.size());
        int i = 0;
        while (i < this.params.length) {
            this.params[i] = i <= cut ? mother.params[i].clone() : father.params[i].clone();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(Parameter p) {
        void var1_1;
        if (this.paramsList == null) {
            return false;
        }
        this.paramsList.add((Parameter)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final Instance clone() {
        void var1_1;
        Instance instance = new Instance();
        new Instance().params = new Parameter[this.params.length];
        int j = 0;
        while (j < this.params.length) {
            instance.params[j] = this.params[j].clone();
            ++j;
        }
        instance.rand.setSeed(this.rand.nextLong());
        instance.paramsList = null;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.params.length) {
            buf.append(String.valueOf(this.params[i].toString()) + "\n");
            ++i;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final Parameter getParamByIndex(int index) {
        void var1_1;
        if (this.params != null) {
            return this.params[index];
        }
        return this.paramsList.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        Instance instance = new Instance();
        instance.add(new Parameter("lag", 6.0f, 48.0f, false));
        instance.add(new Parameter("stopLossPower", 0.0f, 3.0f, false));
        instance.add(new Parameter("s1", 0.0f, 1.0f, false));
        instance.add(new Parameter("s2", 0.0f, 1.0f, false));
        instance.init();
        int i = 0;
        while (i < 10) {
            void var2_2;
            Instance i2 = instance.clone();
            i2.init();
            System.out.println(i2.toString());
            i2.mutate(EXPLORATION);
            System.out.println(var2_2.toString());
            System.out.println("");
            ++i;
        }
    }
}

