/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.bool;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.BoolIntView;
import org.chocosolver.util.ESat;

public final class BoolLeqView<I extends IntVar>
extends BoolIntView {
    public BoolLeqView(I var, int cste) {
        super(var, "\u2264", cste);
    }

    @Override
    public ESat getBooleanValue() {
        if (this.var.getUB() <= this.cste) {
            return ESat.TRUE;
        }
        if (this.var.getLB() > this.cste) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        boolean done = false;
        if (!this.contains(value)) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            this.contradiction(cause, "empty domain");
        } else if (!this.isInstantiated()) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            this.fixed.set(true);
            if (this.reactOnRemoval) {
                this.delta.add(1 - value, cause);
            }
            done = value == 1 ? this.var.updateUpperBound(this.cste, this) : this.var.updateLowerBound(this.cste + 1, this);
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
        }
        return done;
    }

    @Override
    public int getDomainSize() {
        return this.isInstantiated() ? 1 : 2;
    }

    @Override
    public boolean isInstantiated() {
        if (this.var.getUB() <= this.cste) {
            return true;
        }
        return this.var.getLB() > this.cste;
    }

    @Override
    public boolean contains(int value) {
        if (value == 0) {
            return this.cste < this.var.getUB();
        }
        if (value == 1) {
            return this.var.getLB() <= this.cste;
        }
        return false;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        if (value == 0) {
            return this.cste < this.var.getLB();
        }
        if (value == 1) {
            return this.var.getUB() <= this.cste;
        }
        return false;
    }

    @Override
    public int getLB() {
        if (this.cste < this.var.getUB()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getUB() {
        if (this.var.getLB() <= this.cste) {
            return 1;
        }
        return 0;
    }

    @Override
    public int nextValue(int v) {
        if (v < 0 && this.contains(0)) {
            return 0;
        }
        return v <= 0 && this.contains(1) ? 1 : Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int v) {
        int lb = 0;
        int ub = 1;
        if (this.var.getLB() > this.cste) {
            ub = 0;
        } else if (this.cste >= this.var.getUB()) {
            lb = 1;
        }
        if (lb - 1 <= v && v <= ub) {
            return ub + 1;
        }
        return v + 1;
    }

    @Override
    public int previousValue(int v) {
        if (v > 1 && this.contains(1)) {
            return 1;
        }
        return v >= 1 && this.contains(0) ? 0 : Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int v) {
        int lb = 0;
        int ub = 1;
        if (this.var.getLB() > this.cste) {
            ub = 0;
        } else if (this.cste >= this.var.getUB()) {
            lb = 1;
        }
        if (lb <= v && v <= ub + 1) {
            return lb - 1;
        }
        return v - 1;
    }

    @Override
    public void justifyEvent(IntEventType mask, int one, int two, int three) {
        if (this.isInstantiated()) {
            return;
        }
        switch (mask) {
            case DECUPP: {
                if (one > this.cste) break;
                this.model.getSolver().getEventObserver().instantiateTo(this, 1, this, 0, 1);
                break;
            }
            case INCLOW: {
                if (this.cste >= one) break;
                this.model.getSolver().getEventObserver().instantiateTo(this, 0, this, 0, 1);
                break;
            }
            case REMOVE: {
                if (this.var.getUB() == one && this.var.previousValue(one) <= this.cste) {
                    this.model.getSolver().getEventObserver().instantiateTo(this, 1, this, 0, 1);
                    break;
                }
                if (this.var.getLB() != one || this.var.nextValue(one) <= this.cste) break;
                this.model.getSolver().getEventObserver().instantiateTo(this, 0, this, 0, 1);
                break;
            }
            case INSTANTIATE: {
                if (one <= this.cste) {
                    this.model.getSolver().getEventObserver().instantiateTo(this, 1, this, 0, 1);
                    break;
                }
                this.model.getSolver().getEventObserver().instantiateTo(this, 0, this, 0, 1);
            }
        }
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        assert (!explanation.readDom(p).isEmpty());
        int value = this.getValue();
        if (value == 1) {
            if (pivot == this) {
                assert (explanation.readDom(this).cardinality() == 2);
                this.intersectLit(1, explanation);
                this.var.unionLit(this.cste + 1, 0x3FFFFFFF, explanation);
            } else {
                assert (explanation.readDom(this).cardinality() == 1);
                this.unionLit(0, explanation);
                this.var.intersectLit(-1073741823, this.cste, explanation);
            }
        } else if (value == 0) {
            if (pivot == this) {
                assert (explanation.readDom(this).cardinality() == 2);
                this.intersectLit(0, explanation);
                this.var.unionLit(-1073741823, this.cste, explanation);
            } else {
                assert (explanation.readDom(this).cardinality() == 1);
                this.unionLit(1, explanation);
                this.var.intersectLit(this.cste + 1, 0x3FFFFFFF, explanation);
            }
        }
    }
}

