/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.StringUtils;

public enum Reporting {


    public static String onDecisions(Model model) {
        return model.getSolver().getDecisionPath().toString() + "\n" + model.getSolver().getObjectiveManager().toString();
    }

    public static String onUninstiatedVariables(Model model) {
        Variable[] variables = model.getVars();
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < variables.length; ++c) {
            boolean insV = variables[c].isInstantiated();
            if (insV) continue;
            sb.append("FAILURE >> ").append(variables[c].toString()).append("\n");
        }
        return sb.toString();
    }

    public static String onUnsatisfiedConstraints(Model model) {
        Constraint[] constraints = model.getCstrs();
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < constraints.length; ++c) {
            ESat satC = constraints[c].isSatisfied();
            if (ESat.TRUE.equals((Object)satC)) continue;
            sb.append("FAILURE >> ").append(constraints[c].toString()).append("\n");
        }
        return sb.toString();
    }

    public static String fullReport(Model model) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(StringUtils.pad("", 50, "#")).append("\n");
        sb.append(Reporting.onUninstiatedVariables(model)).append("\n");
        sb.append(StringUtils.pad("", 50, "#")).append("\n");
        sb.append(Reporting.onUnsatisfiedConstraints(model)).append("\n");
        sb.append(StringUtils.pad("", 50, "=")).append("\n");
        sb.append(Reporting.onDecisions(model)).append("\n");
        sb.append(model.getSolver().getMeasures().toOneLineString());
        sb.append(StringUtils.pad("", 50, "#")).append("\n");
        return sb.toString();
    }
}

