/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class CIFFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new CIFFormat();
        }
        return myself;
    }

    public String getFormatName() {
        return "Crystallographic Interchange Format";
    }

    public String getMIMEType() {
        return "chemical/x-cif";
    }

    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    public String[] getNameExtensions() {
        return new String[]{"cif"};
    }

    public String getReaderClassName() {
        return "org.openscience.cdk.io.CIFReader";
    }

    public String getWriterClassName() {
        return null;
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return line.startsWith("_cell_length_a") || line.startsWith("_audit_creation_date") || line.startsWith("loop_");
    }

    public boolean isXMLBased() {
        return false;
    }

    public int getSupportedDataFeatures() {
        return 0;
    }

    public int getRequiredDataFeatures() {
        return 0;
    }
}

