/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.graph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import ru.itmo.ctlab.virgo.Pair;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.GraphIO;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;

public class SimpleIO
implements GraphIO {
    private File nodeIn;
    private File nodeOut;
    private File edgeIn;
    private File edgeOut;
    private List<String> nodeList;
    private List<Pair<String, String>> edgeList;
    private Map<String, Node> nodeMap;
    private Map<String, Map<String, Edge>> edgeMap;
    private boolean mwcsIO;

    public SimpleIO(File nodeIn, File nodeOut, File edgeIn, File edgeOut) {
        this.nodeIn = nodeIn;
        this.edgeOut = edgeOut;
        this.edgeIn = edgeIn;
        this.nodeOut = nodeOut;
        this.nodeMap = new LinkedHashMap<String, Node>();
        this.nodeList = new ArrayList<String>();
        this.edgeList = new ArrayList<Pair<String, String>>();
        this.edgeMap = new LinkedHashMap<String, Map<String, Edge>>();
    }

    public void mwcs() {
        this.mwcsIO = true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Graph read() throws FileNotFoundException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parseNodes(Scanner nodes, Graph graph) throws ParseException {
        int lnum = 0;
        while (nodes.hasNextLine()) {
            StringTokenizer tokenizer;
            ++lnum;
            String line = nodes.nextLine();
            if (line.startsWith("#") || !(tokenizer = new StringTokenizer(line)).hasMoreTokens()) continue;
            String node = tokenizer.nextToken();
            this.nodeList.add(node);
            if (!tokenizer.hasMoreTokens()) {
                throw new ParseException("Expected weight of node in line", lnum);
            }
            String weightStr = tokenizer.nextToken();
            try {
                double weight2 = Double.parseDouble(weightStr);
                Node vertex = new Node(lnum, weight2);
                this.nodeMap.put(node, vertex);
                graph.addVertex(vertex);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected floating point value of node weight in line", lnum);
            }
        }
    }

    private void parseEdges(Scanner edges, Graph graph) throws ParseException {
        int lnum = 0;
        while (edges.hasNextLine()) {
            StringTokenizer tokenizer;
            ++lnum;
            String line = edges.nextLine();
            if (line.startsWith("#") || !(tokenizer = new StringTokenizer(line)).hasMoreTokens()) continue;
            String first = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                throw new ParseException("Expected name of second node in edge list in line", lnum);
            }
            String second = tokenizer.nextToken();
            if (!this.mwcsIO && !tokenizer.hasMoreTokens()) {
                throw new ParseException("Expected weight of edge in line", lnum);
            }
            try {
                double weight2 = this.mwcsIO ? 0.0 : Double.parseDouble(tokenizer.nextToken());
                if (!this.nodeMap.containsKey(first) || !this.nodeMap.containsKey(second)) {
                    throw new ParseException("There's no such vertex in edge list in line", lnum);
                }
                Edge edge = new Edge(lnum, weight2);
                Node from = this.nodeMap.get(first);
                Node to = this.nodeMap.get(second);
                graph.addEdge(from, to, edge);
                this.edgeList.add(new Pair<String, String>(first, second));
                if (!this.edgeMap.containsKey(first)) {
                    this.edgeMap.put(first, new LinkedHashMap());
                }
                this.edgeMap.get(first).put(second, edge);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected floating point value of edge in line", lnum);
            }
        }
    }

    @Override
    public void write(List<Elem> elems) throws IOException {
        if (elems == null) {
            elems = new ArrayList<Elem>();
        }
        LinkedHashSet<Elem> elemSet = new LinkedHashSet<Elem>(elems);
        this.writeNodes(elemSet);
        this.writeEdges(elemSet);
    }

    private void writeEdges(Set<Elem> elems) throws IOException {
        double sum = 0.0;
        this.edgeOut.createNewFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.edgeOut));){
            for (Pair<String, String> p : this.edgeList) {
                Edge edge = this.edgeMap.get(p.first).get(p.second);
                writer.write((String)p.first + "\t" + (String)p.second + "\t" + (elems.contains(edge) ? Double.valueOf(edge.getWeight()) : "n/a"));
                writer.write("\n");
                if (!elems.contains(edge)) continue;
                sum += edge.getWeight();
            }
            writer.write("#subnet edge score\t" + sum);
        }
    }

    private void writeNodes(Set<Elem> elems) throws IOException {
        double sum = 0.0;
        this.nodeOut.createNewFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.nodeOut));){
            for (String name : this.nodeList) {
                Node node = this.nodeMap.get(name);
                if (elems.contains(node)) {
                    sum += node.getWeight();
                }
                writer.write(name + "\t" + (elems.contains(node) ? Double.valueOf(node.getWeight()) : "n/a"));
                writer.write("\n");
            }
            writer.write("#subnet node score\t" + sum);
        }
    }

    @Override
    public Node nodeByName(String name) {
        return this.nodeMap.get(name);
    }
}

