/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.EnvironmentField;
import weka.gui.JListHelper;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.steps.Join;

public class JoinStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = -2648770811063889717L;
    protected JComboBox m_firstKeyFields = new EnvironmentField.WideComboBox();
    protected JComboBox m_secondKeyFields = new EnvironmentField.WideComboBox();
    protected JList m_firstList = new JList();
    protected JList m_secondList = new JList();
    protected DefaultListModel<String> m_firstListModel;
    protected DefaultListModel<String> m_secondListModel;
    protected JButton m_addOneBut = new JButton("Add");
    protected JButton m_deleteOneBut = new JButton("Delete");
    protected JButton m_upOneBut = new JButton("Up");
    protected JButton m_downOneBut = new JButton("Down");
    protected JButton m_addTwoBut = new JButton("Add");
    protected JButton m_deleteTwoBut = new JButton("Delete");
    protected JButton m_upTwoBut = new JButton("Up");
    protected JButton m_downTwoBut = new JButton("Down");

    protected void initialize() {
        this.m_firstListModel = new DefaultListModel();
        this.m_secondListModel = new DefaultListModel();
        this.m_firstList.setModel(this.m_firstListModel);
        this.m_secondList.setModel(this.m_secondListModel);
        String keySpec = ((Join)this.getStepToEdit()).getKeySpec();
        if (keySpec != null && keySpec.length() > 0) {
            String[] parts = (keySpec = this.environmentSubstitute(keySpec)).split("@@KS@@");
            if (parts.length > 0) {
                String[] firstParts;
                for (String s : firstParts = parts[0].trim().split(",")) {
                    this.m_firstListModel.addElement(s);
                }
            }
            if (parts.length > 1) {
                String[] secondParts;
                for (String s : secondParts = parts[1].trim().split(",")) {
                    this.m_secondListModel.addElement(s);
                }
            }
        }
    }

    @Override
    protected void layoutEditor() {
        this.initialize();
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        List<String> connected = ((Join)this.getStepToEdit()).getConnectedInputNames();
        String firstName = connected.get(0) == null ? "<not connected>" : connected.get(0);
        String secondName = connected.get(1) == null ? "<not connected>" : connected.get(1);
        JPanel firstSourceP = new JPanel();
        firstSourceP.setLayout(new BorderLayout());
        firstSourceP.add((Component)new JLabel("First input ", 4), "Center");
        firstSourceP.add((Component)new JLabel(firstName, 2), "East");
        JPanel secondSourceP = new JPanel();
        secondSourceP.setLayout(new BorderLayout());
        secondSourceP.add((Component)new JLabel("Second input ", 4), "Center");
        secondSourceP.add((Component)new JLabel(secondName, 2), "East");
        JPanel sourcePHolder = new JPanel();
        sourcePHolder.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        sourcePHolder.setLayout(new BorderLayout());
        sourcePHolder.add((Component)firstSourceP, "North");
        sourcePHolder.add((Component)secondSourceP, "South");
        controlHolder.add((Component)sourcePHolder, "North");
        this.m_firstList.setVisibleRowCount(5);
        this.m_secondList.setVisibleRowCount(5);
        this.m_firstKeyFields.setEditable(true);
        JPanel listOneP = new JPanel();
        this.m_deleteOneBut.setEnabled(false);
        listOneP.setLayout(new BorderLayout());
        JPanel butOneHolder = new JPanel();
        butOneHolder.setLayout(new GridLayout(1, 0));
        butOneHolder.add(this.m_addOneBut);
        butOneHolder.add(this.m_deleteOneBut);
        butOneHolder.add(this.m_upOneBut);
        butOneHolder.add(this.m_downOneBut);
        this.m_upOneBut.setEnabled(false);
        this.m_downOneBut.setEnabled(false);
        JPanel fieldsAndButsOne = new JPanel();
        fieldsAndButsOne.setLayout(new BorderLayout());
        fieldsAndButsOne.add((Component)this.m_firstKeyFields, "North");
        fieldsAndButsOne.add((Component)butOneHolder, "South");
        listOneP.add((Component)fieldsAndButsOne, "North");
        JScrollPane js1 = new JScrollPane(this.m_firstList);
        js1.setBorder(BorderFactory.createTitledBorder("First input key fields"));
        listOneP.add((Component)js1, "Center");
        controlHolder.add((Component)listOneP, "West");
        this.m_secondKeyFields.setEditable(true);
        JPanel listTwoP = new JPanel();
        this.m_deleteTwoBut.setEnabled(false);
        listTwoP.setLayout(new BorderLayout());
        JPanel butTwoHolder = new JPanel();
        butTwoHolder.setLayout(new GridLayout(1, 0));
        butTwoHolder.add(this.m_addTwoBut);
        butTwoHolder.add(this.m_deleteTwoBut);
        butTwoHolder.add(this.m_upTwoBut);
        butTwoHolder.add(this.m_downTwoBut);
        this.m_upTwoBut.setEnabled(false);
        this.m_downTwoBut.setEnabled(false);
        JPanel fieldsAndButsTwo = new JPanel();
        fieldsAndButsTwo.setLayout(new BorderLayout());
        fieldsAndButsTwo.add((Component)this.m_secondKeyFields, "North");
        fieldsAndButsTwo.add((Component)butTwoHolder, "South");
        listTwoP.add((Component)fieldsAndButsTwo, "North");
        JScrollPane js2 = new JScrollPane(this.m_secondList);
        js2.setBorder(BorderFactory.createTitledBorder("Second input key fields"));
        listTwoP.add((Component)js2, "Center");
        controlHolder.add((Component)listTwoP, "East");
        this.add((Component)controlHolder, "Center");
        try {
            int i;
            Instances incoming;
            if (((Join)this.getStepToEdit()).getFirstInputStructure() != null) {
                this.m_firstKeyFields.removeAllItems();
                incoming = ((Join)this.getStepToEdit()).getFirstInputStructure();
                for (i = 0; i < incoming.numAttributes(); ++i) {
                    this.m_firstKeyFields.addItem(incoming.attribute(i).name());
                }
            }
            if (((Join)this.getStepToEdit()).getSecondInputStructure() != null) {
                this.m_secondKeyFields.removeAllItems();
                incoming = ((Join)this.getStepToEdit()).getSecondInputStructure();
                for (i = 0; i < incoming.numAttributes(); ++i) {
                    this.m_secondKeyFields.addItem(incoming.attribute(i).name());
                }
            }
        }
        catch (WekaException ex) {
            this.showErrorDialog(ex);
        }
        this.m_firstList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !JoinStepEditorDialog.this.m_deleteOneBut.isEnabled()) {
                    JoinStepEditorDialog.this.m_deleteOneBut.setEnabled(true);
                }
            }
        });
        this.m_secondList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !JoinStepEditorDialog.this.m_deleteTwoBut.isEnabled()) {
                    JoinStepEditorDialog.this.m_deleteTwoBut.setEnabled(true);
                }
            }
        });
        this.m_addOneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JoinStepEditorDialog.this.m_firstKeyFields.getSelectedItem() != null && JoinStepEditorDialog.this.m_firstKeyFields.getSelectedItem().toString().length() > 0) {
                    JoinStepEditorDialog.this.m_firstListModel.addElement(JoinStepEditorDialog.this.m_firstKeyFields.getSelectedItem().toString());
                    if (JoinStepEditorDialog.this.m_firstListModel.size() > 1) {
                        JoinStepEditorDialog.this.m_upOneBut.setEnabled(true);
                        JoinStepEditorDialog.this.m_downOneBut.setEnabled(true);
                    }
                }
            }
        });
        this.m_addTwoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JoinStepEditorDialog.this.m_secondKeyFields.getSelectedItem() != null && JoinStepEditorDialog.this.m_secondKeyFields.getSelectedItem().toString().length() > 0) {
                    JoinStepEditorDialog.this.m_secondListModel.addElement(JoinStepEditorDialog.this.m_secondKeyFields.getSelectedItem().toString());
                    if (JoinStepEditorDialog.this.m_secondListModel.size() > 1) {
                        JoinStepEditorDialog.this.m_upTwoBut.setEnabled(true);
                        JoinStepEditorDialog.this.m_downTwoBut.setEnabled(true);
                    }
                }
            }
        });
        this.m_deleteOneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = JoinStepEditorDialog.this.m_firstList.getSelectedIndex();
                if (selected >= 0) {
                    JoinStepEditorDialog.this.m_firstListModel.remove(selected);
                }
                if (JoinStepEditorDialog.this.m_firstListModel.size() <= 1) {
                    JoinStepEditorDialog.this.m_upOneBut.setEnabled(false);
                    JoinStepEditorDialog.this.m_downOneBut.setEnabled(false);
                }
            }
        });
        this.m_deleteTwoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = JoinStepEditorDialog.this.m_secondList.getSelectedIndex();
                if (selected >= 0) {
                    JoinStepEditorDialog.this.m_secondListModel.remove(selected);
                }
                if (JoinStepEditorDialog.this.m_secondListModel.size() <= 1) {
                    JoinStepEditorDialog.this.m_upTwoBut.setEnabled(false);
                    JoinStepEditorDialog.this.m_downTwoBut.setEnabled(false);
                }
            }
        });
        this.m_upOneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveUp(JoinStepEditorDialog.this.m_firstList);
            }
        });
        this.m_upTwoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveUp(JoinStepEditorDialog.this.m_secondList);
            }
        });
        this.m_downOneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveDown(JoinStepEditorDialog.this.m_firstList);
            }
        });
        this.m_downTwoBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveDown(JoinStepEditorDialog.this.m_secondList);
            }
        });
    }

    @Override
    public void okPressed() {
        int i;
        StringBuilder b = new StringBuilder();
        for (i = 0; i < this.m_firstListModel.size(); ++i) {
            if (i != 0) {
                b.append(",");
            }
            b.append(this.m_firstListModel.get(i));
        }
        b.append("@@KS@@");
        for (i = 0; i < this.m_secondListModel.size(); ++i) {
            if (i != 0) {
                b.append(",");
            }
            b.append(this.m_secondListModel.get(i));
        }
        ((Join)this.getStepToEdit()).setKeySpec(b.toString());
    }
}

