/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Discretizers.Bayesian_Discretizer;

import java.util.Collections;
import java.util.Vector;
import keel.Algorithms.Discretizers.Basic.Discretizer;
import keel.Algorithms.Genetic_Rule_Learning.Globals.Parameters;

public class BayesianDiscretizer
extends Discretizer {
    @Override
    protected Vector discretizeAttribute(int attribute, int[] values, int begin, int end) {
        int j;
        int size;
        int i;
        int j2;
        Vector cd = this.classDistribution(attribute, values, begin, end);
        if (cd.size() == 1) {
            return new Vector();
        }
        int numValues = this.sumValues(cd);
        Vector<Double> cutPoints = new Vector<Double>();
        Vector differentValues = this.getAttributeDifferentValues(attribute, values, begin, end);
        Vector<Integer> frequencyValues = new Vector<Integer>();
        Vector F_x = new Vector();
        Vector<Vector> all_leads = new Vector<Vector>();
        int size2 = differentValues.size() - 1;
        for (j2 = 0; j2 < size2; ++j2) {
            int frequency = (Integer)differentValues.elementAt(j2 + 1) - (Integer)differentValues.elementAt(j2);
            frequencyValues.addElement(new Integer(frequency));
        }
        frequencyValues.addElement(new Integer(end - begin + 1 - (Integer)differentValues.elementAt(differentValues.size() - 1)));
        for (i = 0; i < Parameters.numClasses; ++i) {
            int frequency;
            double Pcj = (double)((Integer)cd.elementAt(i) + 1) / (double)(numValues + 2);
            Vector<Double> conditionalClassDistribution = new Vector<Double>();
            Vector<Double> f_x = new Vector<Double>();
            size = differentValues.size() - 1;
            for (j = 0; j < size; ++j) {
                frequency = 0;
                for (int k = ((Integer)differentValues.elementAt(j)).intValue(); k < (Integer)differentValues.elementAt(j + 1); ++k) {
                    if (this.classOfInstances[values[k]] != i) continue;
                    ++frequency;
                }
                conditionalClassDistribution.addElement(new Double((double)frequency / (double)((Integer)frequencyValues.elementAt(j)).intValue()));
                f_x.addElement(new Double((double)frequency / (double)((Integer)frequencyValues.elementAt(j)).intValue() * Pcj));
            }
            frequency = 0;
            for (int k = ((Integer)differentValues.elementAt(differentValues.size() - 1)).intValue(); k < end - begin + 1; ++k) {
                if (this.classOfInstances[values[k]] != i) continue;
                ++frequency;
            }
            conditionalClassDistribution.addElement(new Double((double)frequency / (double)((Integer)frequencyValues.elementAt(differentValues.size() - 1)).intValue()));
            f_x.addElement(new Double((double)frequency / (double)((Integer)frequencyValues.elementAt(differentValues.size() - 1)).intValue() * Pcj));
            F_x.add(f_x);
        }
        size2 = differentValues.size();
        for (j2 = 0; j2 < size2; ++j2) {
            Vector lead = this.leadCurve(F_x, j2);
            all_leads.add(lead);
        }
        for (i = 0; i < Parameters.numClasses; ++i) {
            boolean is_leading = ((Vector)all_leads.get(0)).contains(new Integer(i));
            size = differentValues.size() - 1;
            for (j = 1; j < size; ++j) {
                double cutPoint;
                int posMax;
                if (((Vector)all_leads.get(j)).contains(new Integer(i))) {
                    if (is_leading) continue;
                    posMax = (Integer)differentValues.elementAt(j);
                    cutPoint = (this.realValues[attribute][values[posMax - 1]] + this.realValues[attribute][values[posMax]]) / 2.0;
                    if (!cutPoints.contains(new Double(cutPoint))) {
                        cutPoints.addElement(new Double(cutPoint));
                    }
                    is_leading = true;
                    continue;
                }
                if (!is_leading) continue;
                posMax = (Integer)differentValues.elementAt(j);
                cutPoint = (this.realValues[attribute][values[posMax - 1]] + this.realValues[attribute][values[posMax]]) / 2.0;
                if (!cutPoints.contains(new Double(cutPoint))) {
                    cutPoints.addElement(new Double(cutPoint));
                }
                is_leading = false;
            }
        }
        Collections.sort(cutPoints.subList(0, cutPoints.size()));
        return cutPoints;
    }

    private Vector leadCurve(Vector function_points, int x_value) {
        Vector<Integer> lead_classes = new Vector<Integer>();
        lead_classes.addElement(new Integer(0));
        double high_value = (Double)((Vector)function_points.get(0)).elementAt(x_value);
        for (int i = 1; i < Parameters.numClasses; ++i) {
            double value = (Double)((Vector)function_points.get(i)).elementAt(x_value);
            if (value > high_value) {
                lead_classes.clear();
                lead_classes.addElement(new Integer(i));
                high_value = value;
                continue;
            }
            if (value != high_value) continue;
            lead_classes.addElement(new Integer(i));
        }
        return lead_classes;
    }

    private int sumValues(Vector v) {
        int sum = 0;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            sum += ((Integer)v.elementAt(i)).intValue();
        }
        return sum;
    }

    private Vector getAttributeDifferentValues(int attribute, int[] values, int begin, int end) {
        Vector<Integer> cutPoints = new Vector<Integer>();
        double valueAnt = this.realValues[attribute][values[begin]];
        cutPoints.addElement(new Integer(begin));
        for (int i = begin; i <= end; ++i) {
            double val = this.realValues[attribute][values[i]];
            if (val != valueAnt) {
                cutPoints.addElement(new Integer(i));
            }
            valueAnt = val;
        }
        return cutPoints;
    }

    private Vector classDistribution(int attribute, int[] values, int begin, int end) {
        int i;
        int[] classCount = new int[Parameters.numClasses];
        for (i = 0; i < Parameters.numClasses; ++i) {
            classCount[i] = 0;
        }
        for (i = begin; i <= end; ++i) {
            int n = this.classOfInstances[values[i]];
            classCount[n] = classCount[n] + 1;
        }
        Vector<Integer> res = new Vector<Integer>();
        for (int i2 = 0; i2 < Parameters.numClasses; ++i2) {
            res.addElement(new Integer(classCount[i2]));
        }
        return res;
    }
}

