/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Model;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes.GenotypeFuzzyGAP;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividual;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividualForModels;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Model.FuzzyGPModel;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeRuleBase;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.Fuzzy;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyPartition;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import keel.Algorithms.Shared.Exceptions.invalidOptim;
import org.core.Randomize;

public class FuzzyGAPModelIndividual
extends GeneticIndividualForModels {
    private static FuzzyPartition[] A;
    private static FuzzyPartition C;
    private int defuzType;

    private Fuzzy label(int nv, int nlabel) {
        return A[nv].getComponent(nlabel);
    }

    int numlabels(int nv) {
        return A[nv].size();
    }

    public FuzzyGAPModelIndividual(FuzzyPartition[] a, FuzzyPartition c, int MAXH, int tf, Randomize r, int td) {
        super(tf);
        A = a;
        C = c;
        GenotypeFuzzyGAP gf = new GenotypeFuzzyGAP(A, C, MAXH, r);
        this.g = gf;
        this.defuzType = td;
        this.m = new FuzzyGPModel((NodeRuleBase)gf.getRootNode(), C, td);
    }

    public FuzzyGAPModelIndividual(FuzzyGAPModelIndividual p) {
        super(p.fitnessType);
        this.g = p.g.clone();
        GenotypeFuzzyGAP gf = (GenotypeFuzzyGAP)this.g;
        this.defuzType = p.defuzType;
        this.m = new FuzzyGPModel((NodeRuleBase)gf.getRootNode(), C, this.defuzType);
    }

    @Override
    public GeneticIndividual clone() {
        return new FuzzyGAPModelIndividual(this);
    }

    public void set(FuzzyGAPModelIndividual p) {
        this.g = p.g.clone();
        GenotypeFuzzyGAP gf = (GenotypeFuzzyGAP)this.g;
        this.defuzType = p.defuzType;
        this.m = new FuzzyGPModel((NodeRuleBase)gf.getRootNode(), C, this.defuzType);
    }

    public GeneticIndividual FuzzyGAPModelIndividualoClona() {
        return new FuzzyGAPModelIndividual(this);
    }

    @Override
    public void parametersFromGenotype() {
        GenotypeFuzzyGAP gf = (GenotypeFuzzyGAP)this.g;
        this.m = new FuzzyGPModel((NodeRuleBase)gf.getRootNode(), C, this.defuzType);
    }

    @Override
    public void Random() {
        this.g.Random();
        this.parametersFromGenotype();
    }

    @Override
    public void mutation(double alpha, int IDMUTA) throws invalidMutation {
        this.g.mutation(alpha, IDMUTA);
        this.parametersFromGenotype();
    }

    @Override
    public void crossover(GeneticIndividual p2, GeneticIndividual p3, GeneticIndividual p4, int IDCRUCE) throws invalidCrossover {
        FuzzyGAPModelIndividual f2 = (FuzzyGAPModelIndividual)p2;
        FuzzyGAPModelIndividual f3 = (FuzzyGAPModelIndividual)p3;
        FuzzyGAPModelIndividual f4 = (FuzzyGAPModelIndividual)p4;
        this.g.crossover(f2.g, f3.g, f4.g, IDCRUCE);
        f3.parametersFromGenotype();
        f4.parametersFromGenotype();
    }

    @Override
    public void debug() {
        this.g.debug();
    }

    @Override
    public void localOptimization(int MAXITER, int idoptimization) throws invalidOptim {
        throw new invalidOptim("Optimizacion local no implementada en FuzzyGAPModelIndividual");
    }
}

