/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasoner;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class RDFSReasonerFactory
implements ReasonerFactory {
    private static ReasonerFactory theInstance = new RDFSReasonerFactory();
    public static final String URI = "http://jena.hpl.hp.com/2003/RDFSReasoner1";
    protected Model capabilities;
    public static final Property scanProperties = new PropertyImpl("http://jena.hpl.hp.com/2003/RDFSReasoner1#", "scanProperties");

    public static ReasonerFactory theInstance() {
        return theInstance;
    }

    public Reasoner create(Resource configuration) {
        return new RDFSReasoner(configuration);
    }

    public Model getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = ModelFactory.createDefaultModel();
            Resource base = this.capabilities.createResource(this.getURI());
            base.addProperty(ReasonerVocabulary.nameP, "RDFS Reasoner 1").addProperty(ReasonerVocabulary.descriptionP, "Complete RDFS implementation supporting metalevel statements.\nEager caching of schema information, back chaining for most entailments\nCan separate tbox and abox data if desired to reuse tbox caching or mix them.").addProperty(ReasonerVocabulary.configurationP, scanProperties).addProperty(ReasonerVocabulary.supportsP, RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, RDFS.member).addProperty(ReasonerVocabulary.supportsP, RDFS.range).addProperty(ReasonerVocabulary.supportsP, RDFS.domain).addProperty(ReasonerVocabulary.supportsP, TransitiveReasoner.directSubClassOf).addProperty(ReasonerVocabulary.supportsP, TransitiveReasoner.directSubPropertyOf).addProperty(ReasonerVocabulary.versionP, "0.1");
        }
        return this.capabilities;
    }

    public String getURI() {
        return URI;
    }

    public static void main(String[] args) {
        Resource rdfsDescr = ReasonerRegistry.theRegistry().getDescription(URI);
        System.out.println("Reasoner: " + rdfsDescr);
        StmtIterator i = rdfsDescr.listProperties();
        while (i.hasNext()) {
            Statement s = i.nextStatement();
            System.out.println(s.getPredicate().getLocalName() + " = " + s.getObject());
        }
    }
}

