/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ssf.BaseArrayState;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfException;
import ec.tstoolkit.ssf.State;

public class FastArrayState
extends BaseArrayState {
    public DataBlock L;

    public FastArrayState(FastArrayState state) {
        super(state);
        this.L = state.L.deepClone();
    }

    public FastArrayState(int n, boolean hasdata) {
        super(n, hasdata);
        this.L = new DataBlock(n);
    }

    public FastArrayState(ISsf ssf, State state, int pos) {
        super(ssf.getStateDim(), true);
        int dim = ssf.getStateDim();
        this.L = new DataBlock(dim);
        this.A.copy(state.A);
        double var = ssf.ZVZ(pos, state.P.subMatrix());
        this.r = Math.sqrt(var);
        ssf.ZM(pos, state.P.subMatrix(), this.K);
        ssf.TX(pos, this.K);
        Matrix V = state.P;
        Matrix TVT = V.clone();
        ssf.TVT(pos, TVT.subMatrix());
        Matrix Q = new Matrix(dim, dim);
        ssf.fullQ(pos, Q.subMatrix());
        V.sub(Q);
        V.sub(TVT);
        this.K.mul(1.0 / this.r);
        for (int i = 0; i < dim; ++i) {
            double kv = this.K.get(i);
            if (kv == 0.0) continue;
            V.add(i, i, kv * this.K.get(i));
            for (int j = 0; j < i; ++j) {
                V.add(i, j, kv * this.K.get(j));
                V.add(j, i, kv * this.K.get(j));
            }
        }
        int imax = 0;
        double lmax = V.get(0, 0);
        for (int i = 1; i < dim; ++i) {
            double lcur = V.get(i, i);
            if (!(lcur > lmax)) continue;
            imax = i;
            lmax = lcur;
        }
        if (lmax <= 0.0) {
            throw new SsfException("Invalid fast filter");
        }
        this.L.copy(V.column(imax));
        this.L.mul(Math.sqrt(1.0 / lmax));
    }

    public void copy(FastArrayState state) {
        super.copy(state);
        this.L = state.L.deepClone();
    }
}

