/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DelegateObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DiagonalObjectMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected ObjectMatrix2D content;

    public WrapperObjectMatrix2D(ObjectMatrix2D objectMatrix2D) {
        block3: {
            if (objectMatrix2D != null) {
                try {
                    this.setUp(objectMatrix2D.rows(), objectMatrix2D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = objectMatrix2D;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, ObjectObjectFunction objectObjectFunction) {
        this.checkShape(objectMatrix2D);
        if (objectMatrix2D instanceof WrapperObjectMatrix2D) {
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            ObjectArrayList objectArrayList = new ObjectArrayList();
            objectMatrix2D.getNonZeros(intArrayList, intArrayList2, objectArrayList);
            this.assign(objectMatrix2D, objectObjectFunction, intArrayList, intArrayList2);
        } else {
            super.assign(objectMatrix2D, objectObjectFunction);
        }
        return this;
    }

    public ObjectMatrix2D assign(final int[] nArray) {
        if (this.content instanceof DiagonalObjectMatrix2D) {
            int n = ((DiagonalObjectMatrix2D)this.content).dlength;
            final Object[] objectArray = ((DiagonalObjectMatrix2D)this.content).elements;
            if (nArray.length != n) {
                throw new IllegalArgumentException("Must have same length: length=" + nArray.length + " dlength=" + n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                objectArray[i] = nArray[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = nArray[i];
                }
            }
            return this;
        }
        return super.assign((Object)nArray);
    }

    public ObjectMatrix2D assign(final Object[] objectArray) {
        if (this.content instanceof DiagonalObjectMatrix2D) {
            int n = ((DiagonalObjectMatrix2D)this.content).dlength;
            final Object[] objectArray2 = ((DiagonalObjectMatrix2D)this.content).elements;
            if (objectArray.length != n) {
                throw new IllegalArgumentException("Must have same length: length=" + objectArray.length + " dlength=" + n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                objectArray2[i] = objectArray[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    objectArray2[i] = objectArray[i];
                }
            }
            return this;
        }
        return super.assign(objectArray);
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized Object getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalObjectMatrix2D && object instanceof DiagonalObjectMatrix2D) {
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalObjectMatrix2D diagonalObjectMatrix2D = (DiagonalObjectMatrix2D)this.content;
            DiagonalObjectMatrix2D diagonalObjectMatrix2D2 = (DiagonalObjectMatrix2D)object;
            if (diagonalObjectMatrix2D.columns() != diagonalObjectMatrix2D2.columns() || diagonalObjectMatrix2D.rows() != diagonalObjectMatrix2D2.rows() || diagonalObjectMatrix2D.diagonalIndex() != diagonalObjectMatrix2D2.diagonalIndex() || diagonalObjectMatrix2D.diagonalLength() != diagonalObjectMatrix2D2.diagonalLength()) {
                return false;
            }
            Object[] objectArray = diagonalObjectMatrix2D.elements();
            Object[] objectArray2 = diagonalObjectMatrix2D2.elements();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray2[i];
                Object object3 = objectArray[i];
                if (object2.equals(object3)) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public ObjectMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public synchronized void setQuick(int n, int n2, Object object) {
        this.content.setQuick(n, n2, object);
    }

    public ObjectMatrix1D vectorize() {
        final DenseObjectMatrix1D denseObjectMatrix1D = new DenseObjectMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                final int n5 = i * n2 * this.rows;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n5;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperObjectMatrix2D.this.rows; ++j) {
                                denseObjectMatrix1D.setQuick(n++, WrapperObjectMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseObjectMatrix1D.setQuick(n6++, this.getQuick(j, i));
                }
            }
        }
        return denseObjectMatrix1D;
    }

    public ObjectMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public ObjectMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperObjectMatrix2D wrapperObjectMatrix2D = new WrapperObjectMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public synchronized void setQuick(int n, int n2, Object object) {
                this.content.setQuick(n, this.columns - 1 - n2, object);
            }

            public synchronized Object get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public synchronized void set(int n, int n2, Object object) {
                this.content.set(n, this.columns - 1 - n2, object);
            }
        };
        wrapperObjectMatrix2D.isNoView = false;
        return wrapperObjectMatrix2D;
    }

    public ObjectMatrix2D viewDice() {
        WrapperObjectMatrix2D wrapperObjectMatrix2D = new WrapperObjectMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public synchronized void setQuick(int n, int n2, Object object) {
                this.content.setQuick(n2, n, object);
            }

            public synchronized Object get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public synchronized void set(int n, int n2, Object object) {
                this.content.set(n2, n, object);
            }
        };
        wrapperObjectMatrix2D.rows = this.columns;
        wrapperObjectMatrix2D.columns = this.rows;
        wrapperObjectMatrix2D.isNoView = false;
        return wrapperObjectMatrix2D;
    }

    public ObjectMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperObjectMatrix2D wrapperObjectMatrix2D = new WrapperObjectMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public synchronized void setQuick(int n3, int n22, Object object) {
                this.content.setQuick(n + n3, n2 + n22, object);
            }

            public synchronized Object get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public synchronized void set(int n3, int n22, Object object) {
                this.content.set(n + n3, n2 + n22, object);
            }
        };
        wrapperObjectMatrix2D.rows = n3;
        wrapperObjectMatrix2D.columns = n4;
        wrapperObjectMatrix2D.isNoView = false;
        return wrapperObjectMatrix2D;
    }

    public ObjectMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateObjectMatrix1D(this, n);
    }

    public ObjectMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperObjectMatrix2D wrapperObjectMatrix2D = new WrapperObjectMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public synchronized void setQuick(int n, int n2, Object object) {
                this.content.setQuick(this.rows - 1 - n, n2, object);
            }

            public synchronized Object get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public synchronized void set(int n, int n2, Object object) {
                this.content.set(this.rows - 1 - n, n2, object);
            }
        };
        wrapperObjectMatrix2D.isNoView = false;
        return wrapperObjectMatrix2D;
    }

    public ObjectMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperObjectMatrix2D wrapperObjectMatrix2D = new WrapperObjectMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public synchronized void setQuick(int n, int n2, Object object) {
                this.content.setQuick(nArray3[n], nArray4[n2], object);
            }

            public synchronized Object get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public synchronized void set(int n, int n2, Object object) {
                this.content.set(nArray3[n], nArray4[n2], object);
            }
        };
        wrapperObjectMatrix2D.rows = nArray.length;
        wrapperObjectMatrix2D.columns = nArray2.length;
        wrapperObjectMatrix2D.isNoView = false;
        return wrapperObjectMatrix2D;
    }

    public ObjectMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperObjectMatrix2D wrapperObjectMatrix2D = new WrapperObjectMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public synchronized void setQuick(int n3, int n22, Object object) {
                this.content.setQuick(n * n3, n2 * n22, object);
            }

            public synchronized Object get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public synchronized void set(int n3, int n22, Object object) {
                this.content.set(n * n3, n2 * n22, object);
            }
        };
        if (this.rows != 0) {
            wrapperObjectMatrix2D.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            wrapperObjectMatrix2D.columns = (this.columns - 1) / n2 + 1;
        }
        wrapperObjectMatrix2D.isNoView = false;
        return wrapperObjectMatrix2D;
    }

    protected ObjectMatrix2D getContent() {
        return this.content;
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }
}

