/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.continuous.SampledMultivariateTraitLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class ContinuousTraitBranchRateModel
extends AbstractBranchRateModel {
    private final String trait;
    private final int dimension;
    private final Parameter rateParameter;
    private final Parameter ratioParameter;
    private SampledMultivariateTraitLikelihood traitLikelihood;

    public ContinuousTraitBranchRateModel(SampledMultivariateTraitLikelihood sampledMultivariateTraitLikelihood, int n) {
        super("continuousTraitRateModel");
        this.traitLikelihood = sampledMultivariateTraitLikelihood;
        this.trait = sampledMultivariateTraitLikelihood.getTraitName();
        this.dimension = n;
        this.rateParameter = null;
        this.ratioParameter = null;
        this.addModel(sampledMultivariateTraitLikelihood);
    }

    public ContinuousTraitBranchRateModel(String string, Parameter parameter, Parameter parameter2) {
        super("continuousTraitRateModel");
        this.trait = string;
        this.dimension = 0;
        this.rateParameter = parameter;
        this.ratioParameter = parameter2;
        if (parameter != null) {
            this.addVariable(parameter);
        }
        if (parameter2 != null) {
            this.addVariable(parameter2);
        }
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nodeRef2 == null) {
            throw new IllegalArgumentException("Root does not have a valid rate");
        }
        double d = 1.0;
        TreeModel treeModel = (TreeModel)tree;
        if (this.rateParameter != null) {
            double d2;
            double d3;
            double d4 = 1.0;
            double d5 = 1.0;
            if (this.rateParameter != null) {
                d4 = this.rateParameter.getParameterValue(0);
            }
            if (this.ratioParameter != null) {
                d5 = this.ratioParameter.getParameterValue(0);
            }
            if ((d3 = d5 * treeModel.getMultivariateNodeTrait(nodeRef, this.trait)[0]) == (d2 = d5 * treeModel.getMultivariateNodeTrait(nodeRef2, this.trait)[0])) {
                return d4 * Math.exp(d3);
            }
            d = d4 * (Math.exp(d2) - Math.exp(d3)) / (d2 - d3);
        } else {
            double d6;
            double d7 = treeModel.getMultivariateNodeTrait(nodeRef, this.trait)[this.dimension];
            if (d7 == (d6 = treeModel.getMultivariateNodeTrait(nodeRef2, this.trait)[this.dimension])) {
                return Math.exp(d7);
            }
            d = (Math.exp(d6) - Math.exp(d7)) / (d6 - d7);
        }
        return d;
    }
}

