/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.tree.TreeModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.util.HeapSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jebl.util.FixedBitSet;

public class MulSpeciesBindings
extends AbstractModel
implements Loggable {
    private final GeneTreeInfo[] geneTreeInfos;
    private final AlloppSpeciesBindings.ApSpInfo[] apspecies;
    private final Taxon[] taxa;
    private final Map<Taxon, Integer> taxon2index = new HashMap<Taxon, Integer>();
    private final int[][] spsq;
    private final int numberOfSpSeqs;
    private final double[][] popTimesPair;
    private boolean dirty_pp;
    private final double[][] popTimesSingle;
    private boolean dirty_sg;
    private final boolean verbose = false;

    public MulSpeciesBindings(AlloppSpeciesBindings.ApSpInfo[] apSpInfoArray, TreeModel[] treeModelArray, double[] dArray) {
        super("mulSpecies");
        int n;
        int n2;
        this.apspecies = apSpInfoArray;
        int n3 = 0;
        for (AlloppSpeciesBindings.ApSpInfo apSpInfo : apSpInfoArray) {
            n3 += apSpInfo.individuals.length;
        }
        Taxon[] taxonArray = new AlloppSpeciesBindings.Individual[n3];
        n3 = 0;
        for (AlloppSpeciesBindings.ApSpInfo apSpInfo : apSpInfoArray) {
            int n4 = 0;
            while (n4 < apSpInfo.individuals.length) {
                taxonArray[n3] = apSpInfo.individuals[n4];
                ++n4;
                ++n3;
            }
        }
        int n5 = 0;
        for (Taxon taxon : taxonArray) {
            n5 += ((AlloppSpeciesBindings.Individual)taxon).taxa.length;
        }
        this.taxa = new Taxon[n5];
        n5 = 0;
        Taxon[] taxonArray2 = taxonArray;
        int n6 = taxonArray2.length;
        for (n2 = 0; n2 < n6; ++n2) {
            Taxon taxon = taxonArray2[n2];
            int n7 = 0;
            while (n7 < ((AlloppSpeciesBindings.Individual)taxon).taxa.length) {
                this.taxa[n5] = ((AlloppSpeciesBindings.Individual)taxon).taxa[n7];
                ++n7;
                ++n5;
            }
        }
        for (n = 0; n < this.taxa.length; ++n) {
            this.taxon2index.put(this.taxa[n], n);
        }
        this.spsq = new int[apSpInfoArray.length][];
        n = 0;
        for (n6 = 0; n6 < apSpInfoArray.length; ++n6) {
            this.spsq[n6] = new int[apSpInfoArray[n6].ploidylevel / 2];
            for (n2 = 0; n2 < this.spsq[n6].length; ++n2) {
                this.spsq[n6][n2] = n++;
            }
        }
        this.numberOfSpSeqs = n;
        this.geneTreeInfos = new GeneTreeInfo[treeModelArray.length];
        for (n6 = 0; n6 < treeModelArray.length; ++n6) {
            TreeModel treeModel = treeModelArray[n6];
            this.addModel(treeModel);
            this.geneTreeInfos[n6] = new GeneTreeInfo(treeModel, dArray[n6]);
        }
        this.popTimesSingle = new double[this.numberOfSpSeqs][];
        for (n6 = 0; n6 < this.popTimesSingle.length; ++n6) {
            this.popTimesSingle[n6] = new double[this.allCoalPointsCount(n6)];
        }
        this.dirty_sg = true;
        this.popTimesPair = new double[this.numberOfSpSeqs * (this.numberOfSpSeqs - 1) / 2][];
        n6 = this.allPairCoalPointsCount();
        for (int i = 0; i < this.popTimesPair.length; ++i) {
            this.popTimesPair[i] = new double[n6];
        }
        this.dirty_pp = true;
        this.addStatistic(new SpeciesLimits());
    }

    public int numberOfGeneTrees() {
        return this.geneTreeInfos.length;
    }

    public int nSpSeqs() {
        return this.numberOfSpSeqs;
    }

    public String apspeciesName(int n) {
        return this.apspecies[n].name;
    }

    public int spseqindex2sp(int n) {
        return this.spseqindex2spandseq(n)[0];
    }

    public int spseqindex2seq(int n) {
        return this.spseqindex2spandseq(n)[1];
    }

    public SpeciesIndivPair apspeciesId2speciesindiv(String string) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.apspecies.length; ++i) {
            for (int j = 0; j < this.apspecies[i].individuals.length; ++j) {
                for (int k = 0; k < this.apspecies[i].individuals[j].taxa.length; ++k) {
                    Taxon taxon = this.apspecies[i].individuals[j].taxa[k];
                    if (taxon.getId().compareTo(string) != 0) continue;
                    n = i;
                    n2 = j;
                }
            }
        }
        assert (n != -1);
        SpeciesIndivPair speciesIndivPair = new SpeciesIndivPair(n, n2);
        return speciesIndivPair;
    }

    public void permuteOneSpeciesOneIndivForOneGene() {
        int n = MathUtils.nextInt(this.geneTreeInfos.length);
        this.geneTreeInfos[n].permuteOneSpeciesOneIndiv();
        this.geneTreeInfos[n].wasChanged();
    }

    public void permuteSetOfIndivsForOneGene() {
        int n = MathUtils.nextInt(this.geneTreeInfos.length);
        this.geneTreeInfos[n].permuteSetOfIndivs();
        this.geneTreeInfos[n].wasChanged();
    }

    public String seqassignsAsText(int n) {
        return this.geneTreeInfos[n].seqassignsAsText();
    }

    public String genetreeAsText(int n) {
        return this.geneTreeInfos[n].genetreeAsText();
    }

    public double[][] getPopTimesSingle() {
        if (this.dirty_sg) {
            for (int i = 0; i < this.popTimesSingle.length; ++i) {
                this.getAllCoalPoints(i, this.popTimesSingle[i]);
            }
            this.dirty_sg = false;
        }
        return this.popTimesSingle;
    }

    public double[][] getPopTimesPair() {
        if (this.dirty_pp) {
            int n = this.nSpSeqs();
            for (int i = 0; i < n - 1; ++i) {
                int n2 = i * (2 * n - i - 3) / 2 - 1;
                for (int j = i + 1; j < n; ++j) {
                    this.getAllPairCoalPoints(i, j, this.popTimesPair[n2 + j]);
                }
            }
        }
        return this.popTimesPair;
    }

    private void getAllPairCoalPoints(int n, int n2, double[] dArray) {
        block0: for (int i = 0; i < this.geneTreeInfos.length; ++i) {
            for (CoalInfo coalInfo : this.geneTreeInfos[i].getCoalInfo()) {
                if ((!coalInfo.sinfo[0].contains(n) || !coalInfo.sinfo[1].contains(n2)) && (!coalInfo.sinfo[1].contains(n) || !coalInfo.sinfo[0].contains(n2))) continue;
                dArray[i] = coalInfo.ctime;
                continue block0;
            }
        }
        HeapSort.sort(dArray);
    }

    private int allCoalPointsCount(int n) {
        int n2 = 0;
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            if (geneTreeInfo.nLineages(n) <= 0) continue;
            n2 += geneTreeInfo.nLineages(n) - 1;
        }
        return n2;
    }

    void getAllCoalPoints(int n, double[] dArray) {
        int n2 = 0;
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            int n3 = geneTreeInfo.nLineages(n) - 1;
            int n4 = n2;
            for (CoalInfo coalInfo : geneTreeInfo.getCoalInfo()) {
                if (!coalInfo.allHas(n)) continue;
                dArray[n2] = coalInfo.ctime;
                ++n2;
            }
            if (n3 < 0 || n4 + n3 != n2 || n3 < 0 && n4 == n2) {
                System.err.println(n3);
            }
            assert (n3 >= 0 && n4 + n3 == n2 || n3 < 0 && n4 == n2);
        }
        assert (n2 == dArray.length);
        HeapSort.sort(dArray);
    }

    private int allPairCoalPointsCount() {
        return this.geneTreeInfos.length;
    }

    public double speciationUpperBound(FixedBitSet fixedBitSet, FixedBitSet fixedBitSet2) {
        double d = Double.MAX_VALUE;
        block0: for (GeneTreeInfo geneTreeInfo : this.getGeneTrees()) {
            for (CoalInfo coalInfo : geneTreeInfo.getCoalInfo()) {
                if (coalInfo.ctime >= d) continue block0;
                if ((coalInfo.sinfo[0].intersectCardinality(fixedBitSet) <= 0 || coalInfo.sinfo[1].intersectCardinality(fixedBitSet2) <= 0) && (coalInfo.sinfo[0].intersectCardinality(fixedBitSet2) <= 0 || coalInfo.sinfo[1].intersectCardinality(fixedBitSet) <= 0)) continue;
                d = coalInfo.ctime;
                continue block0;
            }
        }
        return d;
    }

    public void makeCompatible(double d) {
        for (GeneTreeInfo geneTreeInfo : this.getGeneTrees()) {
            TreeModel treeModel = geneTreeInfo.tree;
            for (int i = 0; i < treeModel.getExternalNodeCount(); ++i) {
                NodeRef nodeRef = treeModel.getExternalNode(i);
                NodeRef nodeRef2 = treeModel.getParent(nodeRef);
                treeModel.setNodeHeight(nodeRef2, d + treeModel.getNodeHeight(nodeRef2));
            }
            MutableTree.Utils.correctHeightsForTips(treeModel);
            geneTreeInfo.wasChanged();
            geneTreeInfo.getCoalInfo();
            geneTreeInfo.wasBacked = false;
        }
    }

    private int collectCoalInfo(Tree tree, NodeRef nodeRef, GeneTreeInfo.SequenceAssignment[] sequenceAssignmentArray, int n, CoalInfo[] coalInfoArray) {
        coalInfoArray[n] = new CoalInfo(tree.getNodeHeight(nodeRef), tree.getChildCount(nodeRef));
        int n2 = n - 1;
        for (int i = 0; i < 2; ++i) {
            int n3;
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            coalInfoArray[n].sinfo[i] = new FixedBitSet(this.nSpSeqs());
            if (tree.isExternal(nodeRef2)) {
                Taxon taxon = tree.getNodeTaxon(nodeRef2);
                n3 = this.taxon2index.get(taxon);
                int n4 = this.spsq[sequenceAssignmentArray[n3].spIndex][sequenceAssignmentArray[n3].seqIndex];
                coalInfoArray[n].sinfo[i].set(n4);
                assert (tree.getNodeHeight(nodeRef2) == 0.0);
                continue;
            }
            int n5 = this.collectCoalInfo(tree, nodeRef2, sequenceAssignmentArray, n2, coalInfoArray);
            for (n3 = 0; n3 < coalInfoArray[n2].sinfo.length; ++n3) {
                coalInfoArray[n].sinfo[i].union(coalInfoArray[n2].sinfo[n3]);
            }
            n2 = n5;
        }
        return n2;
    }

    public GeneTreeInfo[] getGeneTrees() {
        return this.geneTreeInfos;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.dirty_sg = true;
        this.dirty_pp = true;
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            if (geneTreeInfo.tree != model) continue;
            geneTreeInfo.wasChanged();
            break;
        }
        this.fireModelChanged(object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        assert (false);
    }

    @Override
    protected void storeState() {
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            geneTreeInfo.storeSequenceAssignments();
        }
    }

    @Override
    protected void restoreState() {
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            geneTreeInfo.restoreSequenceAssignments();
        }
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            if (!geneTreeInfo.restore()) continue;
            this.dirty_sg = true;
            this.dirty_pp = true;
        }
    }

    @Override
    protected void acceptState() {
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            geneTreeInfo.accept();
        }
    }

    @Override
    public LogColumn[] getColumns() {
        int n = this.geneTreeInfos.length * this.taxa.length;
        LogColumn[] logColumnArray = new LogColumn[n];
        int n2 = 0;
        for (int i = 0; i < this.geneTreeInfos.length; ++i) {
            int n3 = 0;
            while (n3 < this.taxa.length) {
                GeneTreeInfo.SequenceAssignment sequenceAssignment = this.geneTreeInfos[i].getSeqassigns(n3);
                String string = "Gene" + i + "taxon" + n3;
                logColumnArray[n2] = new LogColumn.Default(string, sequenceAssignment);
                ++n3;
                ++n2;
            }
        }
        return logColumnArray;
    }

    private int[] spseqindex2spandseq(int n) {
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < this.spsq.length; ++i) {
            for (int j = 0; j < this.spsq[i].length; ++j) {
                if (this.spsq[i][j] != n) continue;
                assert (n2 == -1);
                assert (n3 == -1);
                n2 = i;
                n3 = j;
            }
        }
        assert (n2 != -1);
        assert (n3 != -1);
        int[] nArray = new int[]{n2, n3};
        return nArray;
    }

    public class SpeciesLimits
    extends Statistic.Abstract {
        int nDim;
        int[][] c;

        SpeciesLimits() {
            int n;
            super("SpeciationBounds");
            this.nDim = 0;
            int n2 = MulSpeciesBindings.this.nSpSeqs();
            this.c = new int[n2 + 1][n2 + 1];
            for (n = 0; n < n2 + 1; ++n) {
                this.c[n][0] = 1;
                this.c[n][n] = 1;
            }
            for (n = 0; n < n2 + 1; ++n) {
                for (int i = 1; i < n; ++i) {
                    this.c[n][i] = this.c[n - 1][i - 1] + this.c[n - 1][i];
                }
            }
            for (n = 0; n <= n2 / 2; ++n) {
                this.nDim += this.c[n2][n];
            }
        }

        @Override
        public int getDimension() {
            return this.nDim;
        }

        private double boundOnRoot() {
            double d = Double.MAX_VALUE;
            int n = MulSpeciesBindings.this.nSpSeqs();
            block0: for (GeneTreeInfo geneTreeInfo : MulSpeciesBindings.this.getGeneTrees()) {
                for (CoalInfo coalInfo : geneTreeInfo.getCoalInfo()) {
                    if (coalInfo.sinfo[0].cardinality() != n && coalInfo.sinfo[1].cardinality() != n) continue;
                    d = Math.min(d, coalInfo.ctime);
                    continue block0;
                }
            }
            return d;
        }

        @Override
        public double getStatisticValue(int n) {
            int n2;
            int n3;
            if (n == 0) {
                return this.boundOnRoot();
            }
            int n4 = MulSpeciesBindings.this.nSpSeqs();
            int n5 = 0;
            for (n3 = 0; n3 <= n4 / 2 && n >= n5 + (n2 = this.c[n4][n3]); ++n3) {
                n5 += n2;
            }
            n2 = n - n5;
            FixedBitSet fixedBitSet = new FixedBitSet(n4);
            FixedBitSet fixedBitSet2 = new FixedBitSet(n4);
            int n6 = n4;
            for (int i = 0; i < n4; ++i) {
                if (n3 == 0) {
                    fixedBitSet2.set(i);
                    continue;
                }
                if (n2 < this.c[n6 - 1][n3 - 1]) {
                    fixedBitSet.set(i);
                    --n3;
                } else {
                    fixedBitSet2.set(i);
                    n2 -= this.c[n6 - 1][n3];
                }
                --n6;
            }
            return MulSpeciesBindings.this.speciationUpperBound(fixedBitSet, fixedBitSet2);
        }
    }

    public class GeneTreeInfo {
        public final TreeModel tree;
        private SequenceAssignment[] seqassigns;
        private SequenceAssignment[] oldseqassigns;
        private final int[] lineagesCount;
        private CoalInfo[] cList;
        private CoalInfo[] savedcList;
        private boolean dirty;
        private boolean wasBacked;
        private final double popFactor;

        GeneTreeInfo(TreeModel treeModel, double d) {
            int n;
            int n2;
            this.tree = treeModel;
            this.popFactor = d;
            this.seqassigns = new SequenceAssignment[MulSpeciesBindings.this.taxa.length];
            this.oldseqassigns = new SequenceAssignment[MulSpeciesBindings.this.taxa.length];
            for (n2 = 0; n2 < MulSpeciesBindings.this.apspecies.length; ++n2) {
                for (n = 0; n < ((MulSpeciesBindings)MulSpeciesBindings.this).apspecies[n2].individuals.length; ++n) {
                    int n3;
                    int n4 = ((MulSpeciesBindings)MulSpeciesBindings.this).apspecies[n2].individuals[n].taxa.length;
                    int[] nArray = new int[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        nArray[n3] = n3;
                    }
                    MathUtils.permute(nArray);
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n5 = (Integer)MulSpeciesBindings.this.taxon2index.get(((MulSpeciesBindings)MulSpeciesBindings.this).apspecies[n2].individuals[n].taxa[n3]);
                        this.seqassigns[n5] = new SequenceAssignment(n2, nArray[n3]);
                        this.oldseqassigns[n5] = new SequenceAssignment(n2, nArray[n3]);
                    }
                }
            }
            this.lineagesCount = new int[MulSpeciesBindings.this.nSpSeqs()];
            Arrays.fill(this.lineagesCount, 0);
            for (n2 = 0; n2 < this.lineagesCount.length; ++n2) {
                n = MulSpeciesBindings.this.spseqindex2sp(n2);
                for (AlloppSpeciesBindings.Individual individual : ((MulSpeciesBindings)MulSpeciesBindings.this).apspecies[n].individuals) {
                    boolean bl = false;
                    for (Taxon taxon : individual.taxa) {
                        if (treeModel.getTaxonIndex(taxon) < 0) continue;
                        bl = true;
                    }
                    for (Taxon taxon : individual.taxa) {
                        assert (treeModel.getTaxonIndex(taxon) >= 0 == bl);
                    }
                    assert (bl);
                    if (!bl) continue;
                    int n6 = n2;
                    this.lineagesCount[n6] = this.lineagesCount[n6] + 1;
                }
            }
            this.cList = new CoalInfo[treeModel.getExternalNodeCount() - 1];
            this.savedcList = new CoalInfo[this.cList.length];
            this.wasChanged();
            this.getCoalInfo();
            this.wasBacked = false;
        }

        public String seqassignsAsText() {
            String string = "Sequence assignments" + System.getProperty("line.separator");
            for (int i = 0; i < this.seqassigns.length; ++i) {
                string = string + MulSpeciesBindings.this.taxa[i];
                string = string + ":";
                string = string + this.seqassigns[i].seqIndex;
                string = i + 1 < this.seqassigns.length && this.seqassigns[i].spIndex != this.seqassigns[i + 1].spIndex ? string + System.getProperty("line.separator") : string + "  ";
            }
            return string;
        }

        public String genetreeAsText() {
            return this.tree.getNewick();
        }

        public SequenceAssignment getSeqassigns(int n) {
            return this.seqassigns[n];
        }

        public void storeSequenceAssignments() {
            for (int i = 0; i < this.seqassigns.length; ++i) {
                this.oldseqassigns[i].seqIndex = this.seqassigns[i].seqIndex;
            }
        }

        public void restoreSequenceAssignments() {
            for (int i = 0; i < this.seqassigns.length; ++i) {
                this.seqassigns[i].seqIndex = this.oldseqassigns[i].seqIndex;
            }
        }

        public void permuteOneSpeciesOneIndiv() {
            int n = MathUtils.nextInt(MulSpeciesBindings.this.apspecies.length);
            int n2 = MathUtils.nextInt(((MulSpeciesBindings)MulSpeciesBindings.this).apspecies[n].individuals.length);
            this.permuteOneAssignment(n, n2);
        }

        public void permuteSetOfIndivs() {
            int n = this.tree.getInternalNodeCount();
            int n2 = MathUtils.nextInt(n);
            NodeRef nodeRef = this.tree.getInternalNode(n2);
            HashSet<SpeciesIndivPair> hashSet = new HashSet<SpeciesIndivPair>();
            this.collectIndivsOfNode(nodeRef, hashSet);
            for (SpeciesIndivPair speciesIndivPair : hashSet) {
                this.permuteOneAssignment(speciesIndivPair.spIndex, speciesIndivPair.ivIndex);
            }
        }

        int nLineages(int n) {
            return this.lineagesCount[n];
        }

        public CoalInfo[] getCoalInfo() {
            if (this.dirty) {
                this.swap();
                MulSpeciesBindings.this.collectCoalInfo(this.tree, this.tree.getRoot(), this.seqassigns, this.cList.length - 1, this.cList);
                HeapSort.sort(this.cList);
                this.dirty = false;
                this.wasBacked = true;
            }
            return this.cList;
        }

        private void swap() {
            CoalInfo[] coalInfoArray = this.cList;
            this.cList = this.savedcList;
            this.savedcList = coalInfoArray;
        }

        void wasChanged() {
            this.dirty = true;
            this.wasBacked = false;
        }

        boolean restore() {
            if (this.wasBacked) {
                this.swap();
                this.wasBacked = false;
                this.dirty = false;
                return true;
            }
            return false;
        }

        void accept() {
            this.wasBacked = false;
        }

        public double popFactor() {
            return this.popFactor;
        }

        private void collectIndivsOfNode(NodeRef nodeRef, Set<SpeciesIndivPair> set) {
            if (this.tree.isExternal(nodeRef)) {
                SpeciesIndivPair speciesIndivPair = MulSpeciesBindings.this.apspeciesId2speciesindiv(this.tree.getNodeTaxon(nodeRef).getId());
                set.add(speciesIndivPair);
            } else {
                this.collectIndivsOfNode(this.tree.getChild(nodeRef, 0), set);
                this.collectIndivsOfNode(this.tree.getChild(nodeRef, 1), set);
            }
        }

        private void permuteOneAssignment(int n, int n2) {
            if (((MulSpeciesBindings)MulSpeciesBindings.this).apspecies[n].individuals[n2].taxa.length == 2) {
                int n3 = (Integer)MulSpeciesBindings.this.taxon2index.get(((MulSpeciesBindings)MulSpeciesBindings.this).apspecies[n].individuals[n2].taxa[0]);
                this.seqassigns[n3].seqIndex = 1 - this.seqassigns[n3].seqIndex;
                n3 = (Integer)MulSpeciesBindings.this.taxon2index.get(((MulSpeciesBindings)MulSpeciesBindings.this).apspecies[n].individuals[n2].taxa[1]);
                this.seqassigns[n3].seqIndex = 1 - this.seqassigns[n3].seqIndex;
            }
        }

        private class SequenceAssignment {
            public int spIndex;
            public int seqIndex;

            public SequenceAssignment(int n, int n2) {
                this.spIndex = n;
                this.seqIndex = n2;
            }

            public String toString() {
                String string = "" + this.seqIndex;
                return string;
            }
        }
    }

    class CoalInfo
    implements Comparable<CoalInfo> {
        final double ctime;
        final FixedBitSet[] sinfo;

        CoalInfo(double d, int n) {
            this.ctime = d;
            this.sinfo = new FixedBitSet[n];
        }

        @Override
        public int compareTo(CoalInfo coalInfo) {
            return coalInfo.ctime < this.ctime ? 1 : (coalInfo.ctime > this.ctime ? -1 : 0);
        }

        public boolean allHas(int n) {
            for (FixedBitSet fixedBitSet : this.sinfo) {
                if (fixedBitSet.contains(n)) continue;
                return false;
            }
            return true;
        }
    }

    private class SpeciesIndivPair {
        public int spIndex;
        public int ivIndex;

        public SpeciesIndivPair(int n, int n2) {
            this.spIndex = n;
            this.ivIndex = n2;
        }
    }
}

