/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.inference.model.Parameter;
import dr.inference.model.ParameterParser;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class AlloppSpeciesNetworkModelParser
extends AbstractXMLObjectParser {
    public static final String ALLOPPSPECIESNETWORK = "alloppSpeciesNetwork";
    public static final String ONEHYBRIDIZATION = "oneHybridization";
    public static final String DIPLOIDROOT_ISROOT = "diploidRootIsRoot";
    public static final String TIP_POPULATIONS = "tipPopulations";
    public static final String ROOT_POPULATIONS = "rootPopulations";
    public static final String HYBRID_POPULATIONS = "hybridPopulations";

    @Override
    public String getParserName() {
        return ALLOPPSPECIESNETWORK;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        AlloppSpeciesBindings alloppSpeciesBindings = (AlloppSpeciesBindings)xMLObject.getChild(AlloppSpeciesBindings.class);
        boolean bl = xMLObject.getBooleanAttribute(ONEHYBRIDIZATION);
        boolean bl2 = xMLObject.getBooleanAttribute(DIPLOIDROOT_ISROOT);
        XMLObject xMLObject2 = xMLObject.getChild(TIP_POPULATIONS);
        double d = xMLObject2.getAttribute("value", 1.0);
        XMLObject xMLObject3 = xMLObject.getChild(ROOT_POPULATIONS);
        double d2 = xMLObject3.getAttribute("value", 1.0);
        XMLObject xMLObject4 = xMLObject.getChild(HYBRID_POPULATIONS);
        double d3 = xMLObject4.getAttribute("value", 1.0);
        AlloppSpeciesNetworkModel alloppSpeciesNetworkModel = new AlloppSpeciesNetworkModel(alloppSpeciesBindings, d, d2, d3, bl, bl2);
        ParameterParser.replaceParameter(xMLObject2, alloppSpeciesNetworkModel.tippopvalues);
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, alloppSpeciesNetworkModel.tippopvalues.getDimension());
        alloppSpeciesNetworkModel.tippopvalues.addBounds(defaultBounds);
        ParameterParser.replaceParameter(xMLObject3, alloppSpeciesNetworkModel.rootpopvalues);
        Parameter.DefaultBounds defaultBounds2 = new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, alloppSpeciesNetworkModel.rootpopvalues.getDimension());
        alloppSpeciesNetworkModel.rootpopvalues.addBounds(defaultBounds2);
        ParameterParser.replaceParameter(xMLObject4, alloppSpeciesNetworkModel.logginghybpopvalues);
        Parameter.DefaultBounds defaultBounds3 = new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, alloppSpeciesNetworkModel.logginghybpopvalues.getDimension());
        alloppSpeciesNetworkModel.logginghybpopvalues.addBounds(defaultBounds3);
        return alloppSpeciesNetworkModel;
    }

    private ElementRule tippopElementRule() {
        return new ElementRule(TIP_POPULATIONS, new XMLSyntaxRule[]{AttributeRule.newDoubleRule("value", true), new ElementRule(Parameter.class)});
    }

    private ElementRule rootpopElementRule() {
        return new ElementRule(ROOT_POPULATIONS, new XMLSyntaxRule[]{AttributeRule.newDoubleRule("value", true), new ElementRule(Parameter.class)});
    }

    private ElementRule hybpopElementRule() {
        return new ElementRule(HYBRID_POPULATIONS, new XMLSyntaxRule[]{AttributeRule.newDoubleRule("value", true), new ElementRule(Parameter.class)});
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newBooleanRule(ONEHYBRIDIZATION, true), AttributeRule.newBooleanRule(DIPLOIDROOT_ISROOT, true), new ElementRule(AlloppSpeciesBindings.class), this.tippopElementRule(), this.rootpopElementRule(), this.hybpopElementRule()};
    }

    @Override
    public String getParserDescription() {
        return "Species network with population sizes along branches";
    }

    @Override
    public Class getReturnType() {
        return AlloppSpeciesNetworkModel.class;
    }
}

