/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import com.github.javacliparser.StringOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.Range;
import java.util.ArrayList;
import moa.core.InstanceExample;
import moa.streams.filters.AbstractMultiLabelStreamFilter;
import moa.streams.filters.MultiLabelStreamFilter;
import moa.streams.filters.Selection;

public class SelectAttributesFilter
extends AbstractMultiLabelStreamFilter
implements MultiLabelStreamFilter {
    private static final long serialVersionUID = 1L;
    protected InstancesHeader dataset;
    protected Selection inputsSelected;
    protected Selection outputsSelected;
    public StringOption inputStringOption = new StringOption("inputStringOption", 'i', "Selection of attributes to be used as input.", "1");
    public StringOption outputStringOption = new StringOption("outputStringOption", 'o', "Selection of attributes to be used as output.", "-1");

    @Override
    public String getPurposeString() {
        return "Selects input and output attributes.";
    }

    @Override
    public InstancesHeader getHeader() {
        return this.dataset;
    }

    @Override
    public InstanceExample nextInstance() {
        Instance instance = (Instance)this.inputStream.nextInstance().getData();
        if (this.dataset == null) {
            this.initialize(instance);
        }
        return new InstanceExample(this.processInstance(instance));
    }

    private void initialize(Instance instance) {
        int j;
        int i;
        this.inputsSelected = this.getSelection(this.inputStringOption.getValue());
        this.outputsSelected = this.getSelection(this.outputStringOption.getValue());
        int totAttributes = this.inputsSelected.numValues() + this.outputsSelected.numValues();
        Instances ds = new Instances();
        ArrayList<Attribute> v = new ArrayList<Attribute>(totAttributes);
        ArrayList<Integer> indexValues = new ArrayList<Integer>(totAttributes);
        int ct = 0;
        for (i = 0; i < this.inputsSelected.numEntries(); ++i) {
            for (j = this.inputsSelected.getStart(i); j <= this.inputsSelected.getEnd(i); ++j) {
                v.add(instance.attribute(j - 1));
                indexValues.add(ct);
                ++ct;
            }
        }
        for (i = 0; i < this.outputsSelected.numEntries(); ++i) {
            for (j = this.outputsSelected.getStart(i); j <= this.outputsSelected.getEnd(i); ++j) {
                v.add(instance.attribute(j - 1));
                indexValues.add(ct);
                ++ct;
            }
        }
        ds.setAttributes(v, indexValues);
        Range r = new Range("-" + this.outputsSelected.numValues());
        r.setUpper(totAttributes);
        ds.setRangeOutputIndices(r);
        this.dataset = new InstancesHeader(ds);
    }

    private Selection getSelection(String text) {
        String[] parts;
        Selection s = new Selection();
        for (String p : parts = text.trim().split(",")) {
            int index = p.indexOf(45);
            if (index == -1) {
                s.add(Integer.parseInt(p));
                continue;
            }
            String[] vals = p.split("-");
            s.add(Integer.parseInt(vals[0]), Integer.parseInt(vals[1]));
        }
        return s;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void restartImpl() {
    }

    private Instance processInstance(Instance instance) {
        int j;
        int end;
        int start;
        int i;
        double[] attValues = new double[this.dataset.numAttributes()];
        InstanceImpl newInstance = new InstanceImpl(instance.weight(), attValues);
        int count = 0;
        for (i = 0; i < this.inputsSelected.numEntries(); ++i) {
            start = this.inputsSelected.getStart(i) - 1;
            end = this.inputsSelected.getEnd(i) - 1;
            for (j = start; j <= end; ++j) {
                newInstance.setValue(count, instance.value(j));
                ++count;
            }
        }
        for (i = 0; i < this.outputsSelected.numEntries(); ++i) {
            start = this.outputsSelected.getStart(i) - 1;
            end = this.outputsSelected.getEnd(i) - 1;
            for (j = start; j <= end; ++j) {
                newInstance.setValue(count, instance.value(j));
                ++count;
            }
        }
        newInstance.setDataset(this.dataset);
        return newInstance;
    }
}

