/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.AnyOut.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import moa.clusterers.outliers.AnyOut.util.DataObject;

public class DataSet
implements Iterable<DataObject> {
    private int nrOfDimensions;
    private ArrayList<DataObject> dataList;

    public DataSet(int nrOfDimensions) {
        if (nrOfDimensions <= 0) {
            System.err.println("Negative dimension given: " + nrOfDimensions);
        } else {
            this.nrOfDimensions = nrOfDimensions;
            this.dataList = new ArrayList();
        }
    }

    public DataSet(DataObject newData) {
        this.nrOfDimensions = newData.getNrOfDimensions();
        this.dataList = new ArrayList();
        this.dataList.add(newData);
    }

    public void addObject(DataObject newData) {
        if (newData.getNrOfDimensions() != this.nrOfDimensions) {
            System.err.println("Inconsistent number of dimensions!");
        } else {
            this.dataList.add(newData);
        }
    }

    public void addObject(DataSet dataSet) throws Exception {
        DataObject[] dataObjects = dataSet.getDataObjectArray();
        for (int i = 0; i < dataObjects.length; ++i) {
            this.addObject(dataObjects[i]);
        }
    }

    public DataObject getObject(int index) {
        return this.dataList.get(index);
    }

    public int size() {
        return this.dataList.size();
    }

    public int getNrOfDimensions() {
        return this.nrOfDimensions;
    }

    public int getNrOfClasses() {
        HashMap<Integer, Integer> classes = new HashMap<Integer, Integer>();
        for (DataObject currentObject : this.dataList) {
            if (classes.containsKey(currentObject.getClassLabel())) continue;
            classes.put(currentObject.getClassLabel(), 1);
        }
        return classes.size();
    }

    public double[][] getFeaturesAsArray() {
        double[][] data = new double[this.size()][this.nrOfDimensions];
        int c = 0;
        for (DataObject d : this.dataList) {
            data[c] = d.getFeatures();
            ++c;
        }
        return data;
    }

    public DataObject[] getDataObjectArray() {
        DataObject[] res = new DataObject[this.dataList.size()];
        return this.dataList.toArray(res);
    }

    public DataSet[] getDataSetsPerClass() throws Exception {
        DataSet[] dataSetsPerClass = new DataSet[this.getNrOfClasses()];
        for (int i = 0; i < dataSetsPerClass.length; ++i) {
            dataSetsPerClass[i] = new DataSet(this.nrOfDimensions);
        }
        for (DataObject currentObject : this.dataList) {
            dataSetsPerClass[currentObject.getClassLabel()].addObject(currentObject);
        }
        return dataSetsPerClass;
    }

    public double[] getVariances() {
        double N = this.size();
        double[] LS = new double[this.getNrOfDimensions()];
        double[] SS = new double[this.getNrOfDimensions()];
        double[] variances = new double[this.getNrOfDimensions()];
        for (DataObject dataObject : this.dataList) {
            double[] tmpFeatures = dataObject.getFeatures();
            for (int j = 0; j < tmpFeatures.length; ++j) {
                int n = j;
                LS[n] = LS[n] + tmpFeatures[j];
                int n2 = j;
                SS[n2] = SS[n2] + tmpFeatures[j] * tmpFeatures[j];
            }
        }
        for (int i = 0; i < LS.length; ++i) {
            variances[i] = SS[i] / N - LS[i] / N * (LS[i] / N);
        }
        return variances;
    }

    @Override
    public Iterator<DataObject> iterator() {
        return this.dataList.iterator();
    }

    public String toString() {
        String res = "";
        for (DataObject dataObject : this.dataList) {
            res = res + dataObject.toString() + "\n";
        }
        return res;
    }

    public void manipulateIds() {
        int id = 0;
        for (DataObject o : this.dataList) {
            o.setId(id);
            ++id;
        }
    }

    public void clear() {
        this.dataList.clear();
    }
}

