/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees.iadem;

import java.util.ArrayList;
import java.util.Arrays;
import moa.classifiers.core.attributeclassobservers.GreenwaldKhannaNumericAttributeClassObserver;
import moa.classifiers.trees.iadem.IademCommonProcedures;
import moa.classifiers.trees.iadem.IademGreenwaldKhannaQuantileSummary;
import moa.classifiers.trees.iadem.IademNumericAttributeObserver;
import moa.core.AutoExpandVector;
import moa.core.GreenwaldKhannaQuantileSummary;
import weka.core.Utils;

public class IademGreenwaldKhannaNumericAttributeClassObserver
extends GreenwaldKhannaNumericAttributeClassObserver
implements IademNumericAttributeObserver {
    private static final long serialVersionUID = 1L;

    public IademGreenwaldKhannaNumericAttributeClassObserver() {
    }

    public IademGreenwaldKhannaNumericAttributeClassObserver(int maxTuples) {
        this.numTuplesOption.setValue(maxTuples);
    }

    @Override
    public void observeAttributeClass(double attVal, int classVal, double weight) {
        if (!Utils.isMissingValue((double)attVal)) {
            IademGreenwaldKhannaQuantileSummary valDist = (IademGreenwaldKhannaQuantileSummary)this.attValDistPerClass.get(classVal);
            if (valDist == null) {
                valDist = new IademGreenwaldKhannaQuantileSummary(this.numTuplesOption.getValue());
                this.attValDistPerClass.set(classVal, valDist);
            }
            valDist.insert(attVal);
        }
    }

    @Override
    public double probabilityOfAttributeValueGivenClass(double attVal, int classVal) {
        IademGreenwaldKhannaQuantileSummary obs = (IademGreenwaldKhannaQuantileSummary)this.attValDistPerClass.get(classVal);
        if (obs == null) {
            return 0.0;
        }
        int index = obs.findIndexOfTupleGreaterThan(attVal);
        double total = obs.getTotalCount();
        double partial = obs.maxNumberOfObservation(index);
        return total != 0.0 ? partial / total : 0.0;
    }

    @Override
    public long getMaxOfValues() {
        return this.numTuplesOption.getValue();
    }

    @Override
    public void addValue(double attValue, int classValue, double weight) {
        this.observeAttributeClass(attValue, classValue, weight);
    }

    @Override
    public long getValueCount() {
        int totalCount = 0;
        for (GreenwaldKhannaQuantileSummary qs : this.attValDistPerClass) {
            if (qs == null) continue;
            totalCount = (int)((long)totalCount + qs.getTotalCount());
        }
        return totalCount;
    }

    @Override
    public long[] getClassDist() {
        long[] classDist = new long[this.attValDistPerClass.size()];
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            GreenwaldKhannaQuantileSummary qs = (GreenwaldKhannaQuantileSummary)this.attValDistPerClass.get(i);
            classDist[i] = qs != null ? qs.getTotalCount() : 0L;
        }
        return classDist;
    }

    @Override
    public long getNumberOfCutPoints() {
        int numberOfCutPoints = 0;
        for (GreenwaldKhannaQuantileSummary qs : this.attValDistPerClass) {
            if (qs == null) continue;
            numberOfCutPoints += qs.getSuggestedCutpoints().length;
        }
        return numberOfCutPoints;
    }

    @Override
    public long[] getLeftClassDist(double cut) {
        long[] lhsDist = new long[this.attValDistPerClass.size()];
        Arrays.fill(lhsDist, 0L);
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            GreenwaldKhannaQuantileSummary estimator = (GreenwaldKhannaQuantileSummary)this.attValDistPerClass.get(i);
            if (estimator == null) continue;
            long countBelow = estimator.getCountBelow(cut);
            int n = i;
            lhsDist[n] = lhsDist[n] + countBelow;
        }
        return lhsDist;
    }

    @Override
    public double getCut(int cutIndex) {
        int currentCut = cutIndex;
        for (GreenwaldKhannaQuantileSummary qs : this.attValDistPerClass) {
            if (qs == null) continue;
            double[] cuts = qs.getSuggestedCutpoints();
            if (currentCut < cuts.length) {
                return cuts[currentCut];
            }
            currentCut -= cuts.length;
        }
        return Double.NaN;
    }

    @Override
    public void computeClassDistProbabilities(double[][][] cut_value_classDist_lower, double[][][] cut_value_classDist_upper, double[][] counts_cut_value, boolean withIntervalEstimates) {
        ArrayList<Double> cuts = this.cutPointSuggestion(-1);
        long[] totalDist = this.getClassDist();
        for (int i = 0; i < cuts.size(); ++i) {
            long[] lDist = this.getLeftClassDist(cuts.get(i));
            long[] rDist = new long[lDist.length];
            long totalIzq = this.sum(lDist);
            long total = this.sum(totalDist);
            counts_cut_value[i][0] = totalIzq;
            counts_cut_value[i][1] = total - totalIzq;
            for (int j = 0; j < totalDist.length; ++j) {
                rDist[j] = totalDist[j] - lDist[j];
                double lEst = 0.0;
                if (counts_cut_value[i][0] != 0.0) {
                    lEst = (double)lDist[j] / counts_cut_value[i][0];
                }
                double lError = 0.0;
                if (withIntervalEstimates) {
                    lError = IademCommonProcedures.getIADEM_HoeffdingBound(lEst, counts_cut_value[i][0]);
                }
                cut_value_classDist_lower[i][0][j] = Math.max(0.0, lEst - lError);
                cut_value_classDist_upper[i][0][j] = Math.min(1.0, lEst + lError);
                double rEst = 0.0;
                if (counts_cut_value[i][1] != 0.0) {
                    rEst = (double)rDist[j] / counts_cut_value[i][1];
                }
                double rightError = 0.0;
                if (withIntervalEstimates) {
                    rightError = IademCommonProcedures.getIADEM_HoeffdingBound(rEst, counts_cut_value[i][1]);
                }
                cut_value_classDist_lower[i][1][j] = Math.max(0.0, rEst - rightError);
                cut_value_classDist_upper[i][1][j] = Math.min(1.0, rEst + rightError);
            }
        }
    }

    protected long sum(long[] arr) {
        long counter = 0L;
        for (int i = 0; i < arr.length; ++i) {
            counter += arr[i];
        }
        return counter;
    }

    @Override
    public ArrayList<Double> cutPointSuggestion(int numCortes) {
        ArrayList<Double> cuts = new ArrayList<Double>();
        for (GreenwaldKhannaQuantileSummary qs : this.attValDistPerClass) {
            double[] newCuts;
            if (qs == null) continue;
            for (double valor : newCuts = qs.getSuggestedCutpoints()) {
                cuts.add(valor);
            }
        }
        return cuts;
    }

    @Override
    public ArrayList<Double[]> computeConditionalProbPerBin(ArrayList<Double> cuts) {
        ArrayList<Double[]> prob = new ArrayList<Double[]>();
        long total = this.getValueCount();
        for (Double currentCut : cuts) {
            long[] numExp = this.getLeftClassDist(currentCut);
            Double[] tmpProb = new Double[numExp.length];
            for (int j = 0; j < tmpProb.length; ++j) {
                tmpProb[j] = (double)numExp[j] / (double)total;
            }
            prob.add(tmpProb);
        }
        return prob;
    }

    @Override
    public double[] computeConditionalProb(ArrayList<Double> cortes, double valor) {
        double[] probabilidadCondicional = new double[this.attValDistPerClass.size()];
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            probabilidadCondicional[i] = this.probabilityOfAttributeValueGivenClass(valor, i);
        }
        return probabilidadCondicional;
    }

    @Override
    public IademNumericAttributeObserver getCopy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void reset() {
        this.attValDistPerClass = new AutoExpandVector();
    }

    @Override
    public void setMaxBins(int numTuples) {
        this.numTuplesOption.setValue(numTuples);
    }

    @Override
    public void computeClassDist(double[][][] cutClassDist) {
        ArrayList<Double> cuts = this.cutPointSuggestion(-1);
        long[] totalDist = this.getClassDist();
        for (int i = 0; i < cuts.size(); ++i) {
            long[] lDist = this.getLeftClassDist(cuts.get(i));
            long[] rDist = new long[lDist.length];
            for (int j = 0; j < totalDist.length; ++j) {
                rDist[j] = totalDist[j] - lDist[j];
                cutClassDist[i][0][j] = lDist[j];
                cutClassDist[i][1][j] = rDist[j];
            }
        }
    }
}

