/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;

public class CoordinateArrays {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    private CoordinateArrays() {
    }

    public static int dimension(Coordinate[] pts) {
        if (pts == null || pts.length == 0) {
            return 3;
        }
        int dimension = 0;
        for (Coordinate coordinate : pts) {
            dimension = Math.max(dimension, Coordinates.dimension(coordinate));
        }
        return dimension;
    }

    public static int measures(Coordinate[] pts) {
        if (pts == null || pts.length == 0) {
            return 0;
        }
        int measures = 0;
        for (Coordinate coordinate : pts) {
            measures = Math.max(measures, Coordinates.measures(coordinate));
        }
        return measures;
    }

    public static void enforceConsistency(Coordinate[] array) {
        if (array == null) {
            return;
        }
        int maxDimension = -1;
        int maxMeasures = -1;
        boolean isConsistent = true;
        for (int i = 0; i < array.length; ++i) {
            Coordinate coordinate = array[i];
            if (coordinate == null) continue;
            int d2 = Coordinates.dimension(coordinate);
            int m3 = Coordinates.measures(coordinate);
            if (maxDimension == -1) {
                maxDimension = d2;
                maxMeasures = m3;
                continue;
            }
            if (d2 == maxDimension && m3 == maxMeasures) continue;
            isConsistent = false;
            maxDimension = Math.max(maxDimension, d2);
            maxMeasures = Math.max(maxMeasures, m3);
        }
        if (!isConsistent) {
            Coordinate sample = Coordinates.create(maxDimension, maxMeasures);
            Class<?> type = sample.getClass();
            for (int i = 0; i < array.length; ++i) {
                Coordinate coordinate = array[i];
                if (coordinate == null || coordinate.getClass().equals(type)) continue;
                Coordinate duplicate = Coordinates.create(maxDimension, maxMeasures);
                duplicate.setCoordinate(coordinate);
                array[i] = duplicate;
            }
        }
    }

    public static Coordinate[] enforceConsistency(Coordinate[] array, int dimension, int measures) {
        Coordinate sample = Coordinates.create(dimension, measures);
        Class<?> type = sample.getClass();
        boolean isConsistent = true;
        for (int i = 0; i < array.length; ++i) {
            Coordinate coordinate = array[i];
            if (coordinate == null || coordinate.getClass().equals(type)) continue;
            isConsistent = false;
            break;
        }
        if (isConsistent) {
            return array;
        }
        Class<?> coordinateType = sample.getClass();
        Coordinate[] copy = (Coordinate[])Array.newInstance(coordinateType, array.length);
        for (int i = 0; i < copy.length; ++i) {
            Coordinate coordinate = array[i];
            if (coordinate != null && !coordinate.getClass().equals(type)) {
                Coordinate duplicate = Coordinates.create(dimension, measures);
                duplicate.setCoordinate(coordinate);
                copy[i] = duplicate;
                continue;
            }
            copy[i] = coordinate;
        }
        return copy;
    }

    public static boolean isRing(Coordinate[] pts) {
        if (pts.length < 4) {
            return false;
        }
        return pts[0].equals2D(pts[pts.length - 1]);
    }

    public static Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        for (int i = 0; i < testPts.length; ++i) {
            Coordinate testPt = testPts[i];
            if (CoordinateArrays.indexOf(testPt, pts) >= 0) continue;
            return testPt;
        }
        return null;
    }

    public static int compare(Coordinate[] pts1, Coordinate[] pts2) {
        int i;
        for (i = 0; i < pts1.length && i < pts2.length; ++i) {
            int compare = pts1[i].compareTo(pts2[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (i < pts2.length) {
            return -1;
        }
        if (i < pts1.length) {
            return 1;
        }
        return 0;
    }

    public static int increasingDirection(Coordinate[] pts) {
        for (int i = 0; i < pts.length / 2; ++i) {
            int j = pts.length - 1 - i;
            int comp = pts[i].compareTo(pts[j]);
            if (comp == 0) continue;
            return comp;
        }
        return 1;
    }

    private static boolean isEqualReversed(Coordinate[] pts1, Coordinate[] pts2) {
        for (int i = 0; i < pts1.length; ++i) {
            Coordinate p1 = pts1[i];
            Coordinate p2 = pts2[pts1.length - i - 1];
            if (p1.compareTo(p2) == 0) continue;
            return false;
        }
        return true;
    }

    public static Coordinate[] copyDeep(Coordinate[] coordinates) {
        Coordinate[] copy = new Coordinate[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            copy[i] = coordinates[i].copy();
        }
        return copy;
    }

    public static void copyDeep(Coordinate[] src, int srcStart, Coordinate[] dest, int destStart, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destStart + i] = src[srcStart + i].copy();
        }
    }

    public static Coordinate[] toCoordinateArray(Collection coordList) {
        return coordList.toArray(coordArrayType);
    }

    public static boolean hasRepeatedPoints(Coordinate[] coord) {
        for (int i = 1; i < coord.length; ++i) {
            if (!coord[i - 1].equals(coord[i])) continue;
            return true;
        }
        return false;
    }

    public static Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] c2) {
        return c2.length >= n ? c2 : new Coordinate[]{};
    }

    public static Coordinate[] removeRepeatedPoints(Coordinate[] coord) {
        if (!CoordinateArrays.hasRepeatedPoints(coord)) {
            return coord;
        }
        CoordinateList coordList = new CoordinateList(coord, false);
        return coordList.toCoordinateArray();
    }

    public static Coordinate[] removeNull(Coordinate[] coord) {
        int nonNull = 0;
        for (int i = 0; i < coord.length; ++i) {
            if (coord[i] == null) continue;
            ++nonNull;
        }
        Coordinate[] newCoord = new Coordinate[nonNull];
        if (nonNull == 0) {
            return newCoord;
        }
        int j = 0;
        for (int i = 0; i < coord.length; ++i) {
            if (coord[i] == null) continue;
            newCoord[j++] = coord[i];
        }
        return newCoord;
    }

    public static void reverse(Coordinate[] coord) {
        int last = coord.length - 1;
        int mid = last / 2;
        for (int i = 0; i <= mid; ++i) {
            Coordinate tmp = coord[i];
            coord[i] = coord[last - i];
            coord[last - i] = tmp;
        }
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i = 0; i < coord1.length; ++i) {
            if (coord1[i].equals(coord2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2, Comparator coordinateComparator) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i = 0; i < coord1.length; ++i) {
            if (coordinateComparator.compare(coord1[i], coord2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public static Coordinate minCoordinate(Coordinate[] coordinates) {
        Coordinate minCoord = null;
        for (int i = 0; i < coordinates.length; ++i) {
            if (minCoord != null && minCoord.compareTo(coordinates[i]) <= 0) continue;
            minCoord = coordinates[i];
        }
        return minCoord;
    }

    public static void scroll(Coordinate[] coordinates, Coordinate firstCoordinate) {
        int i = CoordinateArrays.indexOf(firstCoordinate, coordinates);
        CoordinateArrays.scroll(coordinates, i);
    }

    public static void scroll(Coordinate[] coordinates, int indexOfFirstCoordinate) {
        CoordinateArrays.scroll(coordinates, indexOfFirstCoordinate, CoordinateArrays.isRing(coordinates));
    }

    public static void scroll(Coordinate[] coordinates, int indexOfFirstCoordinate, boolean ensureRing) {
        int i = indexOfFirstCoordinate;
        if (i <= 0) {
            return;
        }
        Coordinate[] newCoordinates = new Coordinate[coordinates.length];
        if (!ensureRing) {
            System.arraycopy(coordinates, i, newCoordinates, 0, coordinates.length - i);
            System.arraycopy(coordinates, 0, newCoordinates, coordinates.length - i, i);
        } else {
            int last = coordinates.length - 1;
            for (int j = 0; j < last; ++j) {
                newCoordinates[j] = coordinates[(i + j) % last];
            }
            newCoordinates[j] = newCoordinates[0].copy();
        }
        System.arraycopy(newCoordinates, 0, coordinates, 0, coordinates.length);
    }

    public static int indexOf(Coordinate coordinate, Coordinate[] coordinates) {
        for (int i = 0; i < coordinates.length; ++i) {
            if (!coordinate.equals(coordinates[i])) continue;
            return i;
        }
        return -1;
    }

    public static Coordinate[] extract(Coordinate[] pts, int start, int end) {
        start = MathUtil.clamp(start, 0, pts.length);
        end = MathUtil.clamp(end, -1, pts.length);
        int npts = end - start + 1;
        if (end < 0) {
            npts = 0;
        }
        if (start >= pts.length) {
            npts = 0;
        }
        if (end < start) {
            npts = 0;
        }
        Coordinate[] extractPts = new Coordinate[npts];
        if (npts == 0) {
            return extractPts;
        }
        int iPts = 0;
        for (int i = start; i <= end; ++i) {
            extractPts[iPts++] = pts[i];
        }
        return extractPts;
    }

    public static Envelope envelope(Coordinate[] coordinates) {
        Envelope env = new Envelope();
        for (int i = 0; i < coordinates.length; ++i) {
            env.expandToInclude(coordinates[i]);
        }
        return env;
    }

    public static Coordinate[] intersection(Coordinate[] coordinates, Envelope env) {
        CoordinateList coordList = new CoordinateList();
        for (int i = 0; i < coordinates.length; ++i) {
            if (!env.intersects(coordinates[i])) continue;
            coordList.add(coordinates[i], true);
        }
        return coordList.toCoordinateArray();
    }

    public static class BidirectionalComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int forwardComp = CoordinateArrays.compare(pts1, pts2);
            boolean isEqualRev = CoordinateArrays.isEqualReversed(pts1, pts2);
            if (isEqualRev) {
                return 0;
            }
            return forwardComp;
        }

        public int OLDcompare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int dir1 = CoordinateArrays.increasingDirection(pts1);
            int dir2 = CoordinateArrays.increasingDirection(pts2);
            int i1 = dir1 > 0 ? 0 : pts1.length - 1;
            int i2 = dir2 > 0 ? 0 : pts1.length - 1;
            for (int i = 0; i < pts1.length; ++i) {
                int comparePt = pts1[i1].compareTo(pts2[i2]);
                if (comparePt != 0) {
                    return comparePt;
                }
                i1 += dir1;
                i2 += dir2;
            }
            return 0;
        }
    }

    public static class ForwardComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            return CoordinateArrays.compare(pts1, pts2);
        }
    }
}

