/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.knowm.xchart.OHLCSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.lines.SeriesLines;

public class PlotContent_OHLC<ST extends AxesChartStyler, S extends OHLCSeries>
extends PlotContent_<ST, S> {
    private final ST ohlcStyler;

    PlotContent_OHLC(Chart<ST, S> chart) {
        super(chart);
        this.ohlcStyler = (AxesChartStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g2) {
        double xTickSpace = ((Styler)this.ohlcStyler).getPlotContentSize() * this.getBounds().getWidth();
        double xLeftMargin = Utils.getTickStartOffset((int)this.getBounds().getWidth(), xTickSpace);
        double yTickSpace = ((Styler)this.ohlcStyler).getPlotContentSize() * this.getBounds().getHeight();
        double yTopMargin = Utils.getTickStartOffset((int)this.getBounds().getHeight(), yTickSpace);
        double xMin = this.chart.getXAxis().getMin();
        double xMax = this.chart.getXAxis().getMax();
        Line2D.Double line = new Line2D.Double();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        if (((AxesChartStyler)this.ohlcStyler).isXAxisLogarithmic()) {
            xMin = Math.log10(xMin);
            xMax = Math.log10(xMax);
        }
        Map map = this.chart.getSeriesMap();
        for (OHLCSeries series : map.values()) {
            double[] xData;
            if (!series.isEnabled()) continue;
            double yMin = this.chart.getYAxis(series.getYAxisGroup()).getMin();
            double yMax = this.chart.getYAxis(series.getYAxisGroup()).getMax();
            if (((AxesChartStyler)this.ohlcStyler).isYAxisLogarithmic()) {
                yMin = Math.log10(yMin);
                yMax = Math.log10(yMax);
            }
            if (series.getOhlcSeriesRenderStyle() == OHLCSeries.OHLCSeriesRenderStyle.Line) {
                xData = series.getXData();
                double[] yData = series.getYData();
                double previousX = -1.7976931348623157E308;
                double previousY = -1.7976931348623157E308;
                for (int i = 0; i < xData.length; ++i) {
                    double next;
                    double x = xData[i];
                    if (((AxesChartStyler)this.ohlcStyler).isXAxisLogarithmic()) {
                        x = Math.log10(x);
                    }
                    if (Double.isNaN(next = yData[i])) {
                        previousX = -1.7976931348623157E308;
                        previousY = -1.7976931348623157E308;
                        continue;
                    }
                    double yOrig = yData[i];
                    double y = ((AxesChartStyler)this.ohlcStyler).isYAxisLogarithmic() ? Math.log10(yOrig) : yOrig;
                    double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                    double yTransform = this.getBounds().getHeight() - (yTopMargin + (y - yMin) / (yMax - yMin) * yTickSpace);
                    if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                        xTransform = this.getBounds().getWidth() / 2.0;
                    }
                    if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                        yTransform = this.getBounds().getHeight() / 2.0;
                    }
                    double xOffset = this.getBounds().getX() + xTransform;
                    double yOffset = this.getBounds().getY() + yTransform;
                    if (previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                        g2.setColor(series.getLineColor());
                        g2.setStroke(series.getLineStyle());
                        line.setLine(previousX, previousY, xOffset, yOffset);
                        g2.draw(line);
                    }
                    previousX = xOffset;
                    previousY = yOffset;
                    if (series.getMarker() != null) {
                        g2.setColor(series.getMarkerColor());
                        series.getMarker().paint(g2, xOffset, yOffset, ((Styler)this.ohlcStyler).getMarkerSize());
                    }
                    if (!((AxesChartStyler)this.chart.getStyler()).isToolTipsEnabled()) continue;
                    this.toolTips.addData(xOffset, yOffset, this.chart.getXAxisFormat().format(x), this.chart.getYAxisFormat(series.getYAxisDecimalPattern()).format(yOrig));
                }
                continue;
            }
            xData = series.getXData();
            double[] openData = series.getOpenData();
            double[] highData = series.getHighData();
            double[] lowData = series.getLowData();
            double[] closeData = series.getCloseData();
            double candleHalfWidth = Math.max(3.0, xTickSpace / (double)xData.length / 2.0 - (double)((AxesChartStyler)this.ohlcStyler).getAxisTickPadding());
            float lineWidth = Math.max(2.0f, series.getLineStyle().getLineWidth());
            for (int i = 0; i < xData.length; ++i) {
                double closeY;
                double lowY;
                double highY;
                double openY;
                double x = xData[i];
                if (((AxesChartStyler)this.ohlcStyler).isXAxisLogarithmic()) {
                    x = Math.log10(x);
                }
                if (Double.isNaN(closeData[i])) continue;
                double openOrig = openData[i];
                double highOrig = highData[i];
                double lowOrig = lowData[i];
                double closeOrig = closeData[i];
                if (((AxesChartStyler)this.ohlcStyler).isYAxisLogarithmic()) {
                    openY = Math.log10(openOrig);
                    highY = Math.log10(highOrig);
                    lowY = Math.log10(lowOrig);
                    closeY = Math.log10(closeOrig);
                } else {
                    openY = openOrig;
                    highY = highOrig;
                    lowY = lowOrig;
                    closeY = closeOrig;
                }
                double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                double openTransform = this.getBounds().getHeight() - (yTopMargin + (openY - yMin) / (yMax - yMin) * yTickSpace);
                double highTransform = this.getBounds().getHeight() - (yTopMargin + (highY - yMin) / (yMax - yMin) * yTickSpace);
                double lowTransform = this.getBounds().getHeight() - (yTopMargin + (lowY - yMin) / (yMax - yMin) * yTickSpace);
                double closeTransform = this.getBounds().getHeight() - (yTopMargin + (closeY - yMin) / (yMax - yMin) * yTickSpace);
                if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                    xTransform = this.getBounds().getWidth() / 2.0;
                }
                if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                    openTransform = this.getBounds().getHeight() / 2.0;
                    highTransform = this.getBounds().getHeight() / 2.0;
                    lowTransform = this.getBounds().getHeight() / 2.0;
                    closeTransform = this.getBounds().getHeight() / 2.0;
                }
                double xOffset = this.getBounds().getX() + xTransform;
                double openOffset = this.getBounds().getY() + openTransform;
                double highOffset = this.getBounds().getY() + highTransform;
                double lowOffset = this.getBounds().getY() + lowTransform;
                double closeOffset = this.getBounds().getY() + closeTransform;
                Area toolTipArea = null;
                if (series.getLineStyle() != SeriesLines.NONE && xOffset != -1.7976931348623157E308 && openOffset != -1.7976931348623157E308 && highOffset != -1.7976931348623157E308 && lowOffset != -1.7976931348623157E308 && closeOffset != -1.7976931348623157E308) {
                    if (series.getLineColor() != null) {
                        g2.setColor(series.getLineColor());
                    } else if (closeOrig > openOrig) {
                        g2.setColor(series.getUpColor());
                    } else {
                        g2.setColor(series.getDownColor());
                    }
                    g2.setStroke(series.getLineStyle());
                    line.setLine(xOffset, highOffset, xOffset, lowOffset);
                    g2.draw(line);
                    double xStart = xOffset - candleHalfWidth;
                    double xEnd = xOffset + candleHalfWidth;
                    if (((AxesChartStyler)this.chart.getStyler()).isToolTipsEnabled()) {
                        rect.setRect(xOffset - (double)(lineWidth / 2.0f), highOffset, lineWidth, lowOffset - highOffset);
                        toolTipArea = new Area(rect);
                    }
                    if (series.getOhlcSeriesRenderStyle() == OHLCSeries.OHLCSeriesRenderStyle.Candle) {
                        if (closeOrig > openOrig) {
                            g2.setPaint(series.getUpColor());
                        } else {
                            g2.setPaint(series.getDownColor());
                        }
                        rect.setRect(xStart, Math.min(openOffset, closeOffset), xEnd - xStart, Math.abs(closeOffset - openOffset));
                        g2.fill(rect);
                        if (((AxesChartStyler)this.chart.getStyler()).isToolTipsEnabled()) {
                            toolTipArea.add(new Area(rect));
                        }
                    } else {
                        line.setLine(xStart, openOffset, xOffset, openOffset);
                        g2.draw(line);
                        line.setLine(xOffset, closeOffset, xEnd, closeOffset);
                        g2.draw(line);
                        if (((AxesChartStyler)this.chart.getStyler()).isToolTipsEnabled()) {
                            rect.setRect(xStart, openOffset - (double)(lineWidth / 2.0f), xOffset - xStart, lineWidth);
                            toolTipArea.add(new Area(rect));
                            rect.setRect(xOffset, closeOffset - (double)(lineWidth / 2.0f), xEnd - xOffset, lineWidth);
                            toolTipArea.add(new Area(rect));
                        }
                    }
                }
                if (!((AxesChartStyler)this.chart.getStyler()).isToolTipsEnabled()) continue;
                StringBuilder sb = new StringBuilder();
                if (series.getVolumeData() != null) {
                    sb.append(this.chart.getXAxisFormat().format(x));
                    sb.append(System.lineSeparator()).append("Volume: " + series.getVolumeData()[i]);
                    sb.append(System.lineSeparator()).append(" ").append(System.lineSeparator());
                }
                sb.append(this.chart.getXAxisFormat().format(x));
                sb.append(System.lineSeparator()).append(series.getName()).append(":");
                sb.append(System.lineSeparator()).append("open: ").append(this.chart.getYAxisFormat().format(openOrig));
                sb.append(System.lineSeparator()).append("close: ").append(this.chart.getYAxisFormat().format(closeOrig));
                sb.append(System.lineSeparator()).append("low: ").append(this.chart.getYAxisFormat().format(lowOrig));
                sb.append(System.lineSeparator()).append("high: ").append(this.chart.getYAxisFormat().format(highOrig));
                this.toolTips.addData(toolTipArea, xOffset, highOffset, 0.0, sb.toString());
            }
        }
    }

    private void paintLine(Graphics2D g2, S series) {
    }
}

