/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.gridshift;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.factory.gridshift.NADConGridShift;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.URLs;
import org.geotools.util.factory.BufferedFactory;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;

public class NADCONGridShiftFactory
extends ReferencingFactory
implements BufferedFactory {
    private static final int GRID_CACHE_HARD_REFERENCES = 10;
    protected static final Logger LOGGER = Logging.getLogger(NADCONGridShiftFactory.class);
    private SoftValueHashMap<NADCONKey, NADConGridShift> gridCache = new SoftValueHashMap(10);

    public NADConGridShift loadGridShift(URL latGridURL, URL longGridURL) throws FactoryException {
        NADCONKey key = new NADCONKey(latGridURL.toExternalForm(), longGridURL.toExternalForm());
        SoftValueHashMap<NADCONKey, NADConGridShift> softValueHashMap = this.gridCache;
        synchronized (softValueHashMap) {
            NADConGridShift grid = this.gridCache.get(key);
            if (grid != null) {
                return grid;
            }
            grid = this.loadGridShiftInternal(latGridURL, longGridURL);
            if (grid != null) {
                this.gridCache.put(key, grid);
                return grid;
            }
            throw new FactoryException("NTv2 Grid " + latGridURL + ", " + longGridURL + " could not be created.");
        }
    }

    private NADConGridShift loadGridShiftInternal(URL latGridURL, URL longGridURL) throws FactoryException {
        String latGridName = URLs.urlToFile(latGridURL).getPath();
        String longGridName = URLs.urlToFile(longGridURL).getPath();
        try {
            if (latGridName.endsWith(".las") && longGridName.endsWith(".los") || latGridName.endsWith(".LAS") && longGridName.endsWith(".LOS")) {
                return this.loadBinaryGrid(latGridURL, longGridURL);
            }
            if (latGridName.endsWith(".laa") && longGridName.endsWith(".loa") || latGridName.endsWith(".LAA") && longGridName.endsWith(".LOA")) {
                return this.loadTextGrid(latGridURL, longGridURL);
            }
            throw new FactoryException(Errors.format(200, latGridName.substring(latGridName.lastIndexOf(46) + 1), longGridName.substring(longGridName.lastIndexOf(46) + 1)));
        }
        catch (IOException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception.getLocalizedMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NADConGridShift loadBinaryGrid(URL latGridUrl, URL longGridUrl) throws IOException, FactoryException {
        int HEADER_BYTES = 96;
        int SEPARATOR_BYTES = 4;
        int DESCRIPTION_LENGTH = 64;
        ReadableByteChannel latChannel = null;
        Channel longChannel = null;
        NADConGridShift gridShift = null;
        try {
            latChannel = this.getReadChannel(latGridUrl);
            ByteBuffer latBuffer = this.fillBuffer(latChannel, 96);
            longChannel = this.getReadChannel(longGridUrl);
            ByteBuffer longBuffer = this.fillBuffer((ReadableByteChannel)longChannel, 96);
            latBuffer.position(latBuffer.position() + 64);
            int nc = latBuffer.getInt();
            int nr = latBuffer.getInt();
            int nz = latBuffer.getInt();
            float xmin = latBuffer.getFloat();
            float dx = latBuffer.getFloat();
            float ymin = latBuffer.getFloat();
            float dy = latBuffer.getFloat();
            float angle = latBuffer.getFloat();
            float xmax = xmin + (float)(nc - 1) * dx;
            float ymax = ymin + (float)(nr - 1) * dy;
            longBuffer.position(longBuffer.position() + 64);
            if (nc != longBuffer.getInt() || nr != longBuffer.getInt() || nz != longBuffer.getInt() || xmin != longBuffer.getFloat() || dx != longBuffer.getFloat() || ymin != longBuffer.getFloat() || dy != longBuffer.getFloat() || angle != longBuffer.getFloat()) {
                throw new FactoryException(Errors.format(53));
            }
            int RECORD_LENGTH = nc * 4 + 4;
            int NUM_BYTES_LEFT = (nr + 1) * RECORD_LENGTH - 96;
            int START_OF_DATA = RECORD_LENGTH - 96;
            latBuffer = this.fillBuffer(latChannel, NUM_BYTES_LEFT);
            latBuffer.position(START_OF_DATA);
            longBuffer = this.fillBuffer((ReadableByteChannel)longChannel, NUM_BYTES_LEFT);
            longBuffer.position(START_OF_DATA);
            gridShift = new NADConGridShift(xmin, ymin, xmax, ymax, dx, dy, nc, nr);
            int i = 0;
            int j = 0;
            for (i = 0; i < nr; ++i) {
                latBuffer.position(latBuffer.position() + 4);
                longBuffer.position(longBuffer.position() + 4);
                for (j = 0; j < nc; ++j) {
                    gridShift.setLocalizationPoint(j, i, longBuffer.getFloat(), latBuffer.getFloat());
                }
            }
            assert (i == nr) : i;
            assert (j == nc) : j;
        }
        finally {
            if (latChannel != null) {
                latChannel.close();
            }
            if (longChannel != null) {
                longChannel.close();
            }
        }
        return gridShift;
    }

    private ByteBuffer fillBuffer(ReadableByteChannel channel, int numBytes) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(numBytes);
        if (this.fill(buf, channel) == -1) {
            throw new EOFException(Errors.format(48));
        }
        buf.flip();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    private int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file")) {
            File file = URLs.urlToFile(url);
            if (!file.exists() || !file.canRead()) {
                throw new IOException(Errors.format(50, file));
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    /*
     * Exception decompiling
     */
    private NADConGridShift loadTextGrid(URL latGridUrl, URL longGridUrl) throws IOException, FactoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static final class NADCONKey {
        String latFile;
        String longFile;

        public NADCONKey(String latFile, String longFile) {
            this.latFile = latFile;
            this.longFile = longFile;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.latFile == null ? 0 : this.latFile.hashCode());
            result = 31 * result + (this.longFile == null ? 0 : this.longFile.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NADCONKey other = (NADCONKey)obj;
            if (this.latFile == null ? other.latFile != null : !this.latFile.equals(other.latFile)) {
                return false;
            }
            return !(this.longFile == null ? other.longFile != null : !this.longFile.equals(other.longFile));
        }
    }
}

