/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.List;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurvedGeometry;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class MultiCurve
extends MultiLineString
implements MultiCurvedGeometry<MultiLineString> {
    private static final long serialVersionUID = -5796254063449438787L;
    double tolerance;

    public MultiCurve(List<LineString> components, GeometryFactory factory, double tolerance) {
        super(components.toArray(new LineString[components.size()]), factory);
        this.tolerance = tolerance;
    }

    @Override
    public MultiLineString linearize() {
        return this.linearize(this.tolerance);
    }

    @Override
    public MultiLineString linearize(double tolerance) {
        int numGeometries = this.getNumGeometries();
        LineString[] linearized = new LineString[numGeometries];
        for (int k = 0; k < numGeometries; ++k) {
            LineString component = (LineString)this.getGeometryN(k);
            if (component instanceof CurvedGeometry) {
                CurvedGeometry curved = (CurvedGeometry)((Object)component);
                linearized[k] = (LineString)curved.linearize(tolerance);
                continue;
            }
            linearized[k] = component;
        }
        return this.getFactory().createMultiLineString(linearized);
    }

    @Override
    public String toCurvedText() {
        StringBuilder sb = new StringBuilder("MULTICURVE(");
        int numGeometries = this.getNumGeometries();
        for (int k = 0; k < numGeometries; ++k) {
            LineString component = (LineString)this.getGeometryN(k);
            if (component instanceof SingleCurvedGeometry) {
                SingleCurvedGeometry curved = (SingleCurvedGeometry)((Object)component);
                sb.append(curved.toCurvedText());
            } else {
                sb.append("(");
                CoordinateSequence cs = component.getCoordinateSequence();
                for (int i = 0; i < cs.size(); ++i) {
                    sb.append(cs.getX(i) + " " + cs.getY(i));
                    if (i >= cs.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append(")");
            }
            if (k >= numGeometries - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public int getCoordinatesDimension() {
        return 2;
    }
}

