/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public final class FeatureStreams {
    private FeatureStreams() {
    }

    public static <T extends Feature, K extends FeatureType> Stream<T> toFeatureStream(FeatureCollection<K, T> fc) {
        StreamFeatureIterator fi = new StreamFeatureIterator(fc.features());
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(fi, 0), false).onClose(() -> fi.close());
    }

    public static class StreamFeatureIterator<F extends Feature>
    implements Closeable,
    Iterator<F>,
    FeatureIterator<F> {
        private FeatureIterator<F> delegate;

        public StreamFeatureIterator(FeatureIterator<F> fiter) {
            this.delegate = fiter;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public F next() {
            return (F)this.delegate.next();
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

