/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.solver.choco;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropSumOfSquares
extends Propagator<IntVar> {
    protected final int l;
    protected final int[] I;
    protected final long[] I2;
    protected int maxI;
    protected long maxI2;
    protected long sumLB;
    protected long sumUB;
    protected long LB;
    protected long UB;
    protected long b;

    public PropSumOfSquares(IntVar[] variables, long LB, long UB) {
        this(variables, LB, UB, PropSumOfSquares.computePriority(variables.length), false);
    }

    PropSumOfSquares(IntVar[] variables, long LB, long UB, PropagatorPriority priority, boolean reactOnFineEvent) {
        super((Variable[])variables, (Priority)priority, reactOnFineEvent);
        this.l = variables.length;
        this.I = new int[this.l];
        this.I2 = new long[this.l];
        this.maxI = 0;
        this.maxI2 = 0L;
        this.b = 0L;
        this.LB = LB;
        this.UB = UB;
    }

    protected static PropagatorPriority computePriority(int nbvars) {
        if (nbvars == 1) {
            return PropagatorPriority.UNARY;
        }
        if (nbvars == 2) {
            return PropagatorPriority.BINARY;
        }
        if (nbvars == 3) {
            return PropagatorPriority.TERNARY;
        }
        return PropagatorPriority.LINEAR;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    protected void prepare() {
        this.sumUB = 0L;
        this.sumLB = 0L;
        this.maxI = 0;
        this.maxI2 = 0L;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            int lb = ((IntVar[])this.vars)[i].getLB();
            int ub = ((IntVar[])this.vars)[i].getUB();
            long longLB = lb;
            long longUB = ub;
            this.sumLB += longLB * longLB;
            this.sumUB += longUB * longUB;
            this.I[i] = ub - lb;
            this.I2[i] = longUB * longUB - longLB * longLB;
            if (this.maxI < this.I[i]) {
                this.maxI = this.I[i];
            }
            if (this.maxI2 >= this.I2[i]) continue;
            this.maxI2 = this.I2[i];
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    protected void filter() throws ContradictionException {
        this.prepare();
        if (this.LB == this.UB) {
            this.filterOnEq();
        } else {
            this.filterOnLeq();
            this.filterOnGeq();
        }
    }

    protected void filterOnEq() throws ContradictionException {
        boolean anychange;
        long F2 = this.LB - this.sumLB;
        long E = this.sumUB - this.LB;
        do {
            anychange = false;
            if (this.model.getSolver().isLearnOff() && (F2 < 0L || E < 0L)) {
                this.fails();
            }
            if (this.maxI2 > F2 || this.maxI2 > E) {
                this.maxI = 0;
                this.maxI2 = 0L;
                for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                    int ub;
                    int lb;
                    if (this.I2[i] - F2 > 0L) {
                        lb = ((IntVar[])this.vars)[i].getLB();
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound((int)(Math.sqrt(F2) + (double)lb), this)) {
                            int nub = ((IntVar[])this.vars)[i].getUB();
                            long longNub = nub;
                            long longUb = ub;
                            long longLb = lb;
                            E += longNub * longNub - longUb * longUb;
                            this.I[i] = nub - lb;
                            this.I2[i] = longNub * longNub - longLb * longLb;
                            anychange = true;
                        }
                    }
                    if (this.I2[i] - E > 0L) {
                        ub = ((IntVar[])this.vars)[i].getUB();
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound((int)((double)ub - Math.sqrt(E)), this)) {
                            int nlb = ((IntVar[])this.vars)[i].getLB();
                            long longNlb = nlb;
                            long longLb = lb;
                            long longUb = ub;
                            F2 -= longNlb * longNlb - longLb * longLb;
                            this.I[i] = ub - nlb;
                            this.I2[i] = longUb * longUb - longNlb * longNlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI < this.I[i]) {
                        this.maxI = this.I[i];
                    }
                    if (this.maxI2 >= this.I2[i]) continue;
                    this.maxI2 = this.I2[i];
                }
            }
            if (F2 > 0L || E > 0L) continue;
            this.setPassive();
            return;
        } while (anychange);
    }

    protected void filterOnLeq() throws ContradictionException {
        long F2 = this.UB - this.sumLB;
        long E = this.sumUB - this.LB;
        if (this.model.getSolver().isLearnOff() && F2 < 0L) {
            this.fails();
        }
        if (this.maxI2 > F2) {
            this.maxI = 0;
            this.maxI2 = 0L;
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                if (this.I2[i] - F2 > 0L) {
                    int lb = ((IntVar[])this.vars)[i].getLB();
                    int ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound((int)(Math.sqrt(F2) + (double)lb), this)) {
                        int nub = ((IntVar[])this.vars)[i].getUB();
                        long longNub = nub;
                        long longUB = ub;
                        long longLB = lb;
                        E += longNub * longNub - longUB * longUB;
                        this.I[i] = nub - lb;
                        this.I2[i] = longNub * longNub - longLB * longLB;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                if (this.maxI2 >= this.I2[i]) continue;
                this.maxI2 = this.I2[i];
            }
        }
        if (E <= 0L) {
            this.setPassive();
        }
    }

    protected void filterOnGeq() throws ContradictionException {
        long F2 = this.UB - this.sumLB;
        long E = this.sumUB - this.LB;
        if (this.model.getSolver().isLearnOff() && E < 0L) {
            this.fails();
        }
        if (this.maxI2 > E) {
            this.maxI = 0;
            this.maxI2 = 0L;
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                if (this.I2[i] - E > 0L) {
                    int ub = ((IntVar[])this.vars)[i].getUB();
                    int lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound((int)((double)ub - Math.sqrt(E)), this)) {
                        int nlb = ((IntVar[])this.vars)[i].getLB();
                        long longNlb = nlb;
                        long longLB = lb;
                        long longUB = lb;
                        F2 -= longNlb * longNlb - longLB * longLB;
                        this.I[i] = ub - nlb;
                        this.I2[i] = longUB * longUB - longNlb * longNlb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                if (this.maxI2 >= this.I2[i]) continue;
                this.maxI2 = this.I2[i];
            }
        }
        if (F2 <= 0L) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        long sumUB = 0L;
        long sumLB = 0L;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            long longLB = ((IntVar[])this.vars)[i].getLB();
            long longUB = ((IntVar[])this.vars)[i].getUB();
            sumLB += longLB * longLB;
            sumUB += longUB * longUB;
        }
        return this.check(sumLB, sumUB);
    }

    public ESat check(long sumLB, long sumUB) {
        if (sumLB > this.UB) {
            return ESat.FALSE;
        }
        if (sumUB < this.LB) {
            return ESat.FALSE;
        }
        if (sumLB >= this.LB && sumUB <= this.UB) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

