/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetDifference;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetIntersection;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetUnion;

public class DirectedGraph
implements IGraph {
    private final ISet[] successors;
    private final ISet[] predecessors;
    private ISet nodes;
    private final int n;
    private final SetType nodeSetType;
    private final SetType edgeSetType;

    public DirectedGraph(int n, SetType nodeSetType, SetType edgeSetType, boolean allNodes) {
        this.nodeSetType = nodeSetType;
        this.edgeSetType = edgeSetType;
        this.n = n;
        this.predecessors = new ISet[n];
        this.successors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.predecessors[i] = SetFactory.makeSet(edgeSetType, 0);
            this.successors[i] = SetFactory.makeSet(edgeSetType, 0);
        }
        this.nodes = allNodes ? SetFactory.makeConstantSet(0, n - 1) : SetFactory.makeSet(nodeSetType, 0);
    }

    public DirectedGraph(int n, SetType edgeSetType, boolean allNodes) {
        this(n, SetType.BITSET, edgeSetType, allNodes);
    }

    public DirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, boolean allNodes) {
        this.n = n;
        this.nodeSetType = nodeSetType;
        this.edgeSetType = edgeSetType;
        this.predecessors = new ISet[n];
        this.successors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.predecessors[i] = SetFactory.makeStoredSet(edgeSetType, 0, model);
            this.successors[i] = SetFactory.makeStoredSet(edgeSetType, 0, model);
        }
        this.nodes = allNodes ? SetFactory.makeConstantSet(0, n - 1) : SetFactory.makeStoredSet(nodeSetType, 0, model);
    }

    public DirectedGraph(Model model, int n, SetType edgeSetType, boolean allNodes) {
        this(model, n, SetType.BITSET, edgeSetType, allNodes);
    }

    public DirectedGraph(DirectedGraph g2) {
        this.nodeSetType = SetType.FIXED_ARRAY;
        this.edgeSetType = SetType.FIXED_ARRAY;
        this.n = g2.getNbMaxNodes();
        this.nodes = SetFactory.makeConstantSet(g2.getNodes().toArray());
        this.predecessors = new ISet[this.n];
        this.successors = new ISet[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.predecessors[i] = SetFactory.makeConstantSet(g2.getPredecessorsOf(i).toArray());
            this.successors[i] = SetFactory.makeConstantSet(g2.getSuccessorsOf(i).toArray());
        }
    }

    public DirectedGraph(Model model, DirectedGraph g2, ISet nodes, boolean exclude) {
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = g2.getNbMaxNodes();
        this.nodes = exclude ? new SetDifference(model, g2.getNodes(), nodes) : new SetIntersection(model, g2.getNodes(), nodes);
        this.predecessors = new ISet[this.n];
        this.successors = new ISet[this.n];
        for (int i = 0; i < this.n; ++i) {
            if (exclude) {
                this.predecessors[i] = new SetDifference(model, g2.getPredecessorsOf(i), nodes);
                this.successors[i] = new SetDifference(model, g2.getSuccessorsOf(i), nodes);
                continue;
            }
            this.predecessors[i] = new SetIntersection(model, g2.getPredecessorsOf(i), nodes);
            this.successors[i] = new SetIntersection(model, g2.getSuccessorsOf(i), nodes);
        }
    }

    public DirectedGraph(Model model, DirectedGraph g2, DirectedGraph UB, ISet nodes, boolean exclude) {
        int i;
        ISetIterator iSetIterator;
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = g2.getNbMaxNodes();
        boolean needDynamic = false;
        ISet neighNeeded = UB.nodes;
        if (exclude) {
            iSetIterator = nodes.iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (!UB.getNodes().contains(i)) continue;
                needDynamic = true;
                this.nodes = new SetDifference(model, g2.getNodes(), nodes);
                neighNeeded = new SetDifference(model, UB.getNodes(), nodes);
                break;
            }
        } else {
            iSetIterator = UB.getNodes().iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (nodes.contains(i)) continue;
                needDynamic = true;
                SetType nodeSetType = g2.getNodeSetType();
                int offset = g2.getNodes() instanceof ISet.WithOffset ? ((ISet.WithOffset)((Object)g2.getNodes())).getOffset() : 0;
                this.nodes = new SetIntersection(model, nodeSetType, offset, g2.getNodes(), nodes);
                neighNeeded = new SetIntersection(model, nodeSetType, offset, UB.getNodes(), nodes);
                break;
            }
        }
        if (!needDynamic) {
            this.nodes = g2.nodes;
        }
        this.predecessors = new ISet[this.n];
        this.successors = new ISet[this.n];
        iSetIterator = neighNeeded.iterator();
        while (iSetIterator.hasNext()) {
            SetType edgeSetType;
            int j;
            ISetIterator iSetIterator2;
            i = (Integer)iSetIterator.next();
            needDynamic = false;
            if (exclude) {
                iSetIterator2 = nodes.iterator();
                while (iSetIterator2.hasNext()) {
                    j = (Integer)iSetIterator2.next();
                    if (!UB.getSuccessorsOf(i).contains(j)) continue;
                    needDynamic = true;
                    this.successors[i] = new SetDifference(model, g2.getSuccessorsOf(i), nodes);
                    break;
                }
            } else {
                iSetIterator2 = UB.getSuccessorsOf(i).iterator();
                while (iSetIterator2.hasNext()) {
                    j = (Integer)iSetIterator2.next();
                    if (nodes.contains(j)) continue;
                    needDynamic = true;
                    edgeSetType = g2.getEdgeSetType();
                    this.successors[i] = new SetIntersection(model, edgeSetType, 0, g2.getSuccessorsOf(i), nodes);
                }
            }
            if (!needDynamic) {
                this.successors[i] = g2.successors[i];
            }
            needDynamic = false;
            if (exclude) {
                iSetIterator2 = nodes.iterator();
                while (iSetIterator2.hasNext()) {
                    j = (Integer)iSetIterator2.next();
                    if (!UB.getPredecessorsOf(i).contains(j)) continue;
                    needDynamic = true;
                    this.predecessors[i] = new SetDifference(model, g2.getPredecessorsOf(i), nodes);
                    break;
                }
            } else {
                iSetIterator2 = UB.getPredecessorsOf(i).iterator();
                while (iSetIterator2.hasNext()) {
                    j = (Integer)iSetIterator2.next();
                    if (nodes.contains(j)) continue;
                    needDynamic = true;
                    edgeSetType = g2.getEdgeSetType();
                    this.predecessors[i] = new SetIntersection(model, edgeSetType, 0, g2.getPredecessorsOf(i), nodes);
                }
            }
            if (needDynamic) continue;
            this.predecessors[i] = g2.predecessors[i];
        }
    }

    public DirectedGraph(Model model, DirectedGraph g2, ISet[] edgesPredecessors, ISet[] edgesSuccessors, boolean exclude) {
        assert (edgesPredecessors.length == g2.getNbMaxNodes());
        assert (edgesSuccessors.length == g2.getNbMaxNodes());
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = g2.getNbMaxNodes();
        this.predecessors = new ISet[this.n];
        this.successors = new ISet[this.n];
        for (int i = 0; i < this.n; ++i) {
            if (exclude) {
                this.predecessors[i] = new SetDifference(model, g2.getPredecessorsOf(i), edgesPredecessors[i]);
                this.successors[i] = new SetDifference(model, g2.getSuccessorsOf(i), edgesSuccessors[i]);
                continue;
            }
            this.predecessors[i] = new SetIntersection(model, g2.getPredecessorsOf(i), edgesPredecessors[i]);
            this.successors[i] = new SetIntersection(model, g2.getSuccessorsOf(i), edgesSuccessors[i]);
        }
        this.nodes = new SetUnion(model, new SetUnion(model, this.predecessors), new SetUnion(model, this.successors));
    }

    public DirectedGraph(Model model, DirectedGraph g2, DirectedGraph UB, ISet[] edgesPredecessors, ISet[] edgesSuccessors, boolean exclude) {
        assert (edgesPredecessors.length == g2.getNbMaxNodes());
        assert (edgesSuccessors.length == g2.getNbMaxNodes());
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = g2.getNbMaxNodes();
        this.predecessors = new ISet[this.n];
        this.successors = new ISet[this.n];
        boolean nodeNeedDynamic = false;
        for (int i = 0; i < this.n; ++i) {
            int j;
            ISetIterator iSetIterator;
            boolean needDynamic = false;
            if (exclude) {
                iSetIterator = edgesPredecessors[i].iterator();
                while (iSetIterator.hasNext()) {
                    j = (Integer)iSetIterator.next();
                    if (!UB.getPredecessorsOf(i).contains(j)) continue;
                    needDynamic = true;
                    nodeNeedDynamic = true;
                    this.predecessors[i] = new SetDifference(model, g2.getPredecessorsOf(i), edgesPredecessors[i]);
                    break;
                }
            } else {
                iSetIterator = UB.getPredecessorsOf(i).iterator();
                while (iSetIterator.hasNext()) {
                    j = (Integer)iSetIterator.next();
                    if (edgesPredecessors[i].contains(j)) continue;
                    needDynamic = true;
                    nodeNeedDynamic = true;
                    this.predecessors[i] = new SetIntersection(model, g2.getPredecessorsOf(i), edgesPredecessors[i]);
                    break;
                }
            }
            if (!needDynamic) {
                this.predecessors[i] = g2.predecessors[i];
            }
            needDynamic = false;
            if (exclude) {
                iSetIterator = edgesSuccessors[i].iterator();
                while (iSetIterator.hasNext()) {
                    j = (Integer)iSetIterator.next();
                    if (!UB.getSuccessorsOf(i).contains(j)) continue;
                    needDynamic = true;
                    nodeNeedDynamic = true;
                    this.successors[i] = new SetDifference(model, g2.getSuccessorsOf(i), edgesSuccessors[i]);
                    break;
                }
            } else {
                iSetIterator = UB.getSuccessorsOf(i).iterator();
                while (iSetIterator.hasNext()) {
                    j = (Integer)iSetIterator.next();
                    if (edgesSuccessors[i].contains(j)) continue;
                    needDynamic = true;
                    nodeNeedDynamic = true;
                    this.successors[i] = new SetIntersection(model, g2.getSuccessorsOf(i), edgesSuccessors[i]);
                    break;
                }
            }
            if (needDynamic) continue;
            this.successors[i] = g2.successors[i];
        }
        this.nodes = nodeNeedDynamic ? new SetUnion(model, new SetUnion(model, this.predecessors), new SetUnion(model, this.successors)) : g2.nodes;
    }

    public DirectedGraph(Model model, DirectedGraph g2, int[][] edges, boolean exclude) {
        this(model, g2, DirectedGraph.edgesArrayToPredecessorsSets(g2.getNbMaxNodes(), edges), DirectedGraph.edgesArrayToSuccessorsSets(g2.getNbMaxNodes(), edges), exclude);
    }

    public DirectedGraph(Model model, DirectedGraph g2, DirectedGraph UB, int[][] edges, boolean exclude) {
        this(model, g2, UB, DirectedGraph.edgesArrayToPredecessorsSets(g2.getNbMaxNodes(), edges), DirectedGraph.edgesArrayToSuccessorsSets(g2.getNbMaxNodes(), edges), exclude);
    }

    public DirectedGraph(Model model, DirectedGraph ... graphs) {
        int i;
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = Arrays.stream(graphs).mapToInt(DirectedGraph::getNbMaxNodes).max().getAsInt();
        ISet[] nodeSets = new ISet[graphs.length];
        for (i = 0; i < graphs.length; ++i) {
            nodeSets[i] = graphs[i].getNodes();
        }
        this.nodes = new SetUnion(model, nodeSets);
        this.predecessors = new ISet[this.n];
        this.successors = new ISet[this.n];
        for (i = 0; i < this.n; ++i) {
            ISet[] predSet = new ISet[graphs.length];
            ISet[] succSet = new ISet[graphs.length];
            for (int j = 0; j < graphs.length; ++j) {
                predSet[j] = graphs[j].getPredecessorsOf(i);
                succSet[j] = graphs[j].getSuccessorsOf(i);
            }
            this.predecessors[i] = new SetUnion(model, predSet);
            this.successors[i] = new SetUnion(model, succSet);
        }
    }

    public DirectedGraph(Model model, ISet additionalNodes, ISet[] additionalSuccs, DirectedGraph ... graphs) {
        int i;
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = Arrays.stream(graphs).mapToInt(DirectedGraph::getNbMaxNodes).max().getAsInt();
        ISet[] nodeSets = new ISet[graphs.length + 1];
        for (i = 0; i < graphs.length; ++i) {
            nodeSets[i] = graphs[i].getNodes();
        }
        nodeSets[graphs.length] = additionalNodes;
        this.nodes = new SetUnion(model, nodeSets);
        this.predecessors = new ISet[this.n];
        this.successors = new ISet[this.n];
        for (i = 0; i < this.n; ++i) {
            ISet[] predSet = new ISet[graphs.length];
            ISet[] succSet = new ISet[graphs.length + 1];
            for (int j = 0; j < graphs.length; ++j) {
                predSet[j] = graphs[j].getPredecessorsOf(i);
                succSet[j] = graphs[j].getSuccessorsOf(i);
            }
            succSet[graphs.length] = additionalSuccs[i];
            this.predecessors[i] = new SetUnion(model, predSet);
            this.successors[i] = new SetUnion(model, succSet);
        }
    }

    public static ISet[] edgesArrayToPredecessorsSets(int n, int[][] edges) {
        ISet[] predecessors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            int finalI = i;
            predecessors[i] = SetFactory.makeConstantSet(IntStream.range(0, edges.length).filter(v -> {
                assert (edges[v].length == 2);
                return edges[v][1] == finalI;
            }).map(v -> edges[v][0]).toArray());
        }
        return predecessors;
    }

    public static ISet[] edgesArrayToSuccessorsSets(int n, int[][] edges) {
        ISet[] successors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            int finalI = i;
            successors[i] = SetFactory.makeConstantSet(IntStream.range(0, edges.length).filter(v -> {
                assert (edges[v].length == 2);
                return edges[v][0] == finalI;
            }).map(v -> edges[v][1]).toArray());
        }
        return successors;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes : \n").append(this.nodes).append("\n");
        sb.append("successors : \n");
        ISetIterator iSetIterator = this.nodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            sb.append(i).append(" -> {");
            ISetIterator iSetIterator2 = this.successors[i].iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                sb.append(j).append(" ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    @Override
    public int getNbMaxNodes() {
        return this.n;
    }

    @Override
    public ISet getNodes() {
        return this.nodes;
    }

    @Override
    public SetType getEdgeSetType() {
        return this.edgeSetType;
    }

    @Override
    public SetType getNodeSetType() {
        return this.nodeSetType;
    }

    @Override
    public boolean addNode(int x) {
        return this.nodes.add(x);
    }

    @Override
    public boolean removeNode(int x) {
        if (this.nodes.remove(x)) {
            ISetIterator iter = this.successors[x].iterator();
            while (iter.hasNext()) {
                this.predecessors[iter.nextInt()].remove(x);
            }
            this.successors[x].clear();
            iter = this.predecessors[x].iterator();
            while (iter.hasNext()) {
                this.successors[iter.nextInt()].remove(x);
            }
            this.predecessors[x].clear();
            return true;
        }
        assert (this.predecessors[x].size() == 0) : "incoherent directed graph";
        assert (this.successors[x].size() == 0) : "incoherent directed graph";
        return false;
    }

    @Override
    public boolean removeEdge(int from, int to) {
        if (this.successors[from].remove(to)) {
            boolean b2 = this.predecessors[to].remove(from);
            assert (b2) : "incoherent directed graph";
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEdge(int from, int to) {
        if (this.successors[from].contains(to)) {
            assert (this.predecessors[to].contains(from)) : "incoherent directed graph";
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public int getDomainSize() {
        int size = 0;
        ISetIterator iSetIterator = this.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int n = (Integer)iSetIterator.next();
            ++size;
            size += this.getSuccessorsOf(n).size();
            size += this.getPredecessorsOf(n).size();
        }
        return size;
    }

    @Override
    public boolean addEdge(int from, int to) {
        this.addNode(from);
        this.addNode(to);
        if (this.successors[from].add(to)) {
            boolean b2 = this.predecessors[to].add(from);
            assert (b2) : "incoherent directed graph";
            return true;
        }
        return false;
    }

    @Override
    public ISet getSuccessorsOf(int x) {
        return this.successors[x];
    }

    @Override
    public ISet getPredecessorsOf(int x) {
        return this.predecessors[x];
    }

    public boolean equals(DirectedGraph other) {
        if (this.getNodes().size() != other.getNodes().size()) {
            return false;
        }
        ISetIterator iSetIterator = this.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (!other.containsNode(i)) {
                return false;
            }
            if (this.getSuccessorsOf(i).size() != other.getSuccessorsOf(i).size()) {
                return false;
            }
            ISetIterator iSetIterator2 = this.getSuccessorsOf(i).iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (other.containsEdge(i, j)) continue;
                return false;
            }
        }
        return true;
    }
}

