/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input.spi;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.input.spi.URLImageInputStreamSpi;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;

public class StringImageInputStreamSpi
extends ImageInputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.input");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class<String> inputClass = String.class;

    public StringImageInputStreamSpi() {
        super(vendorName, version, inputClass);
    }

    @Override
    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) throws IOException {
        if (!(input instanceof String)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("The provided input is not a valid String.");
            }
            return null;
        }
        String sourceString = (String)input;
        try {
            URL tempURL = new URL(sourceString);
            return new URLImageInputStreamSpi().createInputStreamInstance(tempURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
        }
        catch (Throwable e2) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
            }
            File tempFile = new File(sourceString);
            try {
                return new FileImageInputStreamExtImpl(tempFile);
            }
            catch (Throwable e3) {
                throw new IllegalArgumentException(e3);
            }
        }
    }

    @Override
    public String getDescription(Locale locale) {
        return "Service provider that helps connecting to the object pointed by a String";
    }
}

