/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.imageioimpl;

import com.sun.media.jai.imageioimpl.I18N;
import com.sun.media.jai.imageioimpl.ImageIOCollectionImage;
import com.sun.media.jai.imageioimpl.ImageWriteCRIF;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.CollectionImage;
import javax.media.jai.CollectionImageFactory;
import javax.media.jai.CollectionOp;
import javax.media.jai.PropertySource;

public final class ImageWriteCIF
implements CollectionImageFactory {
    public CollectionImage create(ParameterBlock args, RenderingHints hints) {
        boolean transcode;
        Object streamMetadataProperty;
        ImageWriter writer = (ImageWriter)args.getObjectParameter(13);
        if (writer == null) {
            String format = (String)args.getObjectParameter(1);
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            if (writers != null) {
                writer = writers.next();
            } else {
                throw new RuntimeException(I18N.getString("ImageWriteCIF0") + " " + format);
            }
        }
        Collection collection = (Collection)args.getSource(0);
        int numRenderedImages = 0;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof RenderedImage)) continue;
            ++numRenderedImages;
        }
        boolean writeToSequence = writer.canWriteSequence();
        if (numRenderedImages > 1 && !writeToSequence) {
            throw new RuntimeException(I18N.getString("ImageWriteCIF1"));
        }
        IIOMetadata streamMetadata = (IIOMetadata)args.getObjectParameter(7);
        boolean useProperties = (Boolean)args.getObjectParameter(2);
        if (streamMetadata == null && useProperties && collection instanceof PropertySource && (streamMetadataProperty = ((PropertySource)((Object)collection)).getProperty("JAI.StreamMetadata")) instanceof IIOMetadata) {
            streamMetadata = (IIOMetadata)streamMetadataProperty;
        }
        ImageWriteParam param = (ImageWriteParam)args.getObjectParameter(12);
        if (streamMetadata != null && (transcode = ((Boolean)args.getObjectParameter(3)).booleanValue())) {
            streamMetadata = writer.convertStreamMetadata(streamMetadata, param);
        }
        if (writeToSequence) {
            try {
                Object output = args.getObjectParameter(0);
                ImageOutputStream stream = ImageWriteCRIF.getImageOutputStream(output);
                writer.setOutput(stream != null ? stream : output);
                writer.prepareWriteSequence(streamMetadata);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        ParameterBlock imagePB = (ParameterBlock)args.clone();
        imagePB.set(null, 7);
        imagePB.set(writer, 13);
        IIOMetadata[] imageMetadata = (IIOMetadata[])args.getObjectParameter(8);
        BufferedImage[] thumbnails = (BufferedImage[])args.getObjectParameter(9);
        iter = collection.iterator();
        ImageIOCollectionImage imageList = new ImageIOCollectionImage(collection.size());
        int imageIndex = 0;
        while (iter.hasNext()) {
            Object paramPropertyValue;
            Object nextElement = iter.next();
            if (!(nextElement instanceof RenderedImage)) continue;
            imagePB.setSource((RenderedImage)nextElement, 0);
            if (imageMetadata != null) {
                imagePB.set(imageMetadata[imageIndex], 8);
            }
            if (thumbnails != null) {
                imagePB.set(thumbnails[imageIndex], 9);
            }
            RenderedImage nextImage = ImageWriteCRIF.create(imageIndex, writeToSequence, imagePB, hints);
            if (param == null && (paramPropertyValue = nextImage.getProperty("JAI.ImageWriteParam")) instanceof ImageWriteParam) {
                param = (ImageWriteParam)paramPropertyValue;
                imagePB.set(param, 12);
            }
            imageList.add(nextImage);
            ++imageIndex;
        }
        boolean allowPixelReplacement = (Boolean)args.getObjectParameter(5);
        if (writeToSequence && !allowPixelReplacement) {
            try {
                writer.endWriteSequence();
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }
        if (param != null) {
            imageList.setProperty("JAI.ImageWriteParam", param);
        }
        imageList.setProperty("JAI.ImageWriter", writer);
        if (streamMetadata != null) {
            imageList.setProperty("JAI.StreamMetadata", streamMetadata);
        }
        return imageList;
    }

    public CollectionImage update(ParameterBlock oldParamBlock, RenderingHints oldHints, ParameterBlock newParamBlock, RenderingHints newHints, CollectionImage oldRendering, CollectionOp op) {
        return null;
    }
}

