/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.AtomMatcher;
import org.openscience.cdk.isomorphism.BondMatcher;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.StateStream;
import org.openscience.cdk.isomorphism.VFState;
import org.openscience.cdk.isomorphism.VFSubState;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;

public final class VentoFoggia
extends Pattern {
    private final IAtomContainer query;
    private final int[][] g1;
    private final GraphUtil.EdgeToBondMap bonds1;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;
    private final boolean subgraph;

    private VentoFoggia(IAtomContainer query2, AtomMatcher atomMatcher, BondMatcher bondMatcher, boolean substructure) {
        this.query = query2;
        this.atomMatcher = atomMatcher;
        this.bondMatcher = bondMatcher;
        this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor(query2);
        this.g1 = GraphUtil.toAdjList(query2, this.bonds1);
        this.subgraph = substructure;
        this.determineFilters(query2);
    }

    @Override
    public int[] match(IAtomContainer target) {
        return this.matchAll(target).first();
    }

    @Override
    public Mappings matchAll(IAtomContainer target) {
        AdjListCache cached = (AdjListCache)target.getProperty(AdjListCache.class.getName());
        if (cached == null || !cached.validate(target)) {
            cached = new AdjListCache(target);
            target.setProperty(AdjListCache.class.getName(), cached);
        }
        GraphUtil.EdgeToBondMap bonds2 = cached.bmap;
        int[][] g2 = cached.g;
        VFIterable iterable = new VFIterable(this.query, target, this.g1, g2, this.bonds1, bonds2, this.atomMatcher, this.bondMatcher, this.subgraph);
        Mappings mappings = new Mappings(this.query, target, iterable);
        return this.filter(mappings, this.query, target);
    }

    public static Pattern findSubstructure(IAtomContainer query2) {
        boolean isQuery = query2 instanceof IQueryAtomContainer;
        return VentoFoggia.findSubstructure(query2, isQuery ? AtomMatcher.forQuery() : AtomMatcher.forElement(), isQuery ? BondMatcher.forQuery() : BondMatcher.forOrder());
    }

    public static Pattern findIdentical(IAtomContainer query2) {
        boolean isQuery = query2 instanceof IQueryAtomContainer;
        return VentoFoggia.findIdentical(query2, isQuery ? AtomMatcher.forQuery() : AtomMatcher.forElement(), isQuery ? BondMatcher.forQuery() : BondMatcher.forOrder());
    }

    public static Pattern findSubstructure(IAtomContainer query2, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
        return new VentoFoggia(query2, atomMatcher, bondMatcher, true);
    }

    public static Pattern findIdentical(IAtomContainer query2, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
        return new VentoFoggia(query2, atomMatcher, bondMatcher, false);
    }

    private static final class AdjListCache {
        private static final long MAX_AGE = TimeUnit.MILLISECONDS.toNanos(100L);
        private final int[][] g;
        private final GraphUtil.EdgeToBondMap bmap;
        private final int numAtoms;
        private final int numBonds;
        private final long tInit;

        private AdjListCache(IAtomContainer mol) {
            this.bmap = GraphUtil.EdgeToBondMap.withSpaceFor(mol);
            this.g = GraphUtil.toAdjList(mol, this.bmap);
            this.numAtoms = mol.getAtomCount();
            this.numBonds = mol.getBondCount();
            this.tInit = System.nanoTime();
        }

        private boolean validate(IAtomContainer mol) {
            return mol.getAtomCount() == this.numAtoms && mol.getBondCount() == this.numBonds && System.nanoTime() - this.tInit < MAX_AGE;
        }
    }

    private static final class VFIterable
    implements Iterable<int[]> {
        private final IAtomContainer container1;
        private final IAtomContainer container2;
        private final int[][] g1;
        private final int[][] g2;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;
        private final AtomMatcher atomMatcher;
        private final BondMatcher bondMatcher;
        private final boolean subgraph;

        private VFIterable(IAtomContainer container1, IAtomContainer container2, int[][] g1, int[][] g2, GraphUtil.EdgeToBondMap bonds1, GraphUtil.EdgeToBondMap bonds2, AtomMatcher atomMatcher, BondMatcher bondMatcher, boolean subgraph) {
            this.container1 = container1;
            this.container2 = container2;
            this.g1 = g1;
            this.g2 = g2;
            this.bonds1 = bonds1;
            this.bonds2 = bonds2;
            this.atomMatcher = atomMatcher;
            this.bondMatcher = bondMatcher;
            this.subgraph = subgraph;
        }

        @Override
        public Iterator<int[]> iterator() {
            if (this.subgraph) {
                return new StateStream(new VFSubState(this.container1, this.container2, this.g1, this.g2, this.bonds1, this.bonds2, this.atomMatcher, this.bondMatcher));
            }
            return new StateStream(new VFState(this.container1, this.container2, this.g1, this.g2, this.bonds1, this.bonds2, this.atomMatcher, this.bondMatcher));
        }
    }
}

