/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugPseudoAtom
extends PseudoAtom
implements IPseudoAtom {
    private static final long serialVersionUID = -5935090219383862070L;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugPseudoAtom.class);

    public DebugPseudoAtom() {
        logger.debug("Instantiated a DebugAtom");
    }

    public DebugPseudoAtom(IElement element) {
        super(element);
        logger.debug("Instantiated a DebugAtom: element= ", element);
    }

    public DebugPseudoAtom(String symbol) {
        super(symbol);
        logger.debug("Instantiated a DebugAtom: symbol= ", symbol);
    }

    public DebugPseudoAtom(String symbol, Point2d point2d) {
        super(symbol, point2d);
        logger.debug("Instantiated a DebugAtom: symbol= ", symbol + " point2d=" + point2d);
    }

    public DebugPseudoAtom(String symbol, Point3d point3d) {
        super(symbol, point3d);
        logger.debug("Instantiated a DebugAtom: symbol= ", symbol + " point3d=" + point3d);
    }

    @Override
    public void setCharge(Double charge) {
        logger.debug("Setting charge: ", charge);
        super.setCharge(charge);
    }

    @Override
    public Double getCharge() {
        logger.debug("Setting charge: ", super.getCharge());
        return super.getCharge();
    }

    @Override
    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        logger.debug("Setting hydrogen count: ", hydrogenCount);
        super.setImplicitHydrogenCount(hydrogenCount);
    }

    @Override
    public Integer getImplicitHydrogenCount() {
        logger.debug("Getting hydrogen count: ", super.getImplicitHydrogenCount());
        return super.getImplicitHydrogenCount();
    }

    @Override
    public void setPoint2d(Point2d point2d) {
        logger.debug("Setting point2d: x=" + point2d.x + ", y=" + point2d.y);
        super.setPoint2d(point2d);
    }

    @Override
    public void setPoint3d(Point3d point3d) {
        logger.debug("Setting point3d: x=" + point3d.x + ", y=" + point3d.y, ", z=" + point3d.z);
        super.setPoint3d(point3d);
    }

    @Override
    public void setFractionalPoint3d(Point3d point3d) {
        logger.debug("Setting fractional point3d: x=" + point3d.x + ", y=" + point3d.y, ", z=" + point3d.z);
        super.setFractionalPoint3d(point3d);
    }

    @Override
    public void setStereoParity(Integer stereoParity) {
        logger.debug("Setting stereoParity: ", stereoParity);
        super.setStereoParity(stereoParity);
    }

    @Override
    public Point2d getPoint2d() {
        Point2d point2d = super.getPoint2d();
        if (point2d == null) {
            logger.debug("Getting point2d: null");
        } else {
            logger.debug("Getting point2d: x=" + point2d.x + ", y=" + point2d.y);
        }
        return point2d;
    }

    @Override
    public Point3d getPoint3d() {
        Point3d point3d = super.getPoint3d();
        if (point3d == null) {
            logger.debug("Getting point3d: null");
        } else {
            logger.debug("Getting point3d: x=" + point3d.x + ", y=" + point3d.y, ", z=" + point3d.z);
        }
        return point3d;
    }

    @Override
    public Point3d getFractionalPoint3d() {
        Point3d point3d = super.getFractionalPoint3d();
        if (point3d == null) {
            logger.debug("Getting fractional point3d: null");
        } else {
            logger.debug("Getting fractional point3d: x=" + point3d.x + ", y=" + point3d.y, ", z=" + point3d.z);
        }
        return point3d;
    }

    @Override
    public Integer getStereoParity() {
        logger.debug("Getting stereo parity: ", super.getStereoParity());
        return super.getStereoParity();
    }

    @Override
    public void setAtomTypeName(String identifier) {
        logger.debug("Setting atom type name: ", identifier);
        super.setAtomTypeName(identifier);
    }

    @Override
    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        logger.debug("Setting max bond order: ", new Object[]{maxBondOrder});
        super.setMaxBondOrder(maxBondOrder);
    }

    @Override
    public void setBondOrderSum(Double bondOrderSum) {
        logger.debug("Setting bond order sum: ", bondOrderSum);
        super.setBondOrderSum(bondOrderSum);
    }

    @Override
    public String getAtomTypeName() {
        logger.debug("Getting atom type name: ", super.getAtomTypeName());
        return super.getAtomTypeName();
    }

    @Override
    public IBond.Order getMaxBondOrder() {
        logger.debug("Getting max bond order: ", new Object[]{super.getMaxBondOrder()});
        return super.getMaxBondOrder();
    }

    @Override
    public Double getBondOrderSum() {
        logger.debug("Getting bond order sum: ", super.getBondOrderSum());
        return super.getBondOrderSum();
    }

    @Override
    public void setFormalCharge(Integer charge) {
        logger.debug("Setting formal charge: ", charge);
        super.setFormalCharge(charge);
    }

    @Override
    public Integer getFormalCharge() {
        logger.debug("Getting formal charge: ", super.getFormalCharge());
        return super.getFormalCharge();
    }

    @Override
    public void setFormalNeighbourCount(Integer count) {
        logger.debug("Setting forml neighbour count: ", count);
        super.setFormalNeighbourCount(count);
    }

    @Override
    public Integer getFormalNeighbourCount() {
        logger.debug("Getting formal neighbour count: ", super.getFormalNeighbourCount());
        return super.getFormalNeighbourCount();
    }

    @Override
    public void setHybridization(IAtomType.Hybridization hybridization) {
        logger.debug("Setting hybridization: ", new Object[]{hybridization});
        super.setHybridization(hybridization);
    }

    @Override
    public IAtomType.Hybridization getHybridization() {
        logger.debug("Getting hybridization: ", new Object[]{super.getHybridization()});
        return super.getHybridization();
    }

    @Override
    public void setCovalentRadius(Double radius) {
        logger.debug("Setting covalent radius: ", radius);
        super.setCovalentRadius(radius);
    }

    @Override
    public Double getCovalentRadius() {
        logger.debug("Getting covalent radius: ", super.getCovalentRadius());
        return super.getCovalentRadius();
    }

    @Override
    public void setValency(Integer valency) {
        logger.debug("Setting valency: ", valency);
        super.setValency(valency);
    }

    @Override
    public Integer getValency() {
        logger.debug("Getting valency: ", super.getValency());
        return super.getValency();
    }

    @Override
    public void setNaturalAbundance(Double naturalAbundance) {
        logger.debug("Setting natural abundance: ", naturalAbundance);
        super.setNaturalAbundance(naturalAbundance);
    }

    @Override
    public void setExactMass(Double exactMass) {
        logger.debug("Setting exact mass: ", exactMass);
        super.setExactMass(exactMass);
    }

    @Override
    public Double getNaturalAbundance() {
        logger.debug("Getting natural abundance: ", super.getNaturalAbundance());
        return super.getNaturalAbundance();
    }

    @Override
    public Double getExactMass() {
        logger.debug("Getting exact mass: ", super.getExactMass());
        return super.getExactMass();
    }

    @Override
    public Integer getMassNumber() {
        logger.debug("Getting mass number: ", super.getMassNumber());
        return super.getMassNumber();
    }

    @Override
    public void setMassNumber(Integer massNumber) {
        logger.debug("Setting mass number: ", massNumber);
        super.setMassNumber(massNumber);
    }

    @Override
    public Integer getAtomicNumber() {
        logger.debug("Getting atomic number: ", super.getAtomicNumber());
        return super.getAtomicNumber();
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        logger.debug("Setting atomic number: ", atomicNumber);
        super.setAtomicNumber(atomicNumber);
    }

    @Override
    public String getSymbol() {
        logger.debug("Getting symbol: ", super.getSymbol());
        return super.getSymbol();
    }

    @Override
    public void setSymbol(String symbol) {
        logger.debug("Setting symbol: ", symbol);
        super.setSymbol(symbol);
    }

    @Override
    public void addListener(IChemObjectListener col) {
        logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public <T> T getProperty(Object description) {
        logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flagType, boolean flagValue) {
        logger.debug("Setting flag: ", flagType + "=" + flagValue);
        super.setFlag(flagType, flagValue);
    }

    @Override
    public boolean getFlag(int flagType) {
        logger.debug("Setting flag: ", flagType + "=" + super.getFlag(flagType));
        return super.getFlag(flagType);
    }

    @Override
    public void addProperties(Map<Object, Object> properties) {
        logger.debug("Setting properties: ", properties);
        super.addProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public IPseudoAtom clone() throws CloneNotSupportedException {
        IPseudoAtom clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public String getLabel() {
        logger.debug("Getting label: ", super.getLabel());
        return super.getLabel();
    }

    @Override
    public void setLabel(String label) {
        logger.debug("Setting label: ", label);
        super.setLabel(label);
    }
}

