/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.atomtype.IAtomTypeMatcher;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class CDKAtomTypeMatcher
implements IAtomTypeMatcher {
    public static final int REQUIRE_NOTHING = 1;
    public static final int REQUIRE_EXPLICIT_HYDROGENS = 2;
    private AtomTypeFactory factory;
    private int mode;
    private static final Object LOCK = new Object();
    private static Map<Integer, Map<IChemObjectBuilder, CDKAtomTypeMatcher>> factories = new ConcurrentHashMap<Integer, Map<IChemObjectBuilder, CDKAtomTypeMatcher>>(5);

    private CDKAtomTypeMatcher(IChemObjectBuilder builder, int mode) {
        this.factory = AtomTypeFactory.getInstance("org/openscience/cdk/dict/data/cdk-atom-types.owl", builder);
        this.mode = mode;
    }

    public static CDKAtomTypeMatcher getInstance(IChemObjectBuilder builder) {
        return CDKAtomTypeMatcher.getInstance(builder, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDKAtomTypeMatcher getInstance(IChemObjectBuilder builder, int mode) {
        Object object = LOCK;
        synchronized (object) {
            if (!factories.containsKey(mode)) {
                factories.put(mode, new Hashtable(1));
            }
            if (!factories.get(mode).containsKey(builder)) {
                factories.get(mode).put(builder, new CDKAtomTypeMatcher(builder, mode));
            }
            return factories.get(mode).get(builder);
        }
    }

    @Override
    public IAtomType[] findMatchingAtomTypes(IAtomContainer atomContainer) throws CDKException {
        return this.findMatchingAtomTypes(atomContainer, null);
    }

    private IAtomType[] findMatchingAtomTypes(IAtomContainer atomContainer, RingSearch searcher) throws CDKException {
        if (searcher == null) {
            searcher = new RingSearch(atomContainer);
        }
        HashMap<IAtom, ArrayList<IBond>> connectedBonds = new HashMap<IAtom, ArrayList<IBond>>(atomContainer.getAtomCount());
        for (IBond bond : atomContainer.bonds()) {
            for (IAtom atom : bond.atoms()) {
                ArrayList<IBond> atomBonds = (ArrayList<IBond>)connectedBonds.get(atom);
                if (atomBonds == null) {
                    atomBonds = new ArrayList<IBond>(4);
                    connectedBonds.put(atom, atomBonds);
                }
                atomBonds.add(bond);
            }
        }
        IAtomType[] types = new IAtomType[atomContainer.getAtomCount()];
        int typeCounter = 0;
        for (IAtom atom : atomContainer.atoms()) {
            types[typeCounter] = this.findMatchingAtomType(atomContainer, atom, searcher, (List)connectedBonds.get(atom));
            ++typeCounter;
        }
        return types;
    }

    @Override
    public IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        return this.findMatchingAtomType(atomContainer, atom, null, null);
    }

    private IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atom, RingSearch searcher, List<IBond> connectedBonds) throws CDKException {
        IAtomType type = null;
        if (atom instanceof IPseudoAtom) {
            return this.factory.getAtomType("X");
        }
        if ("C".equals(atom.getSymbol())) {
            type = this.perceiveCarbons(atomContainer, atom, searcher, connectedBonds);
        } else if ("H".equals(atom.getSymbol())) {
            type = this.perceiveHydrogens(atomContainer, atom, connectedBonds);
        } else if ("O".equals(atom.getSymbol())) {
            type = this.perceiveOxygens(atomContainer, atom, searcher, connectedBonds);
        } else if ("N".equals(atom.getSymbol())) {
            type = this.perceiveNitrogens(atomContainer, atom, searcher, connectedBonds);
        } else if ("S".equals(atom.getSymbol())) {
            type = this.perceiveSulphurs(atomContainer, atom, searcher, connectedBonds);
        } else if ("P".equals(atom.getSymbol())) {
            type = this.perceivePhosphors(atomContainer, atom, connectedBonds);
        } else if ("Si".equals(atom.getSymbol())) {
            type = this.perceiveSilicon(atomContainer, atom);
        } else if ("Li".equals(atom.getSymbol())) {
            type = this.perceiveLithium(atomContainer, atom);
        } else if ("B".equals(atom.getSymbol())) {
            type = this.perceiveBorons(atomContainer, atom);
        } else if ("Be".equals(atom.getSymbol())) {
            type = this.perceiveBeryllium(atomContainer, atom);
        } else if ("Cr".equals(atom.getSymbol())) {
            type = this.perceiveChromium(atomContainer, atom);
        } else if ("Se".equals(atom.getSymbol())) {
            type = this.perceiveSelenium(atomContainer, atom, connectedBonds);
        } else if ("Mo".equals(atom.getSymbol())) {
            type = this.perceiveMolybdenum(atomContainer, atom);
        } else if ("Rb".equals(atom.getSymbol())) {
            type = this.perceiveRubidium(atomContainer, atom);
        } else if ("Te".equals(atom.getSymbol())) {
            type = this.perceiveTellurium(atomContainer, atom);
        } else if ("Cu".equals(atom.getSymbol())) {
            type = this.perceiveCopper(atomContainer, atom);
        } else if ("Ba".equals(atom.getSymbol())) {
            type = this.perceiveBarium(atomContainer, atom);
        } else if ("Ga".equals(atom.getSymbol())) {
            type = this.perceiveGallium(atomContainer, atom);
        } else if ("Ru".equals(atom.getSymbol())) {
            type = this.perceiveRuthenium(atomContainer, atom);
        } else if ("Zn".equals(atom.getSymbol())) {
            type = this.perceiveZinc(atomContainer, atom);
        } else if ("Al".equals(atom.getSymbol())) {
            type = this.perceiveAluminium(atomContainer, atom);
        } else if ("Ni".equals(atom.getSymbol())) {
            type = this.perceiveNickel(atomContainer, atom);
        } else if ("Gd".equals(atom.getSymbol())) {
            type = this.perceiveGadolinum(atomContainer, atom);
        } else if ("Ge".equals(atom.getSymbol())) {
            type = this.perceiveGermanium(atomContainer, atom);
        } else if ("Co".equals(atom.getSymbol())) {
            type = this.perceiveCobalt(atomContainer, atom);
        } else if ("Br".equals(atom.getSymbol())) {
            type = this.perceiveBromine(atomContainer, atom);
        } else if ("V".equals(atom.getSymbol())) {
            type = this.perceiveVanadium(atomContainer, atom);
        } else if ("Ti".equals(atom.getSymbol())) {
            type = this.perceiveTitanium(atomContainer, atom);
        } else if ("Sr".equals(atom.getSymbol())) {
            type = this.perceiveStrontium(atomContainer, atom);
        } else if ("Pb".equals(atom.getSymbol())) {
            type = this.perceiveLead(atomContainer, atom);
        } else if ("Tl".equals(atom.getSymbol())) {
            type = this.perceiveThallium(atomContainer, atom);
        } else if ("Sb".equals(atom.getSymbol())) {
            type = this.perceiveAntimony(atomContainer, atom);
        } else if ("Pt".equals(atom.getSymbol())) {
            type = this.perceivePlatinum(atomContainer, atom);
        } else if ("Hg".equals(atom.getSymbol())) {
            type = this.perceiveMercury(atomContainer, atom);
        } else if ("Fe".equals(atom.getSymbol())) {
            type = this.perceiveIron(atomContainer, atom);
        } else if ("Ra".equals(atom.getSymbol())) {
            type = this.perceiveRadium(atomContainer, atom);
        } else if ("Au".equals(atom.getSymbol())) {
            type = this.perceiveGold(atomContainer, atom);
        } else if ("Ag".equals(atom.getSymbol())) {
            type = this.perceiveSilver(atomContainer, atom);
        } else if ("Cl".equals(atom.getSymbol())) {
            type = this.perceiveChlorine(atomContainer, atom, connectedBonds);
        } else if ("In".equals(atom.getSymbol())) {
            type = this.perceiveIndium(atomContainer, atom);
        } else if ("Pu".equals(atom.getSymbol())) {
            type = this.perceivePlutonium(atomContainer, atom);
        } else if ("Th".equals(atom.getSymbol())) {
            type = this.perceiveThorium(atomContainer, atom);
        } else if ("K".equals(atom.getSymbol())) {
            type = this.perceivePotassium(atomContainer, atom);
        } else if ("Mn".equals(atom.getSymbol())) {
            type = this.perceiveManganese(atomContainer, atom);
        } else if ("Mg".equals(atom.getSymbol())) {
            type = this.perceiveMagnesium(atomContainer, atom);
        } else if ("Na".equals(atom.getSymbol())) {
            type = this.perceiveSodium(atomContainer, atom);
        } else if ("As".equals(atom.getSymbol())) {
            type = this.perceiveArsenic(atomContainer, atom);
        } else if ("Cd".equals(atom.getSymbol())) {
            type = this.perceiveCadmium(atomContainer, atom);
        } else if ("Ca".equals(atom.getSymbol())) {
            type = this.perceiveCalcium(atomContainer, atom);
        } else {
            if (type == null) {
                type = this.perceiveHalogens(atomContainer, atom, connectedBonds);
            }
            if (type == null) {
                type = this.perceiveCommonSalts(atomContainer, atom);
            }
            if (type == null) {
                type = this.perceiveOrganometallicCenters(atomContainer, atom);
            }
            if (type == null) {
                type = this.perceiveNobelGases(atomContainer, atom);
            }
        }
        if (type == null) {
            type = this.getAtomType("X");
        }
        return type;
    }

    private IAtomType perceiveGallium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (!this.isCharged(atom) && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedBondsCount(atom) <= 3) {
            IAtomType type2 = this.getAtomType("Ga");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ga.3plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveGermanium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (!this.isCharged(atom) && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedBondsCount(atom) <= 4 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ge"))) {
            return type;
        }
        if (atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ge.3"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveSelenium(IAtomContainer atomContainer, IAtom atom, List<IBond> connectedBonds) throws CDKException {
        if ("Se".equals(atom.getSymbol())) {
            IAtomType type;
            if (connectedBonds == null) {
                connectedBonds = atomContainer.getConnectedBondsList(atom);
            }
            int doublebondcount = this.countAttachedDoubleBonds(connectedBonds, atom);
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
                IAtomType type2;
                if (atomContainer.getConnectedBondsCount(atom) == 0) {
                    if (atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() == 0) {
                        IAtomType type3 = this.getAtomType("Se.2");
                        if (this.isAcceptable(atom, atomContainer, type3, connectedBonds)) {
                            return type3;
                        }
                    } else {
                        IAtomType type4 = this.getAtomType("Se.3");
                        if (this.isAcceptable(atom, atomContainer, type4, connectedBonds)) {
                            return type4;
                        }
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) == 1) {
                    IAtomType type5;
                    if (doublebondcount == 1) {
                        IAtomType type6 = this.getAtomType("Se.1");
                        if (this.isAcceptable(atom, atomContainer, type6, connectedBonds)) {
                            return type6;
                        }
                    } else if (doublebondcount == 0 && this.isAcceptable(atom, atomContainer, type5 = this.getAtomType("Se.3"), connectedBonds)) {
                        return type5;
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) == 2) {
                    IAtomType type7;
                    if (doublebondcount == 0) {
                        IAtomType type8 = this.getAtomType("Se.3");
                        if (this.isAcceptable(atom, atomContainer, type8, connectedBonds)) {
                            return type8;
                        }
                    } else if (doublebondcount == 2 && this.isAcceptable(atom, atomContainer, type7 = this.getAtomType("Se.sp2.2"), connectedBonds)) {
                        return type7;
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) == 3) {
                    IAtomType type9 = this.getAtomType("Se.sp3.3");
                    if (this.isAcceptable(atom, atomContainer, type9, connectedBonds)) {
                        return type9;
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) == 4) {
                    IAtomType type10;
                    if (doublebondcount == 2) {
                        IAtomType type11 = this.getAtomType("Se.sp3.4");
                        if (this.isAcceptable(atom, atomContainer, type11, connectedBonds)) {
                            return type11;
                        }
                    } else if (doublebondcount == 0 && this.isAcceptable(atom, atomContainer, type10 = this.getAtomType("Se.sp3d1.4"), connectedBonds)) {
                        return type10;
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) == 5 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Se.5"), connectedBonds)) {
                    return type2;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 4 && atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type12 = this.getAtomType("Se.4plus");
                if (this.isAcceptable(atom, atomContainer, type12, connectedBonds)) {
                    return type12;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && atomContainer.getConnectedBondsCount(atom) == 3) {
                IAtomType type13 = this.getAtomType("Se.plus.3");
                if (this.isAcceptable(atom, atomContainer, type13, connectedBonds)) {
                    return type13;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -2 && atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Se.2minus"), connectedBonds)) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveTellurium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (!this.isCharged(atom) && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedBondsCount(atom) <= 2) {
            IAtomType type2 = this.getAtomType("Te.3");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() == 4 && atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Te.4plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveBorons(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (atom.getFormalCharge() == -1 && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedBondsCount(atom) <= 4) {
            IAtomType type2 = this.getAtomType("B.minus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() == 3 && atomContainer.getConnectedBondsCount(atom) == 4) {
            IAtomType type3 = this.getAtomType("B.3plus");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) <= 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("B"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveBeryllium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() == -2 && atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE && atomContainer.getConnectedBondsCount(atom) <= 4) {
            IAtomType type2 = this.getAtomType("Be.2minus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Be.neutral"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveCarbonRadicals(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type = this.getAtomType("C.radical.planar");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) <= 3) {
            IAtomType type;
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (maxBondOrder == IBond.Order.SINGLE) {
                IAtomType type2 = this.getAtomType("C.radical.planar");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (maxBondOrder == IBond.Order.DOUBLE) {
                IAtomType type3 = this.getAtomType("C.radical.sp2");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (maxBondOrder == IBond.Order.TRIPLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.radical.sp1"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveCarbons(IAtomContainer atomContainer, IAtom atom, RingSearch searcher, List<IBond> connectedBonds) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return this.perceiveCarbonRadicals(atomContainer, atom);
        }
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        if (this.hasHybridization(atom) && !this.isCharged(atom)) {
            if (atom.getHybridization() == IAtomType.Hybridization.SP2) {
                IAtomType type = this.getAtomType("C.sp2");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP3) {
                IAtomType type = this.getAtomType("C.sp3");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP1) {
                IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                if (maxBondOrder == IBond.Order.TRIPLE) {
                    IAtomType type = this.getAtomType("C.sp");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                } else {
                    IAtomType type = this.getAtomType("C.allene");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                }
            }
        } else {
            if (this.isCharged(atom)) {
                if (atom.getFormalCharge() == 1) {
                    if (connectedBonds.isEmpty()) {
                        IAtomType type = this.getAtomType("C.plus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    } else {
                        IAtomType type;
                        IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                        if (maxBondOrder == IBond.Order.TRIPLE) {
                            IAtomType type2 = this.getAtomType("C.plus.sp1");
                            if (this.isAcceptable(atom, atomContainer, type2, connectedBonds)) {
                                return type2;
                            }
                        } else if (maxBondOrder == IBond.Order.DOUBLE) {
                            IAtomType type3 = this.getAtomType("C.plus.sp2");
                            if (this.isAcceptable(atom, atomContainer, type3, connectedBonds)) {
                                return type3;
                            }
                        } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.plus.planar"), connectedBonds)) {
                            return type;
                        }
                    }
                } else if (atom.getFormalCharge() == -1) {
                    IAtomType type;
                    IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                    if (maxBondOrder == IBond.Order.SINGLE && connectedBonds.size() <= 3) {
                        IAtomType type4;
                        if (this.bothNeighborsAreSp2(atom, atomContainer, connectedBonds) && this.isRingAtom(atom, atomContainer, searcher) && this.isAcceptable(atom, atomContainer, type4 = this.getAtomType("C.minus.planar"), connectedBonds)) {
                            return type4;
                        }
                        type4 = this.getAtomType("C.minus.sp3");
                        if (this.isAcceptable(atom, atomContainer, type4, connectedBonds)) {
                            return type4;
                        }
                    } else if (maxBondOrder == IBond.Order.DOUBLE && connectedBonds.size() <= 3) {
                        IAtomType type5 = this.getAtomType("C.minus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type5, connectedBonds)) {
                            return type5;
                        }
                    } else if (maxBondOrder == IBond.Order.TRIPLE && connectedBonds.size() <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.minus.sp1"), connectedBonds)) {
                        return type;
                    }
                }
                return null;
            }
            if (atom.getFlag(32)) {
                IAtomType type = this.getAtomType("C.sp2");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            } else if (this.hasOneOrMoreSingleOrDoubleBonds(connectedBonds)) {
                IAtomType type = this.getAtomType("C.sp2");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            } else {
                if (connectedBonds.size() > 4) {
                    return null;
                }
                IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                if (maxBondOrder == IBond.Order.QUADRUPLE) {
                    return null;
                }
                if (maxBondOrder == IBond.Order.TRIPLE) {
                    IAtomType type = this.getAtomType("C.sp");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                } else if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type;
                    int doubleBondCount = this.countAttachedDoubleBonds(connectedBonds, atom);
                    if (doubleBondCount == 2) {
                        IAtomType type6 = this.getAtomType("C.allene");
                        if (this.isAcceptable(atom, atomContainer, type6, connectedBonds)) {
                            return type6;
                        }
                    } else if (doubleBondCount == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.sp2"), connectedBonds)) {
                        return type;
                    }
                } else {
                    IAtomType type;
                    if (this.hasAromaticBond(connectedBonds) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.sp2"), connectedBonds)) {
                        return type;
                    }
                    type = this.getAtomType("C.sp3");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                }
            }
        }
        return null;
    }

    private IBond.Order getMaximumBondOrder(List<IBond> connectedBonds) {
        IBond.Order max = IBond.Order.SINGLE;
        for (IBond bond : connectedBonds) {
            if (bond.getOrder().numeric() <= max.numeric()) continue;
            max = bond.getOrder();
        }
        return max;
    }

    private boolean hasOneOrMoreSingleOrDoubleBonds(List<IBond> bonds) {
        for (IBond bond : bonds) {
            if (!bond.getFlag(4096)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOneSingleElectron(IAtomContainer atomContainer, IAtom atom) {
        if (atomContainer.getSingleElectronCount() == 0) {
            return false;
        }
        Iterator<ISingleElectron> singleElectrons = atomContainer.singleElectrons().iterator();
        while (singleElectrons.hasNext()) {
            if (!singleElectrons.next().contains(atom)) continue;
            return true;
        }
        return false;
    }

    private int countSingleElectrons(IAtomContainer atomContainer, IAtom atom) {
        if (atomContainer.getSingleElectronCount() == 0) {
            return 0;
        }
        Iterator<ISingleElectron> singleElectrons = atomContainer.singleElectrons().iterator();
        int count = 0;
        while (singleElectrons.hasNext()) {
            if (!singleElectrons.next().contains(atom)) continue;
            ++count;
        }
        return count;
    }

    private IAtomType perceiveOxygenRadicals(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (atom.getFormalCharge() == 0) {
            IAtomType type;
            if (atomContainer.getConnectedBondsCount(atom) <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.sp3.radical"))) {
                return type;
            }
        } else if (atom.getFormalCharge() == 1) {
            if (atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type = this.getAtomType("O.plus.radical");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) <= 2) {
                IAtomType type;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == IBond.Order.SINGLE) {
                    IAtomType type2 = this.getAtomType("O.plus.radical");
                    if (this.isAcceptable(atom, atomContainer, type2)) {
                        return type2;
                    }
                } else if (maxBondOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.plus.sp2.radical"))) {
                    return type;
                }
            }
        }
        return null;
    }

    private boolean isCharged(IAtom atom) {
        return atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() != 0;
    }

    private boolean hasHybridization(IAtom atom) {
        return atom.getHybridization() != CDKConstants.UNSET;
    }

    private IAtomType perceiveOxygens(IAtomContainer atomContainer, IAtom atom, RingSearch searcher, List<IBond> connectedBonds) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return this.perceiveOxygenRadicals(atomContainer, atom);
        }
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        if (this.hasHybridization(atom) && !this.isCharged(atom)) {
            IAtomType type;
            if (atom.getHybridization() == IAtomType.Hybridization.SP2) {
                IAtomType type2;
                int connectedAtomsCount = connectedBonds.size();
                if (connectedAtomsCount == 1) {
                    if (this.isCarboxylate(atomContainer, atom, connectedBonds)) {
                        IAtomType type3 = this.getAtomType("O.sp2.co2");
                        if (this.isAcceptable(atom, atomContainer, type3, connectedBonds)) {
                            return type3;
                        }
                    } else {
                        IAtomType type4 = this.getAtomType("O.sp2");
                        if (this.isAcceptable(atom, atomContainer, type4, connectedBonds)) {
                            return type4;
                        }
                    }
                } else if (connectedAtomsCount == 2 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("O.planar3"), connectedBonds)) {
                    return type2;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP3) {
                IAtomType type5 = this.getAtomType("O.sp3");
                if (this.isAcceptable(atom, atomContainer, type5, connectedBonds)) {
                    return type5;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.PLANAR3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.planar3"), connectedBonds)) {
                return type;
            }
        } else {
            if (this.isCharged(atom)) {
                if (atom.getFormalCharge() == -1 && connectedBonds.size() <= 1) {
                    if (this.isCarboxylate(atomContainer, atom, connectedBonds)) {
                        IAtomType type = this.getAtomType("O.minus.co2");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    } else {
                        IAtomType type = this.getAtomType("O.minus");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    }
                } else if (atom.getFormalCharge() == -2 && connectedBonds.size() == 0) {
                    IAtomType type = this.getAtomType("O.minus2");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                } else if (atom.getFormalCharge() == 1) {
                    IAtomType type;
                    if (connectedBonds.size() == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.plus"), connectedBonds)) {
                        return type;
                    }
                    IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                    if (maxBondOrder == IBond.Order.DOUBLE) {
                        IAtomType type6 = this.getAtomType("O.plus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type6, connectedBonds)) {
                            return type6;
                        }
                    } else if (maxBondOrder == IBond.Order.TRIPLE) {
                        IAtomType type7 = this.getAtomType("O.plus.sp1");
                        if (this.isAcceptable(atom, atomContainer, type7, connectedBonds)) {
                            return type7;
                        }
                    } else {
                        IAtomType type8 = this.getAtomType("O.plus");
                        if (this.isAcceptable(atom, atomContainer, type8, connectedBonds)) {
                            return type8;
                        }
                    }
                }
                return null;
            }
            if (connectedBonds.size() > 2) {
                return null;
            }
            if (connectedBonds.size() == 0) {
                IAtomType type = this.getAtomType("O.sp3");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            } else {
                IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                if (maxBondOrder == IBond.Order.DOUBLE) {
                    if (this.isCarboxylate(atomContainer, atom, connectedBonds)) {
                        IAtomType type = this.getAtomType("O.sp2.co2");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    } else {
                        IAtomType type = this.getAtomType("O.sp2");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    }
                } else if (maxBondOrder == IBond.Order.SINGLE) {
                    int explicitHydrogens = this.countExplicitHydrogens(atom, connectedBonds);
                    int connectedHeavyAtoms = connectedBonds.size() - explicitHydrogens;
                    if (connectedHeavyAtoms == 2) {
                        IAtomType type;
                        if (this.bothNeighborsAreSp2(atom, atomContainer, connectedBonds) && this.isRingAtom(atom, atomContainer, searcher) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.planar3"), connectedBonds)) {
                            return type;
                        }
                        type = this.getAtomType("O.sp3");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    } else {
                        IAtomType type = this.getAtomType("O.sp3");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    }
                }
            }
        }
        return null;
    }

    private boolean isCarboxylate(IAtomContainer container, IAtom atom, List<IBond> connectedBonds) {
        if (connectedBonds.size() != 1) {
            return false;
        }
        IAtom carbon = connectedBonds.get(0).getOther(atom);
        if (!"C".equals(carbon.getSymbol())) {
            return false;
        }
        List<IBond> carbonBonds = container.getConnectedBondsList(carbon);
        if (carbonBonds.size() < 2) {
            return false;
        }
        int oxygenCount = 0;
        int singleBondedNegativeOxygenCount = 0;
        int doubleBondedOxygenCount = 0;
        for (IBond cBond : carbonBonds) {
            IAtom neighbor = cBond.getOther(carbon);
            if (!"O".equals(neighbor.getSymbol())) continue;
            ++oxygenCount;
            IBond.Order order = cBond.getOrder();
            Integer charge = neighbor.getFormalCharge();
            if (order == IBond.Order.SINGLE && charge != null && charge == -1) {
                ++singleBondedNegativeOxygenCount;
                continue;
            }
            if (order != IBond.Order.DOUBLE) continue;
            ++doubleBondedOxygenCount;
        }
        return oxygenCount == 2 && singleBondedNegativeOxygenCount == 1 && doubleBondedOxygenCount == 1;
    }

    private boolean atLeastTwoNeighborsAreSp2(IAtom atom, IAtomContainer atomContainer, List<IBond> connectedBonds) {
        int count = 0;
        for (IBond bond : connectedBonds) {
            if (bond.getOrder() == IBond.Order.DOUBLE || bond.isAromatic()) {
                ++count;
            } else {
                IAtom nextAtom = bond.getOther(atom);
                if (nextAtom.getHybridization() != CDKConstants.UNSET && nextAtom.getHybridization() == IAtomType.Hybridization.SP2) {
                    ++count;
                } else {
                    List<IBond> nextConnectBonds = atomContainer.getConnectedBondsList(nextAtom);
                    if (this.countAttachedDoubleBonds(nextConnectBonds, nextAtom) > 0) {
                        ++count;
                    }
                }
            }
            if (count < 2) continue;
            return true;
        }
        return false;
    }

    private boolean bothNeighborsAreSp2(IAtom atom, IAtomContainer atomContainer, List<IBond> connectedBonds) {
        return this.atLeastTwoNeighborsAreSp2(atom, atomContainer, connectedBonds);
    }

    private IAtomType perceiveNitrogenRadicals(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (atomContainer.getConnectedBondsCount(atom) >= 1 && atomContainer.getConnectedBondsCount(atom) <= 2) {
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                IAtomType type;
                if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type2 = this.getAtomType("N.plus.sp2.radical");
                    if (this.isAcceptable(atom, atomContainer, type2)) {
                        return type2;
                    }
                } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.plus.sp3.radical"))) {
                    return type;
                }
            } else if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
                IAtomType type;
                if (maxBondOrder == IBond.Order.SINGLE) {
                    IAtomType type3 = this.getAtomType("N.sp3.radical");
                    if (this.isAcceptable(atom, atomContainer, type3)) {
                        return type3;
                    }
                } else if (maxBondOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.sp2.radical"))) {
                    return type;
                }
            }
        } else {
            IAtomType type;
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.plus.sp3.radical"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveMolybdenum(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type;
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 4 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Mo.4"))) {
                return type;
            }
            IAtomType type1 = this.getAtomType("Mo.metallic");
            if (this.isAcceptable(atom, atomContainer, type1)) {
                return type1;
            }
        }
        return null;
    }

    private IAtomType perceiveNitrogens(IAtomContainer atomContainer, IAtom atom, RingSearch searcher, List<IBond> connectedBonds) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return this.perceiveNitrogenRadicals(atomContainer, atom);
        }
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        if (this.hasHybridization(atom) && !this.isCharged(atom)) {
            if (atom.getHybridization() == IAtomType.Hybridization.SP1) {
                int neighborCount = connectedBonds.size();
                if (neighborCount > 1) {
                    IAtomType type = this.getAtomType("N.sp1.2");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                } else {
                    IAtomType type = this.getAtomType("N.sp1");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP2) {
                IAtomType type;
                IAtomType type2;
                if (this.isAmide(atom, atomContainer, connectedBonds) ? this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("N.amide"), connectedBonds) : this.isThioAmide(atom, atomContainer, connectedBonds) && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("N.thioamide"), connectedBonds)) {
                    return type2;
                }
                int neighborCount = connectedBonds.size();
                if (neighborCount == 4 && IBond.Order.DOUBLE == this.getMaximumBondOrder(connectedBonds)) {
                    type = this.getAtomType("N.oxide");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                } else if (neighborCount > 1 && this.bothNeighborsAreSp2(atom, atomContainer, connectedBonds) && this.isRingAtom(atom, atomContainer, searcher)) {
                    IBond.Order maxOrder;
                    if (neighborCount == 3) {
                        IAtomType type3;
                        maxOrder = this.getMaximumBondOrder(connectedBonds);
                        if (maxOrder == IBond.Order.DOUBLE) {
                            IAtomType type4 = this.getAtomType("N.sp2.3");
                            if (this.isAcceptable(atom, atomContainer, type4, connectedBonds)) {
                                return type4;
                            }
                        } else if (maxOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("N.planar3"), connectedBonds)) {
                            return type3;
                        }
                    } else if (neighborCount == 2) {
                        IAtomType type5;
                        maxOrder = this.getMaximumBondOrder(connectedBonds);
                        if (maxOrder == IBond.Order.SINGLE) {
                            if (atom.getImplicitHydrogenCount() != CDKConstants.UNSET && atom.getImplicitHydrogenCount() == 1) {
                                IAtomType type6 = this.getAtomType("N.planar3");
                                if (this.isAcceptable(atom, atomContainer, type6, connectedBonds)) {
                                    return type6;
                                }
                            } else {
                                IAtomType type7 = this.getAtomType("N.sp2");
                                if (this.isAcceptable(atom, atomContainer, type7, connectedBonds)) {
                                    return type7;
                                }
                            }
                        } else if (maxOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type5 = this.getAtomType("N.sp2"), connectedBonds)) {
                            return type5;
                        }
                    }
                }
                if (this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.sp2"), connectedBonds)) {
                    return type;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP3) {
                IAtomType type = this.getAtomType("N.sp3");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.PLANAR3) {
                IAtomType type;
                IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                if (connectedBonds.size() == 3 && maxBondOrder == IBond.Order.DOUBLE && this.countAttachedDoubleBonds(connectedBonds, atom, "O") == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.nitro"), connectedBonds)) {
                    return type;
                }
                type = this.getAtomType("N.planar3");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            }
        } else if (this.isCharged(atom)) {
            if (atom.getFormalCharge() == 1) {
                IAtomType type;
                IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                if (maxBondOrder == IBond.Order.SINGLE || connectedBonds.size() == 0) {
                    IAtomType type8;
                    if (atom.getHybridization() == IAtomType.Hybridization.SP2 && this.isAcceptable(atom, atomContainer, type8 = this.getAtomType("N.plus.sp2"), connectedBonds)) {
                        return type8;
                    }
                    type8 = this.getAtomType("N.plus");
                    if (this.isAcceptable(atom, atomContainer, type8, connectedBonds)) {
                        return type8;
                    }
                } else if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type9;
                    int doubleBonds = this.countAttachedDoubleBonds(connectedBonds, atom);
                    if (doubleBonds == 1) {
                        IAtomType type10 = this.getAtomType("N.plus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type10, connectedBonds)) {
                            return type10;
                        }
                    } else if (doubleBonds == 2 && this.isAcceptable(atom, atomContainer, type9 = this.getAtomType("N.plus.sp1"), connectedBonds)) {
                        return type9;
                    }
                } else if (maxBondOrder == IBond.Order.TRIPLE && connectedBonds.size() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.plus.sp1"), connectedBonds)) {
                    return type;
                }
            } else if (atom.getFormalCharge() == -1) {
                IAtomType type;
                IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                if (maxBondOrder == IBond.Order.SINGLE) {
                    IAtomType type11;
                    if (connectedBonds.size() >= 2 && this.bothNeighborsAreSp2(atom, atomContainer, connectedBonds) && this.isRingAtom(atom, atomContainer, searcher)) {
                        IAtomType type12 = this.getAtomType("N.minus.planar3");
                        if (this.isAcceptable(atom, atomContainer, type12, connectedBonds)) {
                            return type12;
                        }
                    } else if (connectedBonds.size() <= 2 && this.isAcceptable(atom, atomContainer, type11 = this.getAtomType("N.minus.sp3"), connectedBonds)) {
                        return type11;
                    }
                } else if (maxBondOrder == IBond.Order.DOUBLE && connectedBonds.size() <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.minus.sp2"), connectedBonds)) {
                    return type;
                }
            }
        } else {
            if (connectedBonds.size() > 3) {
                IAtomType type;
                if (connectedBonds.size() == 4 && this.countAttachedDoubleBonds(connectedBonds, atom) == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.oxide"), connectedBonds)) {
                    return type;
                }
                return null;
            }
            if (connectedBonds.size() == 0) {
                IAtomType type = this.getAtomType("N.sp3");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            } else if (this.hasOneOrMoreSingleOrDoubleBonds(connectedBonds)) {
                IAtomType type;
                int connectedAtoms = connectedBonds.size() + (atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount());
                if (connectedAtoms == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.planar3"), connectedBonds)) {
                    return type;
                }
                type = this.getAtomType("N.sp2");
                if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                    return type;
                }
            } else {
                IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                if (maxBondOrder == IBond.Order.SINGLE) {
                    IAtomType type;
                    IAtomType type13;
                    if (this.isAmide(atom, atomContainer, connectedBonds) ? this.isAcceptable(atom, atomContainer, type13 = this.getAtomType("N.amide"), connectedBonds) : this.isThioAmide(atom, atomContainer, connectedBonds) && this.isAcceptable(atom, atomContainer, type13 = this.getAtomType("N.thioamide"), connectedBonds)) {
                        return type13;
                    }
                    List<IBond> heavy = this.heavyBonds(connectedBonds);
                    int expHCount = heavy.size() - connectedBonds.size();
                    if (heavy.size() == 2) {
                        if (heavy.get(0).getFlag(32) && heavy.get(1).getFlag(32)) {
                            IAtomType type14;
                            int hCount;
                            int n = hCount = atom.getImplicitHydrogenCount() != null ? atom.getImplicitHydrogenCount() + expHCount : expHCount;
                            if (hCount == 0) {
                                if (maxBondOrder == IBond.Order.SINGLE && this.isSingleHeteroAtom(atom, atomContainer)) {
                                    IAtomType type15 = this.getAtomType("N.planar3");
                                    if (this.isAcceptable(atom, atomContainer, type15, connectedBonds)) {
                                        return type15;
                                    }
                                } else {
                                    IAtomType type16 = this.getAtomType("N.sp2");
                                    if (this.isAcceptable(atom, atomContainer, type16, connectedBonds)) {
                                        return type16;
                                    }
                                }
                            } else if (hCount == 1 && this.isAcceptable(atom, atomContainer, type14 = this.getAtomType("N.planar3"), connectedBonds)) {
                                return type14;
                            }
                        } else if (this.bothNeighborsAreSp2(atom, atomContainer, connectedBonds) && this.isRingAtom(atom, atomContainer, searcher)) {
                            IAtomType type17 = this.getAtomType("N.planar3");
                            if (this.isAcceptable(atom, atomContainer, type17, connectedBonds)) {
                                return type17;
                            }
                        } else {
                            IAtomType type18 = this.getAtomType("N.sp3");
                            if (this.isAcceptable(atom, atomContainer, type18, connectedBonds)) {
                                return type18;
                            }
                        }
                    } else if (heavy.size() == 3) {
                        IAtomType type19;
                        if (this.bothNeighborsAreSp2(atom, atomContainer, connectedBonds) && this.isRingAtom(atom, atomContainer, searcher) && this.isAcceptable(atom, atomContainer, type19 = this.getAtomType("N.planar3"), connectedBonds)) {
                            return type19;
                        }
                        type19 = this.getAtomType("N.sp3");
                        if (this.isAcceptable(atom, atomContainer, type19, connectedBonds)) {
                            return type19;
                        }
                    } else if (heavy.size() == 1) {
                        IAtomType type20 = this.getAtomType("N.sp3");
                        if (this.isAcceptable(atom, atomContainer, type20, connectedBonds)) {
                            return type20;
                        }
                    } else if (heavy.size() == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.sp3"), connectedBonds)) {
                        return type;
                    }
                } else if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type;
                    if (connectedBonds.size() == 3 && this.countAttachedDoubleBonds(connectedBonds, atom, "O") == 2 ? this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.nitro"), connectedBonds) : connectedBonds.size() == 3 && this.countAttachedDoubleBonds(connectedBonds, atom) > 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.sp2.3"), connectedBonds)) {
                        return type;
                    }
                    type = this.getAtomType("N.sp2");
                    if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                        return type;
                    }
                } else if (maxBondOrder == IBond.Order.TRIPLE) {
                    int neighborCount = connectedBonds.size();
                    if (neighborCount > 1) {
                        IAtomType type = this.getAtomType("N.sp1.2");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    } else {
                        IAtomType type = this.getAtomType("N.sp1");
                        if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                            return type;
                        }
                    }
                }
            }
        }
        return null;
    }

    private boolean isSingleHeteroAtom(IAtom atom, IAtomContainer container) {
        List<IAtom> connected = container.getConnectedAtomsList(atom);
        for (IAtom atom1 : connected) {
            boolean aromatic = container.getBond(atom, atom1).isAromatic();
            if (!aromatic) continue;
            if (!"C".equals(atom1.getSymbol())) {
                return false;
            }
            for (IAtom atom2 : container.getConnectedAtomsList(atom1)) {
                if (atom2.equals(atom) || !container.getBond(atom1, atom2).isAromatic() || "C".equals(atom2.getSymbol())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isRingAtom(IAtom atom, IAtomContainer atomContainer, RingSearch searcher) {
        if (searcher == null) {
            searcher = new RingSearch(atomContainer);
        }
        return searcher.cyclic(atom);
    }

    private boolean isAmide(IAtom atom, IAtomContainer atomContainer, List<IBond> connectedBonds) {
        if (connectedBonds.size() < 1) {
            return false;
        }
        for (IBond bond : connectedBonds) {
            IAtom neighbor = bond.getOther(atom);
            if (!neighbor.getSymbol().equals("C") || this.countAttachedDoubleBonds(atomContainer.getConnectedBondsList(neighbor), neighbor, "O") != 1) continue;
            return true;
        }
        return false;
    }

    private boolean isThioAmide(IAtom atom, IAtomContainer atomContainer, List<IBond> connectedBonds) {
        if (connectedBonds.size() < 1) {
            return false;
        }
        for (IBond bond : connectedBonds) {
            IAtom neighbor = bond.getOther(atom);
            if (!neighbor.getSymbol().equals("C") || this.countAttachedDoubleBonds(atomContainer.getConnectedBondsList(neighbor), neighbor, "S") != 1) continue;
            return true;
        }
        return false;
    }

    private int countExplicitHydrogens(IAtom atom, List<IBond> connectedBonds) {
        int count = 0;
        for (IBond bond : connectedBonds) {
            IAtom aAtom = bond.getOther(atom);
            if (!aAtom.getSymbol().equals("H")) continue;
            ++count;
        }
        return count;
    }

    private List<IBond> heavyBonds(List<IBond> bonds) {
        ArrayList<IBond> heavy = new ArrayList<IBond>(bonds.size());
        for (IBond bond : bonds) {
            if (bond.getBegin().getSymbol().equals("H") && bond.getEnd().getSymbol().equals("H")) continue;
            heavy.add(bond);
        }
        return heavy;
    }

    private IAtomType perceiveIron(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if ("Fe".equals(atom.getSymbol())) {
            IAtomType type4;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != null && atom.getFormalCharge() == 0) {
                IAtomType type9;
                int neighbors = atomContainer.getConnectedBondsCount(atom);
                if (neighbors == 0) {
                    IAtomType type = this.getAtomType("Fe.metallic");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                } else if (neighbors == 2) {
                    IAtomType type5 = this.getAtomType("Fe.2");
                    if (this.isAcceptable(atom, atomContainer, type5)) {
                        return type5;
                    }
                } else if (neighbors == 3) {
                    IAtomType type6 = this.getAtomType("Fe.3");
                    if (this.isAcceptable(atom, atomContainer, type6)) {
                        return type6;
                    }
                } else if (neighbors == 4) {
                    IAtomType type7 = this.getAtomType("Fe.4");
                    if (this.isAcceptable(atom, atomContainer, type7)) {
                        return type7;
                    }
                } else if (neighbors == 5) {
                    IAtomType type8 = this.getAtomType("Fe.5");
                    if (this.isAcceptable(atom, atomContainer, type8)) {
                        return type8;
                    }
                } else if (neighbors == 6 && this.isAcceptable(atom, atomContainer, type9 = this.getAtomType("Fe.6"))) {
                    return type9;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 2) {
                IAtomType type;
                int neighbors = atomContainer.getConnectedBondsCount(atom);
                if (neighbors <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Fe.2plus"))) {
                    return type;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 1) {
                IAtomType type0;
                int neighbors = atomContainer.getConnectedBondsCount(atom);
                if (neighbors == 2 && this.isAcceptable(atom, atomContainer, type0 = this.getAtomType("Fe.plus"))) {
                    return type0;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 3) {
                IAtomType type1 = this.getAtomType("Fe.3plus");
                if (this.isAcceptable(atom, atomContainer, type1)) {
                    return type1;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == -2) {
                IAtomType type2 = this.getAtomType("Fe.2minus");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == -3) {
                IAtomType type3 = this.getAtomType("Fe.3minus");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == -4 && this.isAcceptable(atom, atomContainer, type4 = this.getAtomType("Fe.4minus"))) {
                return type4;
            }
        }
        return null;
    }

    private IAtomType perceiveMercury(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if ("Hg".equals(atom.getSymbol())) {
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != null && atom.getFormalCharge() == -1) {
                IAtomType type = this.getAtomType("Hg.minus");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 2) {
                IAtomType type = this.getAtomType("Hg.2plus");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 1) {
                IAtomType type;
                int neighbors = atomContainer.getConnectedBondsCount(atom);
                if (neighbors <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Hg.plus"))) {
                    return type;
                }
            } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 0) {
                IAtomType type;
                int neighbors = atomContainer.getConnectedBondsCount(atom);
                if (neighbors == 2) {
                    IAtomType type2 = this.getAtomType("Hg.2");
                    if (this.isAcceptable(atom, atomContainer, type2)) {
                        return type2;
                    }
                } else if (neighbors == 1) {
                    IAtomType type3 = this.getAtomType("Hg.1");
                    if (this.isAcceptable(atom, atomContainer, type3)) {
                        return type3;
                    }
                } else if (neighbors == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Hg.metallic"))) {
                    return type;
                }
            }
        }
        return null;
    }

    private IAtomType perceiveSulphurs(IAtomContainer atomContainer, IAtom atom, RingSearch searcher, List<IBond> connectedBonds) throws CDKException {
        IAtomType type;
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
        int neighborcount = connectedBonds.size();
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getHybridization() != CDKConstants.UNSET && atom.getHybridization() == IAtomType.Hybridization.SP2 && atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
            if (neighborcount == 3) {
                IAtomType type2 = this.getAtomType("S.inyl.charged");
                if (this.isAcceptable(atom, atomContainer, type2, connectedBonds)) {
                    return type2;
                }
            } else {
                IAtomType type3 = this.getAtomType("S.plus");
                if (this.isAcceptable(atom, atomContainer, type3, connectedBonds)) {
                    return type3;
                }
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() != 0) {
            IAtomType type4;
            if (atom.getFormalCharge() == -1 && neighborcount == 1) {
                IAtomType type5 = this.getAtomType("S.minus");
                if (this.isAcceptable(atom, atomContainer, type5, connectedBonds)) {
                    return type5;
                }
            } else if (atom.getFormalCharge() == 1 && neighborcount == 2) {
                IAtomType type6 = this.getAtomType("S.plus");
                if (this.isAcceptable(atom, atomContainer, type6, connectedBonds)) {
                    return type6;
                }
            } else if (atom.getFormalCharge() == 1 && neighborcount == 3) {
                IAtomType type7 = this.getAtomType("S.inyl.charged");
                if (this.isAcceptable(atom, atomContainer, type7, connectedBonds)) {
                    return type7;
                }
            } else if (atom.getFormalCharge() == 2 && neighborcount == 4) {
                IAtomType type8 = this.getAtomType("S.onyl.charged");
                if (this.isAcceptable(atom, atomContainer, type8, connectedBonds)) {
                    return type8;
                }
            } else if (atom.getFormalCharge() == -2 && neighborcount == 0 && this.isAcceptable(atom, atomContainer, type4 = this.getAtomType("S.2minus"), connectedBonds)) {
                return type4;
            }
        } else if (neighborcount == 0) {
            IAtomType type9;
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && this.isAcceptable(atom, atomContainer, type9 = this.getAtomType("S.3"), connectedBonds)) {
                return type9;
            }
        } else if (neighborcount == 1) {
            IAtomType type10;
            if (connectedBonds.get(0).getOrder() == IBond.Order.DOUBLE) {
                IAtomType type11 = this.getAtomType("S.2");
                if (this.isAcceptable(atom, atomContainer, type11, connectedBonds)) {
                    return type11;
                }
            } else if (connectedBonds.get(0).getOrder() == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type10 = this.getAtomType("S.3"), connectedBonds)) {
                return type10;
            }
        } else if (neighborcount == 2) {
            IAtomType type12;
            if (this.bothNeighborsAreSp2(atom, atomContainer, connectedBonds) && this.isRingAtom(atom, atomContainer, searcher)) {
                if (this.countAttachedDoubleBonds(connectedBonds, atom) == 2) {
                    IAtomType type13 = this.getAtomType("S.inyl.2");
                    if (this.isAcceptable(atom, atomContainer, type13, connectedBonds)) {
                        return type13;
                    }
                } else {
                    IAtomType type14 = this.getAtomType("S.planar3");
                    if (this.isAcceptable(atom, atomContainer, type14, connectedBonds)) {
                        return type14;
                    }
                }
            } else if (this.countAttachedDoubleBonds(connectedBonds, atom, "O") == 2) {
                IAtomType type15 = this.getAtomType("S.oxide");
                if (this.isAcceptable(atom, atomContainer, type15, connectedBonds)) {
                    return type15;
                }
            } else if (this.countAttachedDoubleBonds(connectedBonds, atom) == 2) {
                IAtomType type16 = this.getAtomType("S.inyl.2");
                if (this.isAcceptable(atom, atomContainer, type16, connectedBonds)) {
                    return type16;
                }
            } else if (this.countAttachedDoubleBonds(connectedBonds, atom) <= 1) {
                IAtomType type17 = this.getAtomType("S.3");
                if (this.isAcceptable(atom, atomContainer, type17, connectedBonds)) {
                    return type17;
                }
            } else if (this.countAttachedDoubleBonds(connectedBonds, atom) == 0 && this.countAttachedSingleBonds(connectedBonds, atom) == 2 && this.isAcceptable(atom, atomContainer, type12 = this.getAtomType("S.octahedral"), connectedBonds)) {
                return type12;
            }
        } else if (neighborcount == 3) {
            IAtomType type18;
            int doubleBondedAtoms = this.countAttachedDoubleBonds(connectedBonds, atom);
            if (doubleBondedAtoms == 1) {
                IAtomType type19 = this.getAtomType("S.inyl");
                if (this.isAcceptable(atom, atomContainer, type19, connectedBonds)) {
                    return type19;
                }
            } else if (doubleBondedAtoms == 3) {
                IAtomType type20 = this.getAtomType("S.trioxide");
                if (this.isAcceptable(atom, atomContainer, type20, connectedBonds)) {
                    return type20;
                }
            } else if (doubleBondedAtoms == 0 && this.isAcceptable(atom, atomContainer, type18 = this.getAtomType("S.anyl"), connectedBonds)) {
                return type18;
            }
        } else if (neighborcount == 4) {
            IAtomType type21;
            int doubleBondedOxygens = this.countAttachedDoubleBonds(connectedBonds, atom, "O");
            int doubleBondedNitrogens = this.countAttachedDoubleBonds(connectedBonds, atom, "N");
            int doubleBondedSulphurs = this.countAttachedDoubleBonds(connectedBonds, atom, "S");
            int countAttachedDoubleBonds = this.countAttachedDoubleBonds(connectedBonds, atom);
            if (doubleBondedOxygens + doubleBondedNitrogens == 2) {
                IAtomType type22 = this.getAtomType("S.onyl");
                if (this.isAcceptable(atom, atomContainer, type22, connectedBonds)) {
                    return type22;
                }
            } else if (doubleBondedSulphurs == 1 && doubleBondedOxygens == 1) {
                IAtomType type23 = this.getAtomType("S.thionyl");
                if (this.isAcceptable(atom, atomContainer, type23, connectedBonds)) {
                    return type23;
                }
            } else if (maxBondOrder == IBond.Order.SINGLE) {
                IAtomType type24 = this.getAtomType("S.anyl");
                if (this.isAcceptable(atom, atomContainer, type24, connectedBonds)) {
                    return type24;
                }
            } else if (doubleBondedOxygens == 1 && countAttachedDoubleBonds == 1) {
                IAtomType type25 = this.getAtomType("S.sp3d1");
                if (this.isAcceptable(atom, atomContainer, type25, connectedBonds)) {
                    return type25;
                }
            } else if (countAttachedDoubleBonds == 2 && maxBondOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type21 = this.getAtomType("S.sp3.4"), connectedBonds)) {
                return type21;
            }
        } else if (neighborcount == 5) {
            IAtomType type26;
            if (maxBondOrder == IBond.Order.DOUBLE) {
                IAtomType type27 = this.getAtomType("S.sp3d1");
                if (this.isAcceptable(atom, atomContainer, type27, connectedBonds)) {
                    return type27;
                }
            } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type26 = this.getAtomType("S.octahedral"), connectedBonds)) {
                return type26;
            }
        } else if (neighborcount == 6 && maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("S.octahedral"), connectedBonds)) {
            return type;
        }
        return null;
    }

    private IAtomType perceivePhosphors(IAtomContainer atomContainer, IAtom atom, List<IBond> connectedBonds) throws CDKException {
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        int neighborcount = connectedBonds.size();
        IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
        if (this.countSingleElectrons(atomContainer, atom) == 3) {
            IAtomType type = this.getAtomType("P.se.3");
            if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                return type;
            }
        } else {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (neighborcount == 0) {
                IAtomType type2;
                if ((atom.getFormalCharge() == null || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("P.ine"), connectedBonds)) {
                    return type2;
                }
            } else if (neighborcount == 1) {
                IAtomType type3;
                if ((atom.getFormalCharge() == null || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("P.ide"), connectedBonds)) {
                    return type3;
                }
            } else if (neighborcount == 3) {
                int doubleBonds = this.countAttachedDoubleBonds(connectedBonds, atom);
                if (atom.getFormalCharge() != null && atom.getFormalCharge() == 1) {
                    IAtomType type4 = this.getAtomType("P.anium");
                    if (this.isAcceptable(atom, atomContainer, type4, connectedBonds)) {
                        return type4;
                    }
                } else if (doubleBonds == 1) {
                    IAtomType type5 = this.getAtomType("P.ate");
                    if (this.isAcceptable(atom, atomContainer, type5, connectedBonds)) {
                        return type5;
                    }
                } else {
                    IAtomType type6 = this.getAtomType("P.ine");
                    if (this.isAcceptable(atom, atomContainer, type6, connectedBonds)) {
                        return type6;
                    }
                }
            } else if (neighborcount == 2) {
                IAtomType type7;
                if (maxBondOrder == IBond.Order.DOUBLE) {
                    if (atom.getFormalCharge() != null && atom.getFormalCharge() == 1) {
                        IAtomType type8 = this.getAtomType("P.sp1.plus");
                        if (this.isAcceptable(atom, atomContainer, type8, connectedBonds)) {
                            return type8;
                        }
                    } else {
                        IAtomType type9 = this.getAtomType("P.irane");
                        if (this.isAcceptable(atom, atomContainer, type9, connectedBonds)) {
                            return type9;
                        }
                    }
                } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type7 = this.getAtomType("P.ine"), connectedBonds)) {
                    return type7;
                }
            } else if (neighborcount == 4) {
                IAtomType type10;
                int doubleBonds = this.countAttachedDoubleBonds(connectedBonds, atom);
                if (atom.getFormalCharge() == 1 && doubleBonds == 0) {
                    IAtomType type11 = this.getAtomType("P.ate.charged");
                    if (this.isAcceptable(atom, atomContainer, type11, connectedBonds)) {
                        return type11;
                    }
                } else if (doubleBonds == 1 && this.isAcceptable(atom, atomContainer, type10 = this.getAtomType("P.ate"), connectedBonds)) {
                    return type10;
                }
            } else if (neighborcount == 5 && (atom.getFormalCharge() == null || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("P.ane"), connectedBonds)) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveHydrogens(IAtomContainer atomContainer, IAtom atom, List<IBond> connectedBonds) throws CDKException {
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        int neighborcount = connectedBonds.size();
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            IAtomType type;
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && neighborcount == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("H.radical"), connectedBonds)) {
                return type;
            }
            return null;
        }
        if (neighborcount == 2) {
            return null;
        }
        if (neighborcount == 1) {
            IAtomType type;
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("H"), connectedBonds)) {
                return type;
            }
        } else if (neighborcount == 0) {
            IAtomType type;
            if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
                IAtomType type2 = this.getAtomType("H");
                if (this.isAcceptable(atom, atomContainer, type2, connectedBonds)) {
                    return type2;
                }
            } else if (atom.getFormalCharge() == 1) {
                IAtomType type3 = this.getAtomType("H.plus");
                if (this.isAcceptable(atom, atomContainer, type3, connectedBonds)) {
                    return type3;
                }
            } else if (atom.getFormalCharge() == -1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("H.minus"), connectedBonds)) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveLithium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        int neighborcount = atomContainer.getConnectedBondsCount(atom);
        if (neighborcount == 1) {
            IAtomType type;
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Li"))) {
                return type;
            }
        } else if (neighborcount == 0) {
            IAtomType type;
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Li.neutral"))) {
                return type;
            }
            if (atom.getFormalCharge() == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Li.plus"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveHalogens(IAtomContainer atomContainer, IAtom atom, List<IBond> connectedBonds) throws CDKException {
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        if ("F".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                IAtomType type2;
                IBond.Order maxBondOrder;
                if (connectedBonds.size() == 0) {
                    IAtomType type3;
                    if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                        IAtomType type4 = this.getAtomType("F.plus.radical");
                        if (this.isAcceptable(atom, atomContainer, type4, connectedBonds)) {
                            return type4;
                        }
                    } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("F.radical"), connectedBonds)) {
                        return type3;
                    }
                } else if (connectedBonds.size() <= 1 && (maxBondOrder = this.getMaximumBondOrder(connectedBonds)) == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("F.plus.radical"), connectedBonds)) {
                    return type2;
                }
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() != 0) {
                if (atom.getFormalCharge() == -1) {
                    IAtomType type5 = this.getAtomType("F.minus");
                    if (this.isAcceptable(atom, atomContainer, type5)) {
                        return type5;
                    }
                } else if (atom.getFormalCharge() == 1) {
                    IAtomType type6;
                    IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                    if (maxBondOrder == IBond.Order.DOUBLE) {
                        IAtomType type7 = this.getAtomType("F.plus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type7, connectedBonds)) {
                            return type7;
                        }
                    } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type6 = this.getAtomType("F.plus.sp3"), connectedBonds)) {
                        return type6;
                    }
                }
            } else if ((connectedBonds.size() == 1 || connectedBonds.size() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("F"), connectedBonds)) {
                return type;
            }
        } else if ("I".equals(atom.getSymbol())) {
            return this.perceiveIodine(atomContainer, atom, connectedBonds);
        }
        return null;
    }

    private IAtomType perceiveArsenic(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && atomContainer.getConnectedBondsCount(atom) <= 4) {
            IAtomType type2 = this.getAtomType("As.plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type3;
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 4 && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("As.5"))) {
                return type3;
            }
            if (neighbors == 2 && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("As.2"))) {
                return type3;
            }
            type3 = this.getAtomType("As");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3) {
            IAtomType type4 = this.getAtomType("As.3plus");
            if (this.isAcceptable(atom, atomContainer, type4)) {
                return type4;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("As.minus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveThorium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if ("Th".equals(atom.getSymbol()) && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Th"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveRubidium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
            IAtomType type2 = this.getAtomType("Rb.plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Rb.neutral"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveCommonSalts(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if ("Mg".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Mg.2plus"))) {
                return type;
            }
        } else if ("Co".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
                IAtomType type2 = this.getAtomType("Co.2plus");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3) {
                IAtomType type3 = this.getAtomType("Co.3plus");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Co.metallic"))) {
                return type;
            }
        } else if ("W".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("W.metallic"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveCopper(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type02;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
            IAtomType type = this.getAtomType("Cu.2plus");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 1) {
                IAtomType type = this.getAtomType("Cu.1");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IAtomType type01 = this.getAtomType("Cu.metallic");
                if (this.isAcceptable(atom, atomContainer, type01)) {
                    return type01;
                }
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && this.isAcceptable(atom, atomContainer, type02 = this.getAtomType("Cu.plus"))) {
            return type02;
        }
        return null;
    }

    private IAtomType perceiveBarium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ba.2plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveAluminium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3) {
            IAtomType type2;
            int connectedBondsCount = atomContainer.getConnectedBondsCount(atom);
            if (connectedBondsCount == 0 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Al.3plus"))) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 3) {
            IAtomType type3 = this.getAtomType("Al");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && atomContainer.getConnectedBondsCount(atom) == 6 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Al.3minus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveZinc(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atomContainer.getConnectedBondsCount(atom) == 0 && atom.getFormalCharge() != null && atom.getFormalCharge() == 0) {
            IAtomType type2 = this.getAtomType("Zn.metallic");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) == 0 && atom.getFormalCharge() != null && atom.getFormalCharge() == 2) {
            IAtomType type3 = this.getAtomType("Zn.2plus");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) == 1 && atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type4 = this.getAtomType("Zn.1");
            if (this.isAcceptable(atom, atomContainer, type4)) {
                return type4;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) == 2 && atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Zn"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveChromium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 6) {
            IAtomType type2 = this.getAtomType("Cr");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 4) {
            IAtomType type3 = this.getAtomType("Cr.4");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 6 && atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type4 = this.getAtomType("Cr.6plus");
            if (this.isAcceptable(atom, atomContainer, type4)) {
                return type4;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type5 = this.getAtomType("Cr.neutral");
            if (this.isAcceptable(atom, atomContainer, type5)) {
                return type5;
            }
        } else if ("Cr".equals(atom.getSymbol()) && atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3 && atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cr.3plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveOrganometallicCenters(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if ("Po".equals(atom.getSymbol())) {
            IAtomType type2;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atomContainer.getConnectedBondsCount(atom) == 2 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Po"))) {
                return type2;
            }
        } else if ("Sn".equals(atom.getSymbol())) {
            IAtomType type3;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) <= 4 && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("Sn.sp3"))) {
                return type3;
            }
        } else if ("Sc".equals(atom.getSymbol()) && atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && atomContainer.getConnectedBondsCount(atom) == 6 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Sc.3minus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveNickel(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
            IAtomType type2 = this.getAtomType("Ni.2plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 2) {
            IAtomType type3 = this.getAtomType("Ni");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type4 = this.getAtomType("Ni.metallic");
            if (this.isAcceptable(atom, atomContainer, type4)) {
                return type4;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && atomContainer.getConnectedBondsCount(atom) == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ni.plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveNobelGases(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if ("He".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("He"))) {
                return type;
            }
        } else if ("Ne".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ne"))) {
                return type;
            }
        } else if ("Ar".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ar"))) {
                return type;
            }
        } else if ("Kr".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Kr"))) {
                return type;
            }
        } else if ("Xe".equals(atom.getSymbol())) {
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
                if (atomContainer.getConnectedBondsCount(atom) == 0) {
                    IAtomType type = this.getAtomType("Xe");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                } else {
                    IAtomType type = this.getAtomType("Xe.3");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                }
            }
        } else if ("Rn".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Rn"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveSilicon(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type2;
            if (atomContainer.getConnectedBondsCount(atom) == 2) {
                IAtomType type3 = this.getAtomType("Si.2");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) == 3) {
                IAtomType type4 = this.getAtomType("Si.3");
                if (this.isAcceptable(atom, atomContainer, type4)) {
                    return type4;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) == 4 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Si.sp3"))) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Si.2minus.6"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveManganese(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() == 0) {
            IAtomType type03;
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 2) {
                IAtomType type02 = this.getAtomType("Mn.2");
                if (this.isAcceptable(atom, atomContainer, type02)) {
                    return type02;
                }
            } else if (neighbors == 0 && this.isAcceptable(atom, atomContainer, type03 = this.getAtomType("Mn.metallic"))) {
                return type03;
            }
        } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 2) {
            IAtomType type2 = this.getAtomType("Mn.2plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Mn.3plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveSodium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
            IAtomType type2 = this.getAtomType("Na.plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && atomContainer.getConnectedBondsCount(atom) == 1) {
            IAtomType type3 = this.getAtomType("Na");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Na.neutral"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveIodine(IAtomContainer atomContainer, IAtom atom, List<IBond> connectedBonds) throws CDKException {
        IAtomType type;
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            IAtomType type2;
            IBond.Order maxBondOrder;
            if (connectedBonds.size() == 0) {
                IAtomType type3;
                if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                    IAtomType type4 = this.getAtomType("I.plus.radical");
                    if (this.isAcceptable(atom, atomContainer, type4, connectedBonds)) {
                        return type4;
                    }
                } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("I.radical"), connectedBonds)) {
                    return type3;
                }
            } else if (connectedBonds.size() <= 1 && (maxBondOrder = this.getMaximumBondOrder(connectedBonds)) == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("I.plus.radical"), connectedBonds)) {
                return type2;
            }
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() != 0) {
            if (atom.getFormalCharge() == -1) {
                if (connectedBonds.size() == 0) {
                    IAtomType type5 = this.getAtomType("I.minus");
                    if (this.isAcceptable(atom, atomContainer, type5, connectedBonds)) {
                        return type5;
                    }
                } else {
                    IAtomType type6 = this.getAtomType("I.minus.5");
                    if (this.isAcceptable(atom, atomContainer, type6, connectedBonds)) {
                        return type6;
                    }
                }
            } else if (atom.getFormalCharge() == 1) {
                IAtomType type7;
                IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
                if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type8 = this.getAtomType("I.plus.sp2");
                    if (this.isAcceptable(atom, atomContainer, type8, connectedBonds)) {
                        return type8;
                    }
                } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type7 = this.getAtomType("I.plus.sp3"), connectedBonds)) {
                    return type7;
                }
            }
        } else if (connectedBonds.size() == 3) {
            IAtomType type9;
            int doubleBondCount = this.countAttachedDoubleBonds(connectedBonds, atom);
            if (doubleBondCount == 2) {
                IAtomType type10 = this.getAtomType("I.5");
                if (this.isAcceptable(atom, atomContainer, type10, connectedBonds)) {
                    return type10;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && this.isAcceptable(atom, atomContainer, type9 = this.getAtomType("I.sp3d2.3"), connectedBonds)) {
                return type9;
            }
        } else if (connectedBonds.size() == 2) {
            IAtomType type11;
            IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
            if (maxBondOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type11 = this.getAtomType("I.3"), connectedBonds)) {
                return type11;
            }
        } else if (connectedBonds.size() <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("I"), connectedBonds)) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveRuthenium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type2 = this.getAtomType("Ru.6");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -2) {
            IAtomType type3 = this.getAtomType("Ru.2minus.6");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ru.3minus.6"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceivePotassium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
            IAtomType type = this.getAtomType("K.plus");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
            IAtomType type;
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("K.neutral"))) {
                return type;
            }
            type = this.getAtomType("K.metallic");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceivePlutonium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Pu"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveCadmium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
            IAtomType type = this.getAtomType("Cd.2plus");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type;
            if (atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type2 = this.getAtomType("Cd.metallic");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cd.2"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveIndium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 3) {
            IAtomType type = this.getAtomType("In.3");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atom.getFormalCharge() == 3 && atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type = this.getAtomType("In.3plus");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 1) {
            IAtomType type = this.getAtomType("In.1");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else {
            IAtomType type = this.getAtomType("In");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveChlorine(IAtomContainer atomContainer, IAtom atom, List<IBond> connectedBonds) throws CDKException {
        if (connectedBonds == null) {
            connectedBonds = atomContainer.getConnectedBondsList(atom);
        }
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            IAtomType type;
            if (connectedBonds.size() > 1) {
                IAtomType type2;
                if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Cl.plus.radical"), connectedBonds)) {
                    return type2;
                }
            } else if (connectedBonds.size() == 1) {
                IAtomType type3;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("Cl.plus.radical"), connectedBonds)) {
                    return type3;
                }
            } else if (connectedBonds.size() == 0 && (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cl.radical"), connectedBonds)) {
                return type;
            }
        } else if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
            IAtomType type;
            int neighborcount = connectedBonds.size();
            IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
            if (maxBondOrder == IBond.Order.DOUBLE) {
                IAtomType type4;
                if (neighborcount == 2) {
                    IAtomType type5 = this.getAtomType("Cl.2");
                    if (this.isAcceptable(atom, atomContainer, type5, connectedBonds)) {
                        return type5;
                    }
                } else if (neighborcount == 3) {
                    IAtomType type6 = this.getAtomType("Cl.chlorate");
                    if (this.isAcceptable(atom, atomContainer, type6, connectedBonds)) {
                        return type6;
                    }
                } else if (neighborcount == 4 && this.isAcceptable(atom, atomContainer, type4 = this.getAtomType("Cl.perchlorate"), connectedBonds)) {
                    return type4;
                }
            } else if (neighborcount <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cl"), connectedBonds)) {
                return type;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -1) {
            IAtomType type = this.getAtomType("Cl.minus");
            if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                return type;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
            IAtomType type;
            IBond.Order maxBondOrder = this.getMaximumBondOrder(connectedBonds);
            if (maxBondOrder == IBond.Order.DOUBLE) {
                IAtomType type7 = this.getAtomType("Cl.plus.sp2");
                if (this.isAcceptable(atom, atomContainer, type7, connectedBonds)) {
                    return type7;
                }
            } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cl.plus.sp3"), connectedBonds)) {
                return type;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3 && connectedBonds.size() == 4) {
            IAtomType type = this.getAtomType("Cl.perchlorate.charged");
            if (this.isAcceptable(atom, atomContainer, type, connectedBonds)) {
                return type;
            }
        } else {
            IAtomType type;
            int doubleBonds = this.countAttachedDoubleBonds(connectedBonds, atom);
            if (connectedBonds.size() == 3 && doubleBonds == 2) {
                IAtomType type8 = this.getAtomType("Cl.chlorate");
                if (this.isAcceptable(atom, atomContainer, type8, connectedBonds)) {
                    return type8;
                }
            } else if (connectedBonds.size() == 4 && doubleBonds == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cl.perchlorate"), connectedBonds)) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveSilver(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type2;
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 1 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Ag.1"))) {
                return type2;
            }
            type2 = this.getAtomType("Ag.neutral");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ag.plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveGold(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        int neighbors = atomContainer.getConnectedBondsCount(atom);
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && neighbors == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Au.1"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveRadium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ra.neutral"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveCalcium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if ("Ca".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type2 = this.getAtomType("Ca.2plus");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 2) {
                IAtomType type3 = this.getAtomType("Ca.2");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ca.1"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceivePlatinum(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 4) {
                IAtomType type = this.getAtomType("Pt.2plus.4");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IAtomType type = this.getAtomType("Pt.2plus");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            }
        } else if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
            IAtomType type;
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 2) {
                IAtomType type2 = this.getAtomType("Pt.2");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (neighbors == 4) {
                IAtomType type3 = this.getAtomType("Pt.4");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (neighbors == 6 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Pt.6"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveAntimony(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 3) {
            IAtomType type2 = this.getAtomType("Sb.3");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 4 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Sb.4"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveGadolinum(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3 && atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Gd.3plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveMagnesium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 4) {
                IAtomType type2 = this.getAtomType("Mg.neutral");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (neighbors == 2) {
                IAtomType type3 = this.getAtomType("Mg.neutral.2");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (neighbors == 1) {
                IAtomType type4 = this.getAtomType("Mg.neutral.1");
                if (this.isAcceptable(atom, atomContainer, type4)) {
                    return type4;
                }
            } else {
                IAtomType type5 = this.getAtomType("Mg.neutral");
                if (this.isAcceptable(atom, atomContainer, type5)) {
                    return type5;
                }
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Mg.2plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveThallium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type2 = this.getAtomType("Tl.plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type3 = this.getAtomType("Tl");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Tl.1"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveLead(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type2 = this.getAtomType("Pb.neutral");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type3 = this.getAtomType("Pb.2plus");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Pb.1"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveStrontium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Sr.2plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveTitanium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && atomContainer.getConnectedBondsCount(atom) == 6) {
            IAtomType type2 = this.getAtomType("Ti.3minus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && atomContainer.getConnectedBondsCount(atom) == 4) {
            IAtomType type3 = this.getAtomType("Ti.sp3");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ti.2"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveVanadium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && atomContainer.getConnectedBondsCount(atom) == 6) {
            IAtomType type2 = this.getAtomType("V.3minus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && atomContainer.getConnectedBondsCount(atom) == 4 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("V.3minus.4"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveBromine(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            IAtomType type2;
            IBond.Order maxBondOrder;
            if (atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type3;
                if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                    IAtomType type4 = this.getAtomType("Br.plus.radical");
                    if (this.isAcceptable(atom, atomContainer, type4)) {
                        return type4;
                    }
                } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("Br.radical"))) {
                    return type3;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) <= 1 && (maxBondOrder = atomContainer.getMaximumBondOrder(atom)) == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Br.plus.radical"))) {
                return type2;
            }
            return null;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() == -1) {
            IAtomType type5 = this.getAtomType("Br.minus");
            if (this.isAcceptable(atom, atomContainer, type5)) {
                return type5;
            }
        } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 1) {
            IAtomType type6;
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (maxBondOrder == IBond.Order.DOUBLE) {
                IAtomType type7 = this.getAtomType("Br.plus.sp2");
                if (this.isAcceptable(atom, atomContainer, type7)) {
                    return type7;
                }
            } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type6 = this.getAtomType("Br.plus.sp3"))) {
                return type6;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) == 1 || atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type8 = this.getAtomType("Br");
            if (this.isAcceptable(atom, atomContainer, type8)) {
                return type8;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Br.3"))) {
            return type;
        }
        return null;
    }

    private int countAttachedDoubleBonds(List<IBond> connectedAtoms, IAtom atom, String symbol) {
        return this.countAttachedBonds(connectedAtoms, atom, IBond.Order.DOUBLE, symbol);
    }

    private IAtomType perceiveCobalt(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
            IAtomType type = this.getAtomType("Co.2plus");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3) {
            IAtomType type = this.getAtomType("Co.3plus");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 2) {
                IAtomType type = this.getAtomType("Co.2");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (neighbors == 4) {
                IAtomType type = this.getAtomType("Co.4");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (neighbors == 6) {
                IAtomType type = this.getAtomType("Co.6");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (neighbors == 1) {
                IAtomType type = this.getAtomType("Co.1");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IAtomType type = this.getAtomType("Co.metallic");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            }
        } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 1) {
            int neighbors = atomContainer.getConnectedBondsCount(atom);
            if (neighbors == 2) {
                IAtomType type = this.getAtomType("Co.plus.2");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (neighbors == 4) {
                IAtomType type = this.getAtomType("Co.plus.4");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (neighbors == 1) {
                IAtomType type = this.getAtomType("Co.plus.1");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (neighbors == 6) {
                IAtomType type = this.getAtomType("Co.plus.6");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (neighbors == 5) {
                IAtomType type = this.getAtomType("Co.plus.5");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IAtomType type = this.getAtomType("Co.plus");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            }
        }
        return null;
    }

    private int countAttachedDoubleBonds(List<IBond> connectedBonds, IAtom atom) {
        return this.countAttachedBonds(connectedBonds, atom, IBond.Order.DOUBLE, null);
    }

    private int countAttachedSingleBonds(List<IBond> connectedBonds, IAtom atom) {
        return this.countAttachedBonds(connectedBonds, atom, IBond.Order.SINGLE, null);
    }

    private boolean hasAromaticBond(List<IBond> connectedBonds) {
        for (IBond bond : connectedBonds) {
            if (!bond.isAromatic()) continue;
            return true;
        }
        return false;
    }

    private int countAttachedBonds(List<IBond> connectedBonds, IAtom atom, IBond.Order order, String symbol) {
        int neighborcount = connectedBonds.size();
        int doubleBondedAtoms = 0;
        for (int i = neighborcount - 1; i >= 0; --i) {
            IBond bond = connectedBonds.get(i);
            if (bond.getOrder() != order || bond.getAtomCount() != 2) continue;
            if (symbol != null) {
                if (!bond.getOther(atom).getSymbol().equals(symbol)) continue;
                ++doubleBondedAtoms;
                continue;
            }
            ++doubleBondedAtoms;
        }
        return doubleBondedAtoms;
    }

    private IAtomType getAtomType(String identifier) throws CDKException {
        IAtomType type = this.factory.getAtomType(identifier);
        return type;
    }

    private boolean isAcceptable(IAtom atom, IAtomContainer container, IAtomType type) {
        return this.isAcceptable(atom, container, type, null);
    }

    private boolean isAcceptable(IAtom atom, IAtomContainer container, IAtomType type, List<IBond> connectedBonds) {
        int count;
        int requiredNeighbourCount;
        int hCount;
        int connectedAtoms;
        int actualNeighbourCount;
        int requiredContainerCount;
        int actualContainerCount;
        if (connectedBonds == null) {
            connectedBonds = container.getConnectedBondsList(atom);
        }
        if (this.mode == 2 ? (actualContainerCount = connectedBonds.size()) != (requiredContainerCount = type.getFormalNeighbourCount().intValue()) : atom.getImplicitHydrogenCount() != CDKConstants.UNSET && (actualNeighbourCount = (connectedAtoms = connectedBonds.size()) + (hCount = atom.getImplicitHydrogenCount().intValue())) > (requiredNeighbourCount = type.getFormalNeighbourCount().intValue())) {
            return false;
        }
        IBond.Order typeOrder = type.getMaxBondOrder();
        if (typeOrder != null) {
            for (IBond bond : connectedBonds) {
                IBond.Order order = bond.getOrder();
                if (order != CDKConstants.UNSET && order != IBond.Order.UNSET) {
                    if (!BondManipulator.isHigherOrder(order, typeOrder)) continue;
                    return false;
                }
                if (bond.getFlag(4096)) {
                    if (typeOrder == IBond.Order.SINGLE || typeOrder == IBond.Order.DOUBLE) continue;
                    return false;
                }
                return false;
            }
        }
        if (type.getValency() != CDKConstants.UNSET) {
            double valence = container.getBondOrderSum(atom);
            if (atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() != 0) {
                valence += (double)atom.getImplicitHydrogenCount().intValue();
            }
            if (valence > (double)type.getValency().intValue()) {
                return false;
            }
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && !atom.getFormalCharge().equals(type.getFormalCharge())) {
            return false;
        }
        return type.getProperty("cdk:Single Electron Count") == null || (count = this.countSingleElectrons(container, atom)) == type.getProperty("cdk:Single Electron Count", Integer.class);
    }
}

