/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private boolean isEnd = false;
    private int inWait = 0;
    private int buffer = 0;
    private int charsWritten = 0;
    private static final byte[] BASE64CHARS = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61};
    private static final byte PAD = 61;
    private static final byte[] CRLF = "\n".getBytes();
    private byte[] encodedBytes = new byte[4];

    public Base64OutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.isEnd = bl;
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer = this.buffer << 8 | n & 0xFF;
        if (++this.inWait == 3) {
            this.writeBytes();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (this.inWait < 3 && n2 > 0) {
            this.buffer = this.buffer << 8 | byArray[n++] & 0xFF;
            ++this.inWait;
            --n2;
        }
        if (this.inWait == 3) {
            this.writeBytes();
        }
        while (n2 >= 3) {
            this.buffer = this.buffer << 8 | byArray[n++] & 0xFF;
            this.buffer = this.buffer << 8 | byArray[n++] & 0xFF;
            this.buffer = this.buffer << 8 | byArray[n++] & 0xFF;
            this.encodedBytes[3] = BASE64CHARS[this.buffer & 0x3F];
            this.buffer >>= 6;
            this.encodedBytes[2] = BASE64CHARS[this.buffer & 0x3F];
            this.buffer >>= 6;
            this.encodedBytes[1] = BASE64CHARS[this.buffer & 0x3F];
            this.buffer >>= 6;
            this.encodedBytes[0] = BASE64CHARS[this.buffer & 0x3F];
            this.out.write(this.encodedBytes);
            if ((this.charsWritten += 4) == 76) {
                this.out.write(CRLF);
                this.charsWritten = 0;
            }
            n2 -= 3;
        }
        while (this.inWait < 3 && n2 > 0) {
            this.buffer = this.buffer << 8 | byArray[n++] & 0xFF;
            ++this.inWait;
            --n2;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void flush() throws IOException {
        if (this.isEnd) {
            this.completeEncoding();
            this.inWait = 0;
            this.buffer = 0;
            this.charsWritten = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.completeEncoding();
        this.out.close();
    }

    public boolean getFlushBehaviour() {
        return this.isEnd;
    }

    public void setFlushBehaviour(boolean bl) {
        this.isEnd = bl;
    }

    private void writeBytes() throws IOException {
        this.encodedBytes[3] = BASE64CHARS[this.buffer & 0x3F];
        this.buffer >>= 6;
        this.encodedBytes[2] = BASE64CHARS[this.buffer & 0x3F];
        this.buffer >>= 6;
        this.encodedBytes[1] = BASE64CHARS[this.buffer & 0x3F];
        this.buffer >>= 6;
        this.encodedBytes[0] = BASE64CHARS[this.buffer & 0x3F];
        this.inWait = 0;
        this.buffer = 0;
        this.out.write(this.encodedBytes);
        if ((this.charsWritten += 4) == 76) {
            this.out.write(CRLF);
            this.charsWritten = 0;
        }
    }

    private void completeEncoding() throws IOException {
        switch (this.inWait) {
            case 0: {
                return;
            }
            case 1: {
                this.buffer <<= 4;
                this.encodedBytes[2] = 61;
                this.encodedBytes[1] = BASE64CHARS[this.buffer & 0x3F];
                this.buffer >>= 6;
                this.encodedBytes[0] = BASE64CHARS[this.buffer & 0x3F];
                break;
            }
            case 2: {
                this.buffer <<= 2;
                this.encodedBytes[2] = BASE64CHARS[this.buffer & 0x3F];
                this.buffer >>= 6;
                this.encodedBytes[1] = BASE64CHARS[this.buffer & 0x3F];
                this.buffer >>= 6;
                this.encodedBytes[0] = BASE64CHARS[this.buffer & 0x3F];
            }
        }
        this.encodedBytes[3] = 61;
        this.out.write(this.encodedBytes);
        if ((this.charsWritten += 4) == 76) {
            this.out.write(CRLF);
            this.charsWritten = 0;
        }
        this.inWait = 0;
        this.buffer = 0;
    }
}

