/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.trees;

import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimTree;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.common.opres.graph.INodeLabel;
import choco.kernel.solver.variables.scheduling.ITask;

public abstract class AbstractVilimStatus<E>
implements INodeLabel {
    protected AbstractVilimTree.NodeType type;
    protected ITask task;
    protected final E status;

    public AbstractVilimStatus(AbstractVilimTree.NodeType type, E status) {
        this.status = status;
        this.type = type;
    }

    public final AbstractVilimTree.NodeType getType() {
        return this.type;
    }

    public final void setType(AbstractVilimTree.NodeType type) {
        this.type = type;
    }

    public final ITask getTask() {
        return this.task;
    }

    public void setTask(ITask task) {
        this.task = task;
    }

    public final E getStatus() {
        return this.status;
    }

    private String getDotStyle() {
        switch (this.getType()) {
            case LAMBDA: 
            case NIL: {
                return "filled";
            }
        }
        return "solid";
    }

    private String getFillColor() {
        switch (this.getType()) {
            case LAMBDA: {
                return "gray";
            }
            case NIL: {
                return "black";
            }
        }
        return "white";
    }

    private String getFontColor() {
        switch (this.getType()) {
            case NIL: {
                return "white";
            }
        }
        return "black";
    }

    private String getBorderColor() {
        switch (this.getType()) {
            case INTERNAL: {
                return "green";
            }
        }
        return "black";
    }

    protected int getResetIntValue(IVilimTree.TreeMode mode) {
        return mode.value() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
    }

    protected long getResetLongValue(IVilimTree.TreeMode mode) {
        return mode.value() ? Long.MIN_VALUE : Long.MAX_VALUE;
    }

    protected void writeRow(StringBuilder buffer, String label1, String str1, String label2, String str2) {
        buffer.append('{').append(label1).append('=').append(str1);
        buffer.append('|');
        buffer.append(label2).append('=').append(str2).append('}');
    }

    protected String format(int value) {
        return value == Integer.MIN_VALUE ? "-inf" : (value == Integer.MAX_VALUE ? "+inf" : String.valueOf(value));
    }

    protected String format(long value) {
        return value == Long.MIN_VALUE ? "-inf" : (value == Long.MAX_VALUE ? "+inf" : String.valueOf(value));
    }

    @Override
    public String toDotty() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("shape=Mrecord,");
        buffer.append("style=").append(this.getDotStyle());
        buffer.append(", fillcolor=").append(this.getFillColor());
        buffer.append(", fontcolor=").append(this.getFontColor());
        buffer.append(", color=").append(this.getBorderColor());
        buffer.append(", label=\"{");
        if (this.getTask() != null) {
            buffer.append(this.getTask().getName());
            buffer.append('|');
        }
        this.writeDotStatus(buffer);
        buffer.append("}\"");
        return new String(buffer);
    }

    protected abstract void writeDotStatus(StringBuilder var1);

    public abstract void reset();

    @Override
    public int getNbParameters() {
        return 3;
    }

    @Override
    public Object getParameter(int idx) {
        switch (idx) {
            case 0: {
                return this.type;
            }
            case 1: {
                return this.status;
            }
            case 2: {
                return this.task;
            }
        }
        return null;
    }

    @Override
    public void setParameter(int idx, Object parameter) {
        switch (idx) {
            case 0: {
                this.setType((AbstractVilimTree.NodeType)((Object)parameter));
                break;
            }
            case 1: {
                throw new UnsupportedOperationException("cant change status");
            }
            case 2: {
                this.setTask((ITask)parameter);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("index out of range");
            }
        }
    }
}

