/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.file;

import java.util.HashMap;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.AbstractDictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;

public abstract class AbstractPrincetonDictionaryFile
extends AbstractDictionaryFile {
    private static final String NOUN_EXT = "noun";
    private static final String VERB_EXT = "verb";
    private static final String ADJECTIVE_EXT = "adj";
    private static final String ADVERB_EXT = "adv";
    private static final Map _posToExtMap = new HashMap(4, 1.0f);
    private static final Map _fileTypeToFileNameMap;

    public AbstractPrincetonDictionaryFile() {
    }

    public AbstractPrincetonDictionaryFile(String path, POS pos, DictionaryFileType fileType) {
        super(path, pos, fileType);
    }

    protected String makeFilename() {
        String posString = this.getExtension(this.getPOS());
        if (this.getFileType() == DictionaryFileType.EXCEPTION || JWNL.getOS() == JWNL.WINDOWS) {
            return this.makeWindowsFilename(posString, this.getFileNames((DictionaryFileType)this.getFileType())._windowsFileTypeName);
        }
        return this.makeNonWindowsFilename(posString, this.getFileNames((DictionaryFileType)this.getFileType())._nonWindowsFileTypeName);
    }

    private String makeWindowsFilename(String posStr, String fileTypeStr) {
        return posStr + "." + fileTypeStr;
    }

    private String makeNonWindowsFilename(String posStr, String fileTypeStr) {
        return fileTypeStr + "." + posStr;
    }

    private String getExtension(POS pos) {
        return (String)_posToExtMap.get(pos);
    }

    private FileNames getFileNames(DictionaryFileType type) {
        return (FileNames)_fileTypeToFileNameMap.get(type);
    }

    static {
        _posToExtMap.put(POS.NOUN, NOUN_EXT);
        _posToExtMap.put(POS.VERB, VERB_EXT);
        _posToExtMap.put(POS.ADJECTIVE, ADJECTIVE_EXT);
        _posToExtMap.put(POS.ADVERB, ADVERB_EXT);
        _fileTypeToFileNameMap = new HashMap(3, 1.0f);
        _fileTypeToFileNameMap.put(DictionaryFileType.INDEX, new FileNames("idx", "index"));
        _fileTypeToFileNameMap.put(DictionaryFileType.DATA, new FileNames("dat", "data"));
        _fileTypeToFileNameMap.put(DictionaryFileType.EXCEPTION, new FileNames("exc", "exc"));
    }

    private static final class FileNames {
        String _windowsFileTypeName;
        String _nonWindowsFileTypeName;

        public FileNames(String windowsFileTypeName, String nonWindowsFileTypeName) {
            this._windowsFileTypeName = windowsFileTypeName;
            this._nonWindowsFileTypeName = nonWindowsFileTypeName;
        }
    }
}

