/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.PUBLIC;

import java.util.ArrayList;
import keel.Algorithms.Decision_Trees.PUBLIC.Split;
import keel.Algorithms.Decision_Trees.PUBLIC.myAttribute;

public class TreeNode {
    int identifier;
    TreeNode left;
    TreeNode right;
    boolean isLeaf;
    int outputClass;
    Split condition;

    TreeNode() {
        this.identifier = 0;
        this.left = null;
        this.right = null;
        this.isLeaf = false;
        this.outputClass = -1;
        this.condition = null;
    }

    TreeNode(int id, TreeNode newleft, TreeNode newright, boolean leaf, int oclass, Split cond) {
        this.identifier = id;
        this.left = newleft;
        this.right = newright;
        this.isLeaf = leaf;
        this.outputClass = oclass;
        this.condition = cond;
    }

    TreeNode(int id, boolean leaf, int oclass) {
        this.identifier = id;
        this.left = null;
        this.right = null;
        this.isLeaf = leaf;
        this.outputClass = oclass;
        this.condition = null;
    }

    TreeNode(TreeNode tree) {
        this.identifier = tree.identifier;
        this.left = new TreeNode(tree.left);
        this.right = new TreeNode(tree.right);
        this.isLeaf = tree.isLeaf;
        this.outputClass = tree.outputClass;
        this.condition = new Split(tree.condition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TreeNode test = (TreeNode)obj;
        return this.identifier == test.identifier && this.isLeaf == test.isLeaf && this.outputClass == test.outputClass && (this.left == test.left || this.left != null && this.left.equals(test.left)) && (this.right == test.right || this.right != null && this.right.equals(test.right)) && (this.condition == test.condition || this.condition != null && this.condition.equals(test.condition));
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.identifier;
        hash = 31 * hash + (null == this.left ? 0 : this.left.hashCode());
        hash = 31 * hash + (null == this.right ? 0 : this.right.hashCode());
        hash = 31 * hash + (this.isLeaf ? 1 : 0);
        hash = 31 * hash + this.outputClass;
        hash = 31 * hash + (null == this.condition ? 0 : this.condition.hashCode());
        return hash;
    }

    public String toString() {
        try {
            StringBuffer text = new StringBuffer();
            if (!this.isLeaf) {
                this.printTree(0, text);
            }
            return text.toString();
        }
        catch (Exception e) {
            return "Can not print the tree";
        }
    }

    private void printTree(int depth, StringBuffer text) throws Exception {
        String aux = "";
        for (int k = 0; k < depth; ++k) {
            aux = aux + "\t";
        }
        text.append(aux);
        if (this.isLeaf) {
            text.append(this.outputClass + " \n");
        } else {
            text.append("if (" + this.condition + ") then {\n");
            this.left.printTree(depth + 1, text);
            text.append(aux + "else { \n");
            this.right.printTree(depth + 1, text);
        }
        text.append(aux + "}\n");
    }

    public String printTree(ArrayList<myAttribute> atts, myAttribute outputAttribute) {
        try {
            StringBuffer text = new StringBuffer();
            if (!this.isLeaf) {
                this.printTree(0, text, atts, outputAttribute);
            }
            return text.toString();
        }
        catch (Exception e) {
            return "Can not print the tree.";
        }
    }

    private void printTree(int depth, StringBuffer text, ArrayList<myAttribute> atts, myAttribute outputAttribute) throws Exception {
        int k;
        String aux = "";
        String aux2 = "";
        for (k = 0; k < depth; ++k) {
            aux = aux + "\t";
        }
        for (k = 1; k < depth; ++k) {
            aux2 = aux2 + "\t";
        }
        text.append(aux);
        if (this.isLeaf) {
            if (outputAttribute.isNominal()) {
                text.append(outputAttribute.getValues().get(this.outputClass) + " \n");
            } else {
                text.append(this.outputClass + " \n");
            }
        } else {
            if (atts.get(this.condition.getAttribute()).isNominal()) {
                text.append("if (" + atts.get(this.condition.getAttribute()).getName() + " in " + atts.get(this.condition.getAttribute()).getValues().get((int)this.condition.getValue()) + ") then {\n");
            } else {
                text.append("if (" + atts.get(this.condition.getAttribute()).getName() + " < " + this.condition.getValue() + ") then {\n");
            }
            this.left.printTree(depth + 1, text, atts, outputAttribute);
            text.append(aux + "else { \n");
            this.right.printTree(depth + 1, text, atts, outputAttribute);
        }
        text.append(aux2 + "}\n");
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public TreeNode getLeft() {
        return this.left;
    }

    public void setLeft(TreeNode left) {
        this.left = left;
    }

    public TreeNode getRight() {
        return this.right;
    }

    public void setRight(TreeNode right) {
        this.right = right;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public int getOutputClass() {
        return this.outputClass;
    }

    public void setOutputClass(int outputClass) {
        this.outputClass = outputClass;
    }

    public Split getCondition() {
        return this.condition;
    }

    public void setCondition(Split condition) {
        this.condition = condition;
    }

    public TreeNode getNode(int id) {
        TreeNode aux = null;
        if (this == null) {
            return null;
        }
        if (this.identifier == id) {
            return this;
        }
        if (this.left != null) {
            aux = this.left.getNode(id);
        }
        if (aux == null && this.right != null) {
            aux = this.right.getNode(id);
        }
        return aux;
    }

    public int getNumNodes() {
        int nodes = 0;
        if (this.isLeaf) {
            nodes = 0;
        } else {
            ++nodes;
            if (this.left != null) {
                nodes += this.left.getNumNodes();
            }
            if (this.right != null) {
                nodes += this.right.getNumNodes();
            }
        }
        return nodes;
    }

    public int getLeafs() {
        int leafs = 0;
        if (this.isLeaf) {
            leafs = 1;
        } else {
            if (this.left != null) {
                leafs += this.left.getLeafs();
            }
            if (this.right != null) {
                leafs += this.right.getLeafs();
            }
        }
        return leafs;
    }

    public int evaluate(double[] ind, ArrayList<myAttribute> atts) {
        if (this.isLeaf) {
            return this.outputClass;
        }
        if (this.condition != null) {
            if (atts.get(this.condition.getAttribute()).isNominal()) {
                if (ind[this.condition.getAttribute()] == this.condition.getValue()) {
                    return this.left.evaluate(ind, atts);
                }
                return this.right.evaluate(ind, atts);
            }
            if (ind[this.condition.getAttribute()] < this.condition.getValue()) {
                return this.left.evaluate(ind, atts);
            }
            return this.right.evaluate(ind, atts);
        }
        System.err.println("Tree not fully built");
        System.exit(-1);
        return -1;
    }

    public ArrayList<Integer> deleteDescendants(int original_identifier) {
        ArrayList<Integer> nodes_deleted = new ArrayList<Integer>();
        if (this.left != null) {
            nodes_deleted.addAll(this.left.deleteDescendants(original_identifier));
        }
        if (this.right != null) {
            nodes_deleted.addAll(this.right.deleteDescendants(original_identifier));
        }
        this.left = null;
        this.right = null;
        this.condition = null;
        if (this.identifier != original_identifier) {
            nodes_deleted.add(this.identifier);
        }
        return nodes_deleted;
    }
}

