/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.List;

public interface IOutlierVariable
extends ITsVariable {
    @Override
    default public void data(TsDomain domain, List<DataBlock> data) {
        this.data(domain.getStart(), data.get(0));
    }

    @Override
    default public TsDomain getDefinitionDomain() {
        return null;
    }

    @Override
    default public TsFrequency getDefinitionFrequency() {
        return TsFrequency.Undefined;
    }

    @Override
    default public String getName() {
        return this.getDescription(TsFrequency.Undefined);
    }

    public void data(TsPeriod var1, DataBlock var2);

    @Deprecated
    default public OutlierType getOutlierType() {
        try {
            return OutlierType.valueOf(this.getCode());
        }
        catch (IllegalArgumentException err) {
            return OutlierType.Undefined;
        }
    }

    public String getCode();

    public Day getPosition();

    public FilterRepresentation getFilterRepresentation(int var1);

    public static class FilterRepresentation {
        public final RationalBackFilter filter;
        public final double correction;

        public FilterRepresentation(RationalBackFilter filter, double correction) {
            this.filter = filter;
            this.correction = correction;
        }
    }
}

